/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.tablestructure.Messages;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Column
extends AtomicIpsObjectPart
implements IColumn {
    static final String TAG_NAME = "Column";
    private String datatype = "";

    Column(TableStructure table, String id) {
        super(table, id);
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
        this.objectHasChanged();
    }

    @Override
    public boolean isRange() {
        return false;
    }

    @Override
    public String getAccessParameterName() {
        return this.name;
    }

    @Override
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(String newDatatype) {
        this.datatype = newDatatype;
        this.objectHasChanged();
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        String text;
        super.validateThis(list, ipsProject);
        ValidationUtils.checkStringPropertyNotEmpty(this.name, "name", this, "name", "", list);
        ValueDatatype type = ValidationUtils.checkValueDatatypeReference(this.datatype, false, this, "datatype", "", list);
        if (type == null) {
            return;
        }
        if (type.isPrimitive()) {
            text = Messages.Column_msgPrimitvesArentSupported;
            list.add(new Message("ATTRIBUTE-DatatypeIsAPrimitive", text, Message.ERROR, (Object)this, new String[]{"datatype"}));
        }
        if (!ValidationUtils.validateJavaIdentifier(StringUtils.uncapitalize((String)this.name), ipsProject)) {
            text = Messages.Column_msgInvalidName;
            list.add(new Message("ATTRIBUTE-InvalidName", text, Message.ERROR, (Object)this, new String[]{"name"}));
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("name");
        this.datatype = element.getAttribute("datatype");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        element.setAttribute("datatype", this.datatype);
    }

    @Override
    public IColumn[] getColumns() {
        return new IColumn[]{this};
    }

    @Override
    public ValueDatatype findValueDatatype(IIpsProject ipsProject) {
        return ipsProject.findValueDatatype(this.datatype);
    }
}

