/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.faktorips.devtools.abstraction.util.JavaConventions;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.tablestructure.Messages;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.ColumnRangeType;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColumnRange
extends AtomicIpsObjectPart
implements IColumnRange {
    static final String TAG_NAME = "Range";
    private String from = "";
    private String to = "";
    private ColumnRangeType rangeType = ColumnRangeType.TWO_COLUMN_RANGE;
    private String parameterName = "";

    public ColumnRange(TableStructure parent, String id) {
        super(parent, id);
    }

    TableStructure getTableStructureImpl() {
        return (TableStructure)this.getParent();
    }

    @Override
    public ITableStructure getTableStructure() {
        return (ITableStructure)this.getParent();
    }

    @Override
    public String getName() {
        return String.valueOf(this.from) + '-' + this.to;
    }

    @Override
    public boolean isRange() {
        return true;
    }

    @Override
    public String getAccessParameterName() {
        return this.getName();
    }

    @Override
    public String getFromColumn() {
        return this.from;
    }

    @Override
    public void setFromColumn(String columnName) {
        ArgumentCheck.notNull((Object)columnName);
        String oldColumnName = this.from;
        this.from = columnName;
        this.valueChanged(oldColumnName, this.from);
    }

    @Override
    public String getToColumn() {
        return this.to;
    }

    @Override
    public void setToColumn(String columnName) {
        ArgumentCheck.notNull((Object)columnName);
        String oldColumnName = this.to;
        this.to = columnName;
        this.valueChanged(oldColumnName, this.to);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        if (IpsStringUtils.isEmpty((String)this.parameterName)) {
            text = Messages.ColumnRange_msgParameterEmpty;
            list.add(new Message("", text, Message.ERROR, (Object)this, new String[]{"parameterName"}));
        } else if (!JavaConventions.validateName((String)this.parameterName)) {
            text = Messages.ColumnRange_msgNameInvalidJavaIdentifier;
            list.add(new Message("", text, Message.ERROR, (Object)this, new String[]{"parameterName"}));
        }
        String fromColumnDatatype = null;
        String toColumnDatatype = null;
        if (this.getTableStructureImpl().getColumn(this.from) != null) {
            fromColumnDatatype = this.getTableStructure().getColumn(this.from).getDatatype();
        }
        if (this.getTableStructureImpl().getColumn(this.to) != null) {
            toColumnDatatype = this.getTableStructure().getColumn(this.to).getDatatype();
        }
        if (this.rangeType.isTwoColumn() || this.rangeType.isOneColumnFrom()) {
            this.validateColumn(this.from, "fromColumn", "from column", list);
        }
        if (this.rangeType.isTwoColumn() || this.rangeType.isOneColumnTo()) {
            this.validateColumn(this.to, "toColumn", "to column", list);
        }
        this.validateTwoColumnSameDatatype(list, fromColumnDatatype, toColumnDatatype);
    }

    protected void validateColumn(String column, String propertyName, String propertyDisplayName, MessageList list) {
        if (ValidationUtils.checkStringPropertyNotEmpty(column, propertyDisplayName, this, propertyName, "", list) && this.getTableStructure().getColumn(column) == null) {
            String text = MessageFormat.format(Messages.ColumnRange_msgMissingColumn, column);
            list.add(new Message("", text, Message.ERROR, (Object)this, new String[]{propertyName}));
        }
    }

    protected void validateTwoColumnSameDatatype(MessageList list, String fromColumnDatatype, String toColumnDatatype) {
        if (this.rangeType.isTwoColumn() && toColumnDatatype != null && fromColumnDatatype != null && !toColumnDatatype.equals(fromColumnDatatype)) {
            String text = MessageFormat.format(Messages.ColumnRange_msgTwoColumnRangeFromToColumnWithDifferentDatatype, this.to);
            list.add(new Message("COLUMN_RANGE-TwoColumnRangeFromToColumnWithDifferentDatatype", text, Message.ERROR, (Object)this));
        }
    }

    @Override
    public void setColumnRangeType(ColumnRangeType rangeType) {
        ArgumentCheck.notNull((Object)rangeType);
        ColumnRangeType oldValue = this.rangeType;
        this.rangeType = rangeType;
        this.valueChanged(oldValue, rangeType);
    }

    @Override
    public ColumnRangeType getColumnRangeType() {
        return this.rangeType;
    }

    @Override
    public String getDatatype() {
        if (this.rangeType.isTwoColumn() || this.rangeType.isOneColumnFrom()) {
            return this.getDatatype(this.getFromColumn());
        }
        return this.getDatatype(this.getToColumn());
    }

    private String getDatatype(String columnName) {
        IColumn column = this.getTableStructure().getColumn(columnName);
        if (column != null) {
            return column.getDatatype();
        }
        return null;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        ArgumentCheck.notNull((Object)parameterName);
        String oldParameterName = this.parameterName;
        this.parameterName = parameterName;
        this.valueChanged(oldParameterName, parameterName);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.rangeType = ColumnRangeType.getValueById(element.getAttribute("columnRangeType"));
        this.from = element.getAttribute("fromColumn");
        this.to = element.getAttribute("toColumn");
        this.parameterName = element.getAttribute("parameterName");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("columnRangeType", this.rangeType.getId());
        if (IpsStringUtils.isNotBlank((String)this.from)) {
            element.setAttribute("fromColumn", this.from);
        }
        if (IpsStringUtils.isNotBlank((String)this.to)) {
            element.setAttribute("toColumn", this.to);
        }
        element.setAttribute("parameterName", this.parameterName);
    }

    @Override
    public IColumn[] getColumns() {
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        if (!this.rangeType.isOneColumnTo() && this.getTableStructure().getColumn(this.from) != null) {
            columns.add(this.getTableStructure().getColumn(this.from));
        }
        if (!this.rangeType.isOneColumnFrom() && this.getTableStructure().getColumn(this.to) != null) {
            columns.add(this.getTableStructure().getColumn(this.to));
        }
        return columns.toArray(new IColumn[columns.size()]);
    }
}

