/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import java.text.MessageFormat;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.tablestructure.Key;
import org.faktorips.devtools.model.internal.tablestructure.Messages;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.IForeignKey;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForeignKey
extends Key
implements IForeignKey {
    static final String TAG_NAME = "ForeignKey";
    private String refTableStructure = "";
    private String refUniqueKey = "";

    public ForeignKey(TableStructure tableStructure, String id) {
        super(tableStructure, id);
    }

    public ForeignKey() {
    }

    @Override
    public String getName() {
        StringBuilder buffer = new StringBuilder(this.refTableStructure);
        buffer.append('(');
        buffer.append(this.refUniqueKey);
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String getReferencedTableStructure() {
        return this.refTableStructure;
    }

    @Override
    public void setReferencedTableStructure(String tableStructure) {
        String oldValue = this.refTableStructure;
        this.refTableStructure = tableStructure;
        this.valueChanged(oldValue, this.refTableStructure);
    }

    @Override
    public ITableStructure findReferencedTableStructure(IIpsProject ipsProject) {
        return (ITableStructure)ipsProject.findIpsObject(IpsObjectType.TABLE_STRUCTURE, this.refTableStructure);
    }

    @Override
    public String getReferencedUniqueKey() {
        return this.refUniqueKey;
    }

    @Override
    public void setReferencedUniqueKey(String uniqueKey) {
        String oldValue = this.refUniqueKey;
        this.refUniqueKey = uniqueKey;
        this.valueChanged(oldValue, this.refUniqueKey);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ValidationUtils.checkIpsObjectReference(this.refTableStructure, IpsObjectType.TABLE_STRUCTURE, "referenced table", this, "referencedTableStructure", "", list);
        ITableStructure structure = (ITableStructure)this.getIpsProject().findIpsObject(IpsObjectType.TABLE_STRUCTURE, this.refTableStructure);
        if (structure != null) {
            if (!ValidationUtils.checkStringPropertyNotEmpty(this.refUniqueKey, "referenced unique key", this, "referencedUniqueKey", "", list)) {
                return;
            }
            IIndex uk = structure.getUniqueKey(this.refUniqueKey);
            if (uk == null) {
                String text = MessageFormat.format(Messages.ForeignKey_msgMissingUniqueKey, this.refTableStructure, this.refUniqueKey);
                list.add(new Message("", text, Message.ERROR, (Object)this, new String[]{"referencedUniqueKey"}));
            } else if (uk.getNumOfKeyItems() != this.getNumOfKeyItems()) {
                String text = Messages.ForeignKey_msgMalformedForeignKey;
                list.add(new Message("", text, Message.ERROR, (Object)this, new String[]{"referencedUniqueKey"}));
            } else {
                String[] ukItems = uk.getKeyItemNames();
                String[] fkItems = this.getKeyItemNames();
                int i = 0;
                while (i < fkItems.length) {
                    this.validateKeyItem(fkItems[i], structure, ipsProject, ukItems[i], list);
                    ++i;
                }
            }
        }
    }

    private void validateKeyItem(String fkItem, ITableStructure refStructure, IIpsProject ipsProject, String refItem, MessageList list) {
        IColumnRange range = this.getTableStructure().getRange(fkItem);
        if (range != null) {
            this.validateRangeItem(range, refStructure, ipsProject, refItem, list);
            return;
        }
        IColumn column = this.getTableStructure().getColumn(fkItem);
        if (column != null) {
            this.validateColumnItem(column, refStructure, refItem, list);
            return;
        }
        String text = MessageFormat.format(Messages.ForeignKey_msgInvalidKeyItem, fkItem);
        list.add(new Message("", text, Message.ERROR, (Object)fkItem));
    }

    private void validateRangeItem(IColumnRange item, ITableStructure refStructure, IIpsProject ipsProject, String refItem, MessageList list) {
        IColumn column = refStructure.getColumn(refItem);
        if (column != null) {
            String text = Messages.ForeignKey_msgKeyItemMissmatch;
            list.add(new Message("", text, Message.ERROR, (Object)item.getName()));
            return;
        }
        IColumnRange refRange = refStructure.getRange(refItem);
        if (refRange == null) {
            String text = MessageFormat.format(Messages.ForeignKey_msgNotARange, refItem);
            list.add(new Message("", text, Message.WARNING, (Object)item.getName()));
            return;
        }
        MessageList ml = item.validate(ipsProject);
        if (!ml.isEmpty()) {
            list.add(ml);
            return;
        }
        this.validateReferencedColumn(item, refStructure, list, refRange);
    }

    private void validateReferencedColumn(IColumnRange item, ITableStructure refStructure, MessageList list, IColumnRange refRange) {
        String text;
        IColumn from = this.getTableStructure().getColumn(item.getFromColumn());
        IColumn to = this.getTableStructure().getColumn(item.getToColumn());
        IColumn refFrom = refStructure.getColumn(refRange.getFromColumn());
        IColumn refTo = refStructure.getColumn(refRange.getToColumn());
        if (from != null && refFrom != null && !from.getDatatype().equals(refFrom.getDatatype())) {
            text = MessageFormat.format(Messages.ForeignKey_msgForeignKeyDatatypeMismatch, from.getName(), refFrom);
            list.add(new Message("", text, Message.ERROR, (Object)item.getName()));
        } else if (from == null == (refFrom != null)) {
            String text2 = Messages.ForeignKey_msgInvalidRange;
            list.add(new Message("", text2, Message.WARNING, (Object)item.getName()));
            return;
        }
        if (to != null && refFrom != null && !to.getDatatype().equals(refTo.getDatatype())) {
            text = MessageFormat.format(Messages.ForeignKey_msgForeignKeyDatatypeMismatch, to.getName(), refTo);
            list.add(new Message("", text, Message.ERROR, (Object)item.getName()));
        } else if (to == null == (refTo != null)) {
            text = Messages.ForeignKey_msgReferencedRangeInvalid;
            list.add(new Message("", text, Message.WARNING, (Object)item.getName()));
        }
    }

    private void validateColumnItem(IColumn item, ITableStructure refStructure, String refItem, MessageList list) {
        IColumnRange range = refStructure.getRange(refItem);
        if (range != null) {
            String text = Messages.ForeignKey_msgKeyMissmatch;
            list.add(new Message("", text, Message.ERROR, (Object)item.getName()));
            return;
        }
        IColumn refColumn = refStructure.getColumn(refItem);
        if (refColumn == null) {
            String text = MessageFormat.format(Messages.ForeignKey_msgNotAColumn, refItem);
            list.add(new Message("", text, Message.WARNING, (Object)item.getName()));
            return;
        }
        if (!item.getDatatype().equals(refColumn.getDatatype())) {
            String text = MessageFormat.format(Messages.ForeignKey_msgKeyDatatypeMismatch, item.getName(), refItem);
            list.add(new Message("", text, Message.ERROR, (Object)item.getName()));
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.refTableStructure = element.getAttribute("referencedTableStructure");
        this.refUniqueKey = element.getAttribute("referencedUniqueKey");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("referencedTableStructure", this.refTableStructure);
        element.setAttribute("referencedUniqueKey", this.refUniqueKey);
    }
}

