/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.internal.tablestructure.Key;
import org.faktorips.devtools.model.internal.tablestructure.Messages;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.ColumnRangeType;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Index
extends Key
implements IIndex {
    static final String TAG_NAME = "Index";
    private static final String XML_ATTRIBUTE_UNIQUE_KEY = "uniqueKey";
    private boolean uniqueKey = true;

    public Index(TableStructure tableStructure, String id) {
        super(tableStructure, id);
    }

    public Index() {
    }

    @Override
    public String getName() {
        return IpsStringUtils.join((Object[])this.getKeyItemNames());
    }

    private void validateItemSequence(MessageList msgList) {
        if (this.containsRanges() && this.containsColumns()) {
            IKeyItem[] keyItems = this.getKeyItems();
            boolean rangeFound = false;
            boolean wrongSequenceFound = false;
            int potentiallyWrongKeyElement = -1;
            int j = 0;
            while (j < keyItems.length) {
                if (this.getTableStructure().getRange(keyItems[j].getName()) != null) {
                    rangeFound = true;
                    potentiallyWrongKeyElement = j;
                } else if (rangeFound) {
                    wrongSequenceFound = true;
                    break;
                }
                ++j;
            }
            if (wrongSequenceFound) {
                msgList.add(new Message("", Messages.Index_wrong_sequence, Message.ERROR, new ObjectProperty((Object)this, "keyItems", potentiallyWrongKeyElement)));
            }
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        if (this.getNumOfKeyItems() == 0) {
            String text = Messages.Index_msgTooLessItems;
            list.add(new Message("TooLessItems", text, Message.ERROR, (Object)this));
        }
        String[] items = this.getKeyItemNames();
        int i = 0;
        while (i < items.length) {
            this.validateItem(items[i], i, list);
            ++i;
        }
        this.validateItemSequence(list);
    }

    private void validateItem(String item, int itemmIndex, MessageList list) {
        IColumn column = this.getTableStructure().getColumn(item);
        if (column != null) {
            return;
        }
        IColumnRange range = this.getTableStructure().getRange(item);
        if (range != null) {
            return;
        }
        String text = MessageFormat.format(Messages.Index_msgKeyItemMismatch, item);
        list.add(new Message("KeyItemMismatch", text, Message.ERROR, new ObjectProperty((Object)this, "keyItems", itemmIndex)));
    }

    @Override
    public boolean containsRangesOnly() {
        String[] items;
        String[] stringArray = items = this.getKeyItemNames();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (this.getTableStructure().hasColumn(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean containsRanges() {
        String[] items;
        String[] stringArray = items = this.getKeyItemNames();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (this.getTableStructure().hasRange(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsTwoColumnRanges() {
        IKeyItem[] keyItems;
        IKeyItem[] iKeyItemArray = keyItems = this.getKeyItems();
        int n = keyItems.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnRange[] ranges;
            IKeyItem keyItem = iKeyItemArray[n2];
            IColumnRange[] iColumnRangeArray = ranges = this.getTableStructure().getRanges();
            int n3 = ranges.length;
            int n4 = 0;
            while (n4 < n3) {
                IColumnRange range = iColumnRangeArray[n4];
                if (ColumnRangeType.TWO_COLUMN_RANGE.equals(range.getColumnRangeType()) && keyItem.getName().equals(range.getName())) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsColumns() {
        String[] items;
        String[] stringArray = items = this.getKeyItemNames();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (this.getTableStructure().hasColumn(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    public List<String> getDatatypes() {
        ArrayList<String> keyDatatype = new ArrayList<String>();
        IKeyItem[] iKeyItemArray = this.getKeyItems();
        int n = iKeyItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IKeyItem keyItem = iKeyItemArray[n2];
            keyDatatype.add(keyItem.getDatatype());
            ++n2;
        }
        return keyDatatype;
    }

    @Override
    public boolean isUniqueKey() {
        return this.uniqueKey;
    }

    @Override
    public void setUniqueKey(boolean unique) {
        boolean oldValue = this.uniqueKey;
        this.uniqueKey = unique;
        this.valueChanged(oldValue, this.uniqueKey, XML_ATTRIBUTE_UNIQUE_KEY);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.uniqueKey) {
            element.setAttribute(XML_ATTRIBUTE_UNIQUE_KEY, "" + this.uniqueKey);
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.uniqueKey = XmlUtil.getBooleanAttributeOrFalse(element, XML_ATTRIBUTE_UNIQUE_KEY);
    }
}

