/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.IKey;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.devtools.model.util.CollectionUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class Key
extends AtomicIpsObjectPart
implements IKey {
    static final String KEY_ITEM_TAG_NAME = "Item";
    private List<String> items = new ArrayList<String>(0);
    private List<IKeyItem> keyItems = new ArrayList<IKeyItem>();

    public Key(TableStructure tableStructure, String id) {
        super(tableStructure, id);
    }

    protected Key() {
    }

    @Override
    public ITableStructure getTableStructure() {
        return (ITableStructure)this.getParent();
    }

    @Override
    public String[] getKeyItemNames() {
        return this.items.toArray(new String[this.items.size()]);
    }

    @Override
    public IKeyItem[] getKeyItems() {
        return this.keyItems.toArray(new IKeyItem[this.keyItems.size()]);
    }

    private void updateKeyItems() {
        this.keyItems = new ArrayList<IKeyItem>();
        for (String item : this.items) {
            IKeyItem keyItem = this.getKeyItem(item);
            if (keyItem == null) continue;
            this.keyItems.add(keyItem);
        }
    }

    private IKeyItem getKeyItem(String item) {
        IKeyItem keyItem = null;
        if (this.getTableStructure() != null) {
            IColumn c = this.getTableStructure().getColumn(item);
            if (c != null) {
                keyItem = c;
            } else {
                IColumnRange range = this.getTableStructure().getRange(item);
                if (range != null) {
                    keyItem = range;
                }
            }
            return keyItem;
        }
        return null;
    }

    @Override
    public void setKeyItems(String[] itemNames) {
        this.items = CollectionUtil.toArrayList(itemNames);
        this.updateKeyItems();
        this.objectHasChanged();
    }

    @Override
    public void addKeyItem(String name) {
        this.items.add(name);
        IKeyItem keyItem = this.getKeyItem(name);
        if (keyItem != null) {
            this.keyItems.add(keyItem);
        }
        this.objectHasChanged();
    }

    @Override
    public void removeKeyItem(String name) {
        this.items.remove(name);
        IKeyItem keyItem = this.getKeyItem(name);
        if (keyItem != null) {
            this.keyItems.remove(keyItem);
        }
        this.objectHasChanged();
    }

    @Override
    public int getNumOfKeyItems() {
        return this.items.size();
    }

    @Override
    public IKeyItem[] getItemCandidates() {
        return this.getItemCandidates(this.getTableStructure());
    }

    private IKeyItem[] getItemCandidates(ITableStructure tableStructure) {
        ArrayList<IKeyItem> result = new ArrayList<IKeyItem>();
        this.addCandidates(result, tableStructure.getColumns());
        this.addCandidates(result, tableStructure.getRanges());
        return result.toArray(new IKeyItem[result.size()]);
    }

    private void addCandidates(List<IKeyItem> result, IKeyItem[] items) {
        IKeyItem[] iKeyItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IKeyItem item = iKeyItemArray[n2];
            if (this.isCandidate(item)) {
                result.add(item);
            }
            ++n2;
        }
    }

    private boolean isCandidate(IKeyItem candidateItem) {
        for (String keyItem : this.items) {
            if (!keyItem.equals(candidateItem.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        NodeList nl = element.getElementsByTagName(KEY_ITEM_TAG_NAME);
        this.items = new ArrayList<String>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Element itemElement = (Element)nl.item(i);
            String item = itemElement.getAttribute("name");
            this.items.add(item);
            ++i;
        }
        this.updateKeyItems();
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        for (String item : this.items) {
            Element itemElement = element.getOwnerDocument().createElement(KEY_ITEM_TAG_NAME);
            itemElement.setAttribute("name", item);
            element.appendChild(itemElement);
        }
    }

    @Override
    public int getIndexForKeyItem(IKeyItem item) {
        int indexOfKeyItem = this.keyItems.indexOf(item);
        if (indexOfKeyItem >= 0) {
            return indexOfKeyItem;
        }
        throw new IllegalArgumentException("The provided item: " + item + " is not part of the list of items hold by this key.");
    }

    @Override
    public int getIndexForKeyItemName(String itemName) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).equals(itemName)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("The provided item name: " + itemName + " doesn't match with one of the items" + " in the itme list of this key.");
    }

    @Override
    public IKeyItem getKeyItemAt(int index) {
        return this.getKeyItems()[index];
    }

    @Override
    public String getNameOfKeyItemAt(int index) {
        return this.items.get(index);
    }
}

