/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.faktorips.devtools.model.internal.tablestructure.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.util.ArgumentCheck;

public class TableAccessFunction
implements ITableAccessFunction {
    private final ITableStructure tableStructure;
    private final String description;
    private final String type;
    private final List<String> argTypeNames;
    private final IColumn column;

    public TableAccessFunction(IIndex key, IColumn column) {
        ArgumentCheck.notNull((Object)key);
        ArgumentCheck.notNull((Object)column);
        this.column = column;
        this.tableStructure = key.getTableStructure();
        this.type = column.getDatatype();
        StringBuilder params = new StringBuilder();
        IKeyItem[] items = key.getKeyItems();
        ArrayList<String> tmpArgTypes = new ArrayList<String>();
        IKeyItem[] iKeyItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IKeyItem item = iKeyItemArray[n2];
            if (!tmpArgTypes.isEmpty()) {
                params.append(", ");
            }
            params.append(item.getAccessParameterName());
            tmpArgTypes.add(item.getDatatype());
            ++n2;
        }
        this.argTypeNames = Collections.unmodifiableList(tmpArgTypes);
        this.description = MessageFormat.format(Messages.TableAccessFunctionDescription, params, column.getName());
    }

    @Override
    public ITableStructure getTableStructure() {
        return this.tableStructure;
    }

    @Override
    public String getAccessedColumnName() {
        return this.column.getName();
    }

    @Override
    public IColumn getAccessedColumn() {
        return this.column;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getArgTypes() {
        return this.argTypeNames;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.tableStructure.getIpsProject();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.argTypeNames.hashCode();
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.tableStructure == null ? 0 : this.tableStructure.hashCode());
        return 31 * result + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableAccessFunction other = (TableAccessFunction)obj;
        return Objects.equals(this.argTypeNames, other.argTypeNames) && Objects.equals(this.column, other.column) && Objects.equals(this.description, other.description) && Objects.equals(this.tableStructure, other.tableStructure) && Objects.equals(this.type, other.type);
    }
}

