/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablestructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.DatatypeDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.tablestructure.Column;
import org.faktorips.devtools.model.internal.tablestructure.ColumnRange;
import org.faktorips.devtools.model.internal.tablestructure.ForeignKey;
import org.faktorips.devtools.model.internal.tablestructure.Index;
import org.faktorips.devtools.model.internal.tablestructure.TableAccessFunction;
import org.faktorips.devtools.model.internal.util.TreeSetHelper;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.IForeignKey;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKey;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.devtools.model.tablestructure.TableStructureType;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public class TableStructure
extends IpsObject
implements ITableStructure {
    private TableStructureType type = TableStructureType.MULTIPLE_CONTENTS;
    private List<IColumn> columns = new ArrayList<IColumn>(2);
    private List<IColumnRange> ranges = new ArrayList<IColumnRange>(0);
    private List<IIndex> indices = new ArrayList<IIndex>(1);
    private List<IForeignKey> foreignKeys = new ArrayList<IForeignKey>(0);

    public TableStructure(IIpsSrcFile file) {
        super(file);
    }

    public TableStructure() {
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        ArrayList<DatatypeDependency> dependencies = new ArrayList<DatatypeDependency>();
        for (IColumn column : this.columns) {
            String datatype = column.getDatatype();
            DatatypeDependency dependency = new DatatypeDependency(this.getQualifiedNameType(), datatype);
            dependencies.add(dependency);
            this.addDetails(details, dependency, column, "datatype");
        }
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    @Override
    public boolean isMultipleContentsAllowed() {
        return this.type == TableStructureType.MULTIPLE_CONTENTS;
    }

    @Override
    public void setTableStructureType(TableStructureType type) {
        if (type == null) {
            return;
        }
        TableStructureType oldType = this.type;
        this.type = type;
        this.valueChanged((Object)oldType, (Object)type);
    }

    @Override
    public TableStructureType getTableStructureType() {
        return this.type;
    }

    @Override
    public IColumn[] getColumns() {
        IColumn[] c = new IColumn[this.columns.size()];
        this.columns.toArray(c);
        return c;
    }

    @Override
    public IColumn getColumn(String name) {
        for (IColumn column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    @Override
    public IColumn getColumn(int index) {
        return this.columns.get(index);
    }

    @Override
    public int getNumOfColumns() {
        return this.columns.size();
    }

    @Override
    public IColumn newColumn() {
        IColumn newColumn = this.newColumnInternal(this.getNextPartId());
        this.objectHasChanged();
        return newColumn;
    }

    @Override
    public int[] moveColumns(int[] indexes, boolean up) {
        ListElementMover<IColumn> mover = new ListElementMover<IColumn>(this.columns);
        int[] result = mover.move(indexes, up);
        this.objectHasChanged();
        return result;
    }

    private IColumn newColumnInternal(String id) {
        Column newColumn = new Column(this, id);
        this.columns.add(newColumn);
        return newColumn;
    }

    void removeColumn(IColumn column) {
        this.columns.remove(column);
    }

    @Override
    public int getColumnIndex(IColumn column) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i) == column) {
                return i;
            }
            ++i;
        }
        throw new IpsException("Can't get index for column " + column);
    }

    @Override
    public int getColumnIndex(String columnName) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i).getName().equals(columnName)) {
                return i;
            }
            ++i;
        }
        throw new IpsException("Can't get index for column " + columnName);
    }

    @Override
    public IColumnRange[] getRanges() {
        IColumnRange[] c = new IColumnRange[this.ranges.size()];
        this.ranges.toArray(c);
        return c;
    }

    @Override
    public IColumnRange getRange(String name) {
        for (IColumnRange range : this.ranges) {
            if (!range.getName().equals(name)) continue;
            return range;
        }
        return null;
    }

    @Override
    public int getNumOfRanges() {
        return this.ranges.size();
    }

    @Override
    public IColumnRange newRange() {
        IColumnRange newRange = this.newColumnRangeInternal(this.getNextPartId());
        this.objectHasChanged();
        return newRange;
    }

    @Override
    public int[] moveRanges(int[] indexes, boolean up) {
        ListElementMover<IColumnRange> mover = new ListElementMover<IColumnRange>(this.ranges);
        int[] result = mover.move(indexes, up);
        this.objectHasChanged();
        return result;
    }

    private IColumnRange newColumnRangeInternal(String id) {
        ColumnRange newRange = new ColumnRange(this, id);
        this.ranges.add(newRange);
        return newRange;
    }

    void removeRange(IColumnRange range) {
        this.ranges.remove(range);
    }

    @Override
    public IIndex[] getUniqueKeys() {
        ArrayList<IIndex> result = new ArrayList<IIndex>();
        for (IIndex index : this.indices) {
            if (!index.isUniqueKey()) continue;
            result.add(index);
        }
        return result.toArray(new IIndex[result.size()]);
    }

    @Override
    public IIndex getUniqueKey(String name) {
        for (IIndex key : this.indices) {
            if (!key.isUniqueKey() || !key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    @Override
    public int getNumOfUniqueKeys() {
        return this.getUniqueKeys().length;
    }

    @Override
    public List<IIndex> getIndices() {
        return Collections.unmodifiableList(this.indices);
    }

    @Override
    public IIndex getIndex(String name) {
        for (IIndex key : this.indices) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    @Override
    public int getNumOfIndices() {
        return this.indices.size();
    }

    @Override
    public IIndex newIndex() {
        IIndex newIndex = this.newIndexInternal(this.getNextPartId());
        this.objectHasChanged();
        return newIndex;
    }

    @Override
    public int[] moveIndex(int[] indexes, boolean up) {
        ListElementMover<IIndex> mover = new ListElementMover<IIndex>(this.indices);
        int[] result = mover.move(indexes, up);
        this.objectHasChanged();
        return result;
    }

    private IIndex newIndexInternal(String id) {
        Index newIndex = new Index(this, id);
        this.indices.add(newIndex);
        return newIndex;
    }

    void removeIndex(IIndex index) {
        this.indices.remove(index);
    }

    @Override
    public IForeignKey[] getForeignKeys() {
        IForeignKey[] keys = new IForeignKey[this.foreignKeys.size()];
        this.foreignKeys.toArray(keys);
        return keys;
    }

    @Override
    public IForeignKey getForeignKey(String name) {
        for (IForeignKey key : this.foreignKeys) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    @Override
    public int getNumOfForeignKeys() {
        return this.foreignKeys.size();
    }

    @Override
    public IForeignKey newForeignKey() {
        IForeignKey newForeignKey = this.newForeignKeyInternal(this.getNextPartId());
        this.objectHasChanged();
        return newForeignKey;
    }

    @Override
    public int[] moveForeignKeys(int[] indexes, boolean up) {
        ListElementMover<IForeignKey> mover = new ListElementMover<IForeignKey>(this.foreignKeys);
        int[] result = mover.move(indexes, up);
        this.objectHasChanged();
        return result;
    }

    private IForeignKey newForeignKeyInternal(String id) {
        ForeignKey newForeignKey = new ForeignKey(this, id);
        this.foreignKeys.add(newForeignKey);
        return newForeignKey;
    }

    void removeForeignKey(IForeignKey key) {
        this.foreignKeys.remove(key);
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.TABLE_STRUCTURE;
    }

    @Override
    public boolean hasRange(String name) {
        return this.getRange(name) != null;
    }

    @Override
    public boolean hasColumn(String name) {
        return this.getColumn(name) != null;
    }

    @Override
    public ITableAccessFunction[] getAccessFunctions() {
        if (this.indices.size() == 0) {
            return new ITableAccessFunction[0];
        }
        ArrayList<ITableAccessFunction> functions = new ArrayList<ITableAccessFunction>();
        for (IIndex index : this.indices) {
            IColumn[] columnsNotInKey;
            IColumn[] iColumnArray = columnsNotInKey = this.getColumnsNotInKey(index);
            int n = columnsNotInKey.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn element = iColumnArray[n2];
                functions.add(this.createFunction(index, element));
                ++n2;
            }
        }
        return functions.toArray(new ITableAccessFunction[functions.size()]);
    }

    private ITableAccessFunction createFunction(IIndex key, IColumn column) {
        return new TableAccessFunction(key, column);
    }

    @Override
    public IColumn[] getColumnsNotInKey(IKey key) {
        IKeyItem[] items;
        ArgumentCheck.notNull((Object)key);
        ArrayList<IColumn> columnsNotInKey = new ArrayList<IColumn>(this.columns);
        IKeyItem[] iKeyItemArray = items = key.getKeyItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn[] columnsInItem;
            IKeyItem item = iKeyItemArray[n2];
            IColumn[] iColumnArray = columnsInItem = item.getColumns();
            int n3 = columnsInItem.length;
            int n4 = 0;
            while (n4 < n3) {
                IColumn element = iColumnArray[n4];
                columnsNotInKey.remove(element);
                ++n4;
            }
            ++n2;
        }
        return columnsNotInKey.toArray(new IColumn[columnsNotInKey.size()]);
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        newElement.setAttribute("tableStructureType", this.type.getId());
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        String typeId = element.getAttribute("tableStructureType");
        if (IpsStringUtils.isNotEmpty((String)typeId)) {
            this.type = TableStructureType.getTypeForId(typeId);
        }
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        int size = this.columns.size() + this.ranges.size() + this.indices.size() + this.foreignKeys.size();
        ArrayList<IIpsObjectPartContainer> children = new ArrayList<IIpsObjectPartContainer>(size);
        children.addAll(this.columns);
        children.addAll(this.ranges);
        children.addAll(this.indices);
        children.addAll(this.foreignKeys);
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.columns.clear();
        this.ranges.clear();
        this.indices.clear();
        this.foreignKeys.clear();
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IColumn) {
            this.columns.add((IColumn)part);
            return true;
        }
        if (part instanceof IColumnRange) {
            this.ranges.add((IColumnRange)part);
            return true;
        }
        if (part instanceof IIndex) {
            this.indices.add((IIndex)part);
            return true;
        }
        if (part instanceof IForeignKey) {
            this.foreignKeys.add((IForeignKey)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof IColumn) {
            this.columns.remove(part);
            return true;
        }
        if (part instanceof IColumnRange) {
            this.ranges.remove(part);
            return true;
        }
        if (part instanceof IIndex) {
            this.indices.remove(part);
            return true;
        }
        if (part instanceof IForeignKey) {
            this.foreignKeys.remove(part);
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if ("Column".equals(xmlTagName)) {
            return this.newColumnInternal(id);
        }
        if ("Range".equals(xmlTagName)) {
            return this.newColumnRangeInternal(id);
        }
        if ("Index".equals(xmlTagName)) {
            return this.newIndexInternal(id);
        }
        if ("ForeignKey".equals(xmlTagName)) {
            return this.newForeignKeyInternal(id);
        }
        return this.newPartForDeprecatedXml(xmlTagName, id);
    }

    @Deprecated
    private IIpsObjectPart newPartForDeprecatedXml(String xmlTagName, String id) {
        if ("UniqueKey".equals(xmlTagName)) {
            IIndex newIndex = this.newIndexInternal(id);
            newIndex.setUniqueKey(true);
            return newIndex;
        }
        return null;
    }

    @Override
    public IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (partType.equals(IColumn.class)) {
            return this.newColumnInternal(this.getNextPartId());
        }
        if (partType.equals(IColumnRange.class)) {
            return this.newColumnRangeInternal(this.getNextPartId());
        }
        if (partType.equals(IIndex.class)) {
            return this.newIndexInternal(this.getNextPartId());
        }
        if (partType.equals(IForeignKey.class)) {
            return this.newForeignKeyInternal(this.getNextPartId());
        }
        return null;
    }

    @Override
    public Collection<IIpsSrcFile> searchMetaObjectSrcFiles(boolean includeSubtypes) {
        IIpsProject[] searchProjects;
        TreeSet<IIpsSrcFile> result = TreeSetHelper.newIpsSrcFileTreeSet();
        IIpsProject[] iIpsProjectArray = searchProjects = this.getIpsProject().findReferencingProjectLeavesOrSelf();
        int n = searchProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject project = iIpsProjectArray[n2];
            result.addAll(project.findAllTableContentsSrcFiles(this));
            ++n2;
        }
        return result;
    }

    @Override
    public boolean hasIndexWithSameDatatype() {
        HashSet<List<String>> keysDatatypes = new HashSet<List<String>>();
        for (IIndex index : this.indices) {
            List<String> keyDatatype = index.getDatatypes();
            if (keysDatatypes.contains(keyDatatype)) {
                return true;
            }
            keysDatatypes.add(keyDatatype);
        }
        return false;
    }

    public ValueDatatype[] findColumnDatatypes(IIpsProject ipsProject) {
        ValueDatatype[] datatypes = new ValueDatatype[this.columns.size()];
        int i = 0;
        for (IColumn column : this.columns) {
            datatypes[i++] = column.findValueDatatype(ipsProject);
        }
        return datatypes;
    }
}

