/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import java.text.MessageFormat;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.testcase.Messages;
import org.faktorips.devtools.model.internal.testcase.TestCase;
import org.faktorips.devtools.model.internal.testcase.TestObject;
import org.faktorips.devtools.model.internal.testcase.TestPolicyCmpt;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.IConfiguredDefault;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.testcase.ITestAttributeValue;
import org.faktorips.devtools.model.testcase.ITestPolicyCmpt;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestAttributeValue
extends AtomicIpsObjectPart
implements ITestAttributeValue {
    public static final String TAG_NAME = "AttributeValue";
    private static final TestParameterType DEFAULT_TYPE = TestParameterType.COMBINED;
    private String testAttribute = "";
    private String value = "";

    public TestAttributeValue(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    public ITestPolicyCmpt getTestPolicyCmpt() {
        return (ITestPolicyCmpt)this.getParent();
    }

    @Override
    public String getTestAttribute() {
        return this.testAttribute;
    }

    @Override
    public void setTestAttribute(String testAttribute) {
        String oldTestAttribute = this.testAttribute;
        this.testAttribute = testAttribute;
        this.valueChanged(oldTestAttribute, testAttribute);
    }

    @Override
    public ITestAttribute findTestAttribute(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.testAttribute)) {
            return null;
        }
        ITestPolicyCmpt testPolicyCmpt = this.getTestPolicyCmpt();
        ITestPolicyCmptTypeParameter typeParam = testPolicyCmpt.findTestPolicyCmptTypeParameter(ipsProject);
        if (typeParam == null) {
            return null;
        }
        return typeParam.getTestAttribute(this.testAttribute);
    }

    @Override
    public IAttribute findAttribute(IIpsProject ipsProject) {
        ITestAttribute testAttr = this.findTestAttribute(ipsProject);
        if (testAttr == null) {
            return null;
        }
        ITestPolicyCmpt testPolicyCmpt = this.getTestPolicyCmpt();
        if (!IpsStringUtils.isEmpty((String)testPolicyCmpt.getPolicyCmptType())) {
            IPolicyCmptType policyCmptType = testPolicyCmpt.findPolicyCmptType();
            if (policyCmptType == null) {
                return null;
            }
            return policyCmptType.findAttribute(testAttr.getAttribute(), ipsProject);
        }
        if (!testPolicyCmpt.isProductRelevant()) {
            return testAttr.findAttribute(ipsProject);
        }
        return testPolicyCmpt.findProductCmptTypeAttribute(testAttr.getAttribute(), ipsProject);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public void setDefaultValue() {
        IAttribute modelAttribute = this.findAttribute(this.getIpsProject());
        if (modelAttribute == null) {
            return;
        }
        if (this.isInputAttribute(this.getIpsProject())) {
            this.setValue(modelAttribute.getDefaultValue());
        } else {
            ValueDatatype datatype = modelAttribute.findDatatype(this.getIpsProject());
            if (datatype != null) {
                this.setValue(datatype.getDefaultValue());
            }
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.testAttribute = element.getAttribute("testAttribute");
        this.value = ValueToXmlHelper.getValueFromElement((Element)element, (String)"Value");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("testAttribute", this.testAttribute);
        ValueToXmlHelper.addValueToElement((String)this.value, (Element)element, (String)"Value");
    }

    @Override
    public boolean isExpectedResultAttribute(IIpsProject ipsProject) {
        return this.isTypeOrDefault(TestParameterType.EXPECTED_RESULT, DEFAULT_TYPE, ipsProject);
    }

    @Override
    public boolean isInputAttribute(IIpsProject ipsProject) {
        return this.isTypeOrDefault(TestParameterType.INPUT, DEFAULT_TYPE, ipsProject);
    }

    private boolean isTypeOrDefault(TestParameterType type, TestParameterType defaultType, IIpsProject ipsProject) {
        try {
            TestObject parent = (TestObject)this.getParent();
            TestCase testCase = (TestCase)parent.getRoot().getParent();
            ITestCaseType testCaseType = testCase.findTestCaseType(ipsProject);
            if (testCaseType == null) {
                return type.equals((Object)defaultType);
            }
            ITestAttribute attribute = this.findTestAttribute(ipsProject);
            if (this.testAttribute == null) {
                return type.equals((Object)defaultType);
            }
            if (attribute.isInputAttribute() && type.equals((Object)TestParameterType.INPUT) || attribute.isExpextedResultAttribute() && type.equals((Object)TestParameterType.EXPECTED_RESULT)) {
                return true;
            }
        }
        catch (IpsException ipsException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void updateDefaultTestAttributeValue() {
        IProductCmptGeneration generation = ((TestPolicyCmpt)this.getParent()).findProductCmpsCurrentGeneration(this.getParent().getIpsProject());
        this.setDefaultTestAttributeValueInternal(generation);
    }

    void setDefaultTestAttributeValueInternal(IProductCmptGeneration generation) {
        IIpsProject ipsProject = this.getIpsProject();
        ITestAttribute attribute = this.findTestAttribute(ipsProject);
        if (attribute == null) {
            return;
        }
        IPolicyCmptTypeAttribute modelAttribute = attribute.findAttribute(ipsProject);
        if (modelAttribute != null) {
            IConfiguredDefault ce;
            boolean defaultSet = false;
            if (modelAttribute.isProductRelevant() && generation != null && modelAttribute.getAttributeType().equals((Object)AttributeType.CHANGEABLE) && (ce = generation.getConfiguredDefault(modelAttribute.getName())) != null) {
                this.setValue(ce.getValue());
                defaultSet = true;
            }
            if (!defaultSet) {
                this.setValue(modelAttribute.getDefaultValue());
                defaultSet = true;
            }
        } else {
            ValueDatatype datatype = attribute.findDatatype(ipsProject);
            if (datatype != null) {
                this.setValue(datatype.getDefaultValue());
            } else {
                this.setValue(null);
            }
        }
    }

    @Override
    protected void validateThis(MessageList messageList, IIpsProject ipsProject) {
        super.validateThis(messageList, ipsProject);
        ITestAttribute testAttr = this.findTestAttribute(ipsProject);
        if (testAttr == null) {
            String text = MessageFormat.format(Messages.TestAttributeValue_ValidateError_TestAttributeNotFound, this.getTestAttribute());
            Message msg = new Message("TESTATTRIBUTEVALUE-TestAttributeNotFound", text, Message.ERROR, (Object)this, new String[]{"value"});
            messageList.add(msg);
        } else {
            if (testAttr.isBasedOnModelAttribute()) {
                IAttribute attribute = this.findAttribute(ipsProject);
                if (attribute == null && !IpsStringUtils.isEmpty((String)this.value)) {
                    String text = MessageFormat.format(Messages.TestAttributeValue_ValidateError_AttributeNotFound, testAttr.getAttribute());
                    Message msg = new Message("TESTATTRIBUTE-AttributeNotFound", text, Message.WARNING, (Object)this, new String[]{"value"});
                    messageList.add(msg);
                }
                if (attribute != null) {
                    ValidationUtils.checkValue(attribute.getDatatype(), this.value, this, "value", messageList);
                }
            } else {
                ValidationUtils.checkValue(testAttr.getDatatype(), this.value, this, "value", messageList);
            }
            if (!testAttr.isInputAttribute() && !testAttr.isExpextedResultAttribute()) {
                String text = MessageFormat.format(Messages.TestAttributeValue_Error_WrongType, testAttr.getName());
                Message msg = new Message("TESTATTRIBUTE-WrongType", text, Message.WARNING, (Object)this, new String[]{"value"});
                messageList.add(msg);
            }
        }
    }

    @Override
    public String getName() {
        return this.getTestAttribute();
    }
}

