/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.testcase.Messages;
import org.faktorips.devtools.model.internal.testcase.TestAttributeValue;
import org.faktorips.devtools.model.internal.testcase.TestCaseHierarchyPath;
import org.faktorips.devtools.model.internal.testcase.TestCaseTestCaseTypeDelta;
import org.faktorips.devtools.model.internal.testcase.TestObject;
import org.faktorips.devtools.model.internal.testcase.TestPolicyCmpt;
import org.faktorips.devtools.model.internal.testcase.TestRule;
import org.faktorips.devtools.model.internal.testcase.TestValue;
import org.faktorips.devtools.model.internal.testcasetype.TestValueParameter;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.testcase.ITestAttributeValue;
import org.faktorips.devtools.model.testcase.ITestCase;
import org.faktorips.devtools.model.testcase.ITestCaseTestCaseTypeDelta;
import org.faktorips.devtools.model.testcase.ITestObject;
import org.faktorips.devtools.model.testcase.ITestPolicyCmpt;
import org.faktorips.devtools.model.testcase.ITestPolicyCmptLink;
import org.faktorips.devtools.model.testcase.ITestRule;
import org.faktorips.devtools.model.testcase.ITestValue;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.ITestValueParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.devtools.model.type.ITypeHierarchy;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public class TestCase
extends IpsObject
implements ITestCase {
    private String testCaseTypeName = "";
    private List<IIpsObjectPart> testObjects = new ArrayList<IIpsObjectPart>();

    public TestCase(IIpsSrcFile file) {
        super(file);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return this.testObjects.toArray(new IIpsElement[this.testObjects.size()]);
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.testObjects.clear();
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof ITestObject) {
            this.testObjects.add(part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof ITestObject) {
            this.removeTestObject((ITestObject)part);
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if ("PolicyCmptTypeObject".equals(xmlTagName)) {
            return this.newTestPolicyCmptInternal(id);
        }
        if ("ValueObject".equals(xmlTagName)) {
            return this.newTestValueInternal(id);
        }
        if ("RuleObject".equals(xmlTagName)) {
            return this.newTestRuleInternal(id);
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.TEST_CASE;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.testCaseTypeName = element.getAttribute("testCaseType");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("testCaseType", this.testCaseTypeName);
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        ITestPolicyCmpt[] testCmpts;
        HashSet<IpsObjectDependency> dependencies = new HashSet<IpsObjectDependency>();
        if (IpsStringUtils.isNotEmpty((String)this.testCaseTypeName)) {
            IpsObjectDependency dependency = IpsObjectDependency.createInstanceOfDependency(this.getQualifiedNameType(), new QualifiedNameType(this.testCaseTypeName, IpsObjectType.TEST_CASE_TYPE));
            dependencies.add(dependency);
            this.addDetails(details, dependency, this, "testCaseType");
        }
        ITestPolicyCmpt[] iTestPolicyCmptArray = testCmpts = this.getTestPolicyCmpts();
        int n = testCmpts.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmpt testCmpt = iTestPolicyCmptArray[n2];
            this.addDependenciesForTestPolicyCmpt(dependencies, details, testCmpt);
            ++n2;
        }
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    private void addDependenciesForTestPolicyCmpt(Set<IpsObjectDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details, ITestPolicyCmpt cmpt) {
        ITestPolicyCmptLink[] testLinks;
        if (cmpt == null) {
            return;
        }
        if (cmpt.hasProductCmpt()) {
            IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(this.getQualifiedNameType(), new QualifiedNameType(cmpt.getProductCmpt(), IpsObjectType.PRODUCT_CMPT));
            dependencies.add(dependency);
            this.addDetails(details, dependency, cmpt, "productCmpt");
        }
        ITestPolicyCmptLink[] iTestPolicyCmptLinkArray = testLinks = cmpt.getTestPolicyCmptLinks();
        int n = testLinks.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptLink testLink = iTestPolicyCmptLinkArray[n2];
            if (testLink.isComposition()) {
                this.addDependenciesForTestPolicyCmpt(dependencies, details, testLink.findTarget());
            }
            ++n2;
        }
    }

    @Override
    public ITestPolicyCmpt[] getAllTestPolicyCmpt() {
        ITestPolicyCmpt[] testCmpts;
        ArrayList<ITestPolicyCmpt> allPolicyCmpts = new ArrayList<ITestPolicyCmpt>();
        ITestPolicyCmpt[] iTestPolicyCmptArray = testCmpts = this.getTestPolicyCmpts();
        int n = testCmpts.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmpt testCmpt = iTestPolicyCmptArray[n2];
            this.addChildTestPolicyCmpt(allPolicyCmpts, testCmpt);
            ++n2;
        }
        return allPolicyCmpts.toArray(new ITestPolicyCmpt[allPolicyCmpts.size()]);
    }

    @Override
    public ITestObject[] getAllTestObjects() {
        ITestPolicyCmpt[] testPolicyCmpts = this.getAllTestPolicyCmpt();
        ITestRule[] testRuleObjects = this.getTestRuleObjects();
        ITestValue[] testValues = this.getTestValues();
        ITestObject[] result = new ITestObject[testPolicyCmpts.length + testRuleObjects.length + testValues.length];
        System.arraycopy(testPolicyCmpts, 0, result, 0, testPolicyCmpts.length);
        System.arraycopy(testRuleObjects, 0, result, testPolicyCmpts.length, testRuleObjects.length);
        System.arraycopy(testValues, 0, result, testRuleObjects.length + testPolicyCmpts.length, testValues.length);
        return result;
    }

    private void addChildTestPolicyCmpt(List<ITestPolicyCmpt> allPolicyCmpts, ITestPolicyCmpt cmpt) {
        ITestPolicyCmptLink[] testLinks;
        allPolicyCmpts.add(cmpt);
        ITestPolicyCmptLink[] iTestPolicyCmptLinkArray = testLinks = cmpt.getTestPolicyCmptLinks();
        int n = testLinks.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptLink testLink = iTestPolicyCmptLinkArray[n2];
            if (testLink.isComposition()) {
                this.addChildTestPolicyCmpt(allPolicyCmpts, testLink.findTarget());
            }
            ++n2;
        }
    }

    @Override
    public String[] getReferencedProductCmpts() {
        ITestPolicyCmpt[] allTestPolicyCmpt;
        ArrayList<String> relatedProductCmpts = new ArrayList<String>();
        ITestPolicyCmpt[] iTestPolicyCmptArray = allTestPolicyCmpt = this.getAllTestPolicyCmpt();
        int n = allTestPolicyCmpt.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmpt element = iTestPolicyCmptArray[n2];
            if (element.hasProductCmpt()) {
                relatedProductCmpts.add(element.getProductCmpt());
            }
            ++n2;
        }
        return relatedProductCmpts.toArray(new String[relatedProductCmpts.size()]);
    }

    @Override
    public String getTestCaseType() {
        return this.testCaseTypeName;
    }

    @Override
    public void setTestCaseType(String testCaseType) {
        String oldTestCaseType = this.testCaseTypeName;
        this.testCaseTypeName = testCaseType;
        this.valueChanged(oldTestCaseType, testCaseType);
    }

    @Override
    public ITestCaseType findTestCaseType(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.testCaseTypeName) || ipsProject == null) {
            return null;
        }
        return (ITestCaseType)ipsProject.findIpsObject(IpsObjectType.TEST_CASE_TYPE, this.testCaseTypeName);
    }

    @Override
    public ITestCaseTestCaseTypeDelta computeDeltaToModel(IIpsProject ipsProject) {
        ITestCaseType testCaseTypeFound = this.findTestCaseType(ipsProject);
        if (testCaseTypeFound != null) {
            return new TestCaseTestCaseTypeDelta(this, testCaseTypeFound);
        }
        return null;
    }

    @Override
    public boolean containsDifferenceToModel(IIpsProject ipsProject) {
        ITestCaseTestCaseTypeDelta delta = this.computeDeltaToModel(ipsProject);
        return delta != null && !delta.isEmpty();
    }

    @Override
    public void fixAllDifferencesToModel(IIpsProject ipsProject) {
        this.computeDeltaToModel(ipsProject).fixAllDifferencesToModel();
    }

    @Override
    public void fixDifferences(ITestCaseTestCaseTypeDelta delta) {
        this.fixDifferencesTestCaseSide(delta);
        this.fixDifferencesTestCaseTypeSide(delta);
        this.fixDifferentOrder(delta);
    }

    private void fixDifferentOrder(ITestCaseTestCaseTypeDelta delta) {
        if (delta.isDifferentTestParameterOrder()) {
            ITestPolicyCmpt cmpt;
            ITestPolicyCmpt[] cmpts;
            this.sortTestObjects();
            ITestPolicyCmpt[] iTestPolicyCmptArray = cmpts = delta.getTestPolicyCmptWithDifferentSortOrder();
            int n = cmpts.length;
            int n2 = 0;
            while (n2 < n) {
                cmpt = iTestPolicyCmptArray[n2];
                ((TestPolicyCmpt)cmpt).fixDifferentChildSortOrder();
                ++n2;
            }
            iTestPolicyCmptArray = cmpts = delta.getTestPolicyCmptWithDifferentSortOrderTestAttr();
            n = cmpts.length;
            n2 = 0;
            while (n2 < n) {
                cmpt = iTestPolicyCmptArray[n2];
                ((TestPolicyCmpt)cmpt).fixDifferentTestAttrValueSortOrder();
                ++n2;
            }
            this.objectHasChanged();
        }
    }

    private void fixDifferencesTestCaseTypeSide(ITestCaseTestCaseTypeDelta delta) {
        IDescribedElement element;
        ITestValueParameter[] testValueParametersWithMissingTestValue = delta.getTestValueParametersWithMissingTestValue();
        ITestPolicyCmptTypeParameter[] testPolicyCmptTypeParametersWithMissingTestPolicyCmpt = delta.getTestPolicyCmptTypeParametersWithMissingTestPolicyCmpt();
        ITestAttribute[] testAttributesWithMissingTestAttributeValue = delta.getTestAttributesWithMissingTestAttributeValue();
        IDescribedElement[] iDescribedElementArray = testValueParametersWithMissingTestValue;
        int n = testValueParametersWithMissingTestValue.length;
        int n2 = 0;
        while (n2 < n) {
            element = iDescribedElementArray[n2];
            ITestValue testValue = this.newTestValue();
            testValue.setTestValueParameter(element.getName());
            ValueDatatype valueDatatype = ((TestValueParameter)element).findValueDatatype(this.getIpsProject());
            if (valueDatatype != null) {
                testValue.setValue(valueDatatype.getDefaultValue());
            }
            ++n2;
        }
        iDescribedElementArray = testPolicyCmptTypeParametersWithMissingTestPolicyCmpt;
        n = testPolicyCmptTypeParametersWithMissingTestPolicyCmpt.length;
        n2 = 0;
        while (n2 < n) {
            element = iDescribedElementArray[n2];
            if (!element.isRoot()) {
                throw new RuntimeException("Merge of child test test policy cmpts is not supported!");
            }
            this.addRootTestPolicyCmpt((ITestPolicyCmptTypeParameter)element);
            ++n2;
        }
        iDescribedElementArray = testAttributesWithMissingTestAttributeValue;
        n = testAttributesWithMissingTestAttributeValue.length;
        n2 = 0;
        while (n2 < n) {
            ITestPolicyCmpt[] testPolicyCmpts;
            element = iDescribedElementArray[n2];
            ITestPolicyCmpt[] iTestPolicyCmptArray = testPolicyCmpts = delta.getTestPolicyCmptForMissingTestAttribute((ITestAttribute)element);
            int n3 = testPolicyCmpts.length;
            int n4 = 0;
            while (n4 < n3) {
                ITestPolicyCmpt testPolicyCmpt = iTestPolicyCmptArray[n4];
                ITestAttributeValue testAttributeValue = testPolicyCmpt.newTestAttributeValue();
                testAttributeValue.setTestAttribute(element.getName());
                IProductCmptGeneration generation = ((TestPolicyCmpt)testPolicyCmpt).findProductCmpsCurrentGeneration(testPolicyCmpt.getIpsProject());
                ((TestAttributeValue)testAttributeValue).setDefaultTestAttributeValueInternal(generation);
                ++n4;
            }
            ++n2;
        }
    }

    public ITestPolicyCmpt addRootTestPolicyCmpt(ITestPolicyCmptTypeParameter testPolicyCmptTypeParameter) {
        ITestAttribute[] attrs;
        String name = testPolicyCmptTypeParameter.getName();
        ITestPolicyCmpt testPolicyCpmt = this.newTestPolicyCmpt();
        testPolicyCpmt.setTestPolicyCmptTypeParameter(name);
        testPolicyCpmt.setName(name);
        ITestAttribute[] iTestAttributeArray = attrs = testPolicyCmptTypeParameter.getTestAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttribute attr = iTestAttributeArray[n2];
            ITestAttributeValue testAttributeValue = testPolicyCpmt.newTestAttributeValue();
            testAttributeValue.setTestAttribute(attr.getName());
            testAttributeValue.updateDefaultTestAttributeValue();
            ++n2;
        }
        this.sortTestObjects();
        return testPolicyCpmt;
    }

    private void fixDifferencesTestCaseSide(ITestCaseTestCaseTypeDelta delta) {
        IIpsObjectPart element;
        ITestValue[] testValuesWithMissingTestValueParam = delta.getTestValuesWithMissingTestValueParam();
        ITestPolicyCmpt[] testPolicyCmptsWithMissingTypeParam = delta.getTestPolicyCmptsWithMissingTypeParam();
        ITestPolicyCmptLink[] testPolicyCmptLinksWithMissingTypeParam = delta.getTestPolicyCmptLinkWithMissingTypeParam();
        ITestAttributeValue[] testAttributeValuesWithMissingTestAttribute = delta.getTestAttributeValuesWithMissingTestAttribute();
        ITestRule[] testRulesWithMissingTestRuleParam = delta.getTestRulesWithMissingTestValueParam();
        IIpsObjectPart[] iIpsObjectPartArray = testValuesWithMissingTestValueParam;
        int n = testValuesWithMissingTestValueParam.length;
        int n2 = 0;
        while (n2 < n) {
            element = iIpsObjectPartArray[n2];
            element.delete();
            ++n2;
        }
        iIpsObjectPartArray = testRulesWithMissingTestRuleParam;
        n = testRulesWithMissingTestRuleParam.length;
        n2 = 0;
        while (n2 < n) {
            element = iIpsObjectPartArray[n2];
            element.delete();
            ++n2;
        }
        iIpsObjectPartArray = testPolicyCmptsWithMissingTypeParam;
        n = testPolicyCmptsWithMissingTypeParam.length;
        n2 = 0;
        while (n2 < n) {
            element = iIpsObjectPartArray[n2];
            element.delete();
            ++n2;
        }
        iIpsObjectPartArray = testPolicyCmptLinksWithMissingTypeParam;
        n = testPolicyCmptLinksWithMissingTypeParam.length;
        n2 = 0;
        while (n2 < n) {
            element = iIpsObjectPartArray[n2];
            element.delete();
            ++n2;
        }
        iIpsObjectPartArray = testAttributeValuesWithMissingTestAttribute;
        n = testAttributeValuesWithMissingTestAttribute.length;
        n2 = 0;
        while (n2 < n) {
            element = iIpsObjectPartArray[n2];
            element.delete();
            ++n2;
        }
    }

    @Override
    public void sortTestObjects() {
        List<IIpsObjectPart> orderedTestObject = this.getCorrectSortOrderOfRootObjects(this.getIpsProject());
        if (orderedTestObject != null) {
            this.testObjects = orderedTestObject;
            this.objectHasChanged();
        }
    }

    private List<IIpsObjectPart> getCorrectSortOrderOfRootObjects(IIpsProject ipsProject) {
        ITestParameter[] testParameters;
        ArrayList<IIpsObjectPart> newTestObjectOrder = new ArrayList<IIpsObjectPart>(this.testObjects.size());
        HashMap<ITestParameter, List> oldTestObject = new HashMap<ITestParameter, List>(this.testObjects.size());
        for (IIpsObjectPart iIpsObjectPart : this.testObjects) {
            ITestObject testObject = (ITestObject)iIpsObjectPart;
            String testParameterName = "";
            ITestParameter testParameter = null;
            if (testObject instanceof ITestPolicyCmpt) {
                testParameterName = ((ITestPolicyCmpt)testObject).getTestPolicyCmptTypeParameter();
                testParameter = ((ITestPolicyCmpt)testObject).findTestPolicyCmptTypeParameter(ipsProject);
            } else if (testObject instanceof ITestValue) {
                testParameterName = ((ITestValue)testObject).getTestValueParameter();
                testParameter = ((ITestValue)testObject).findTestValueParameter(ipsProject);
            } else if (testObject instanceof ITestRule) {
                testParameterName = ((ITestRule)testObject).getTestRuleParameter();
                testParameter = ((ITestRule)testObject).findTestRuleParameter(ipsProject);
            } else {
                throw new RuntimeException("Unsupported test object type: " + testObject.getClass());
            }
            if (testParameter == null) {
                throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCase_Error_TestParameterNotFound, testParameterName)));
            }
            List oldObjectsToTestParam = oldTestObject.computeIfAbsent(testParameter, $ -> new ArrayList(1));
            oldObjectsToTestParam.add(testObject);
        }
        ITestCaseType testCaseType = this.findTestCaseType(ipsProject);
        ITestParameter[] iTestParameterArray = testParameters = testCaseType.getTestParameters();
        int n = testParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITestParameter testParameter = iTestParameterArray[n2];
            List oldObjectsToTestParam = (List)oldTestObject.get(testParameter);
            if (oldObjectsToTestParam != null) {
                newTestObjectOrder.addAll(oldObjectsToTestParam);
            }
            ++n2;
        }
        return newTestObjectOrder;
    }

    @Override
    public ITestValue newTestValue() {
        ITestValue v = this.newTestValueInternal(this.getNextPartId());
        this.objectHasChanged();
        return v;
    }

    @Override
    public ITestRule newTestRule() {
        ITestRule v = this.newTestRuleInternal(this.getNextPartId());
        this.objectHasChanged();
        return v;
    }

    @Override
    public ITestPolicyCmpt newTestPolicyCmpt() {
        ITestPolicyCmpt p = this.newTestPolicyCmptInternal(this.getNextPartId());
        this.objectHasChanged();
        return p;
    }

    @Override
    public ITestObject[] getTestObjects() {
        List<TestObject> foundTestObjects = this.getTestObjects(null, null, null);
        if (foundTestObjects.size() == 0) {
            return new ITestObject[0];
        }
        return foundTestObjects.toArray(new ITestObject[0]);
    }

    @Override
    public ITestPolicyCmpt[] getTestPolicyCmpts() {
        return this.getTestObjects(null, TestPolicyCmpt.class, null).toArray(new ITestPolicyCmpt[0]);
    }

    @Override
    public ITestValue[] getTestValues() {
        return this.getTestObjects(null, TestValue.class, null).toArray(new ITestValue[0]);
    }

    @Override
    public ITestRule[] getTestRule(String testRuleParameter) {
        List<TestObject> testRules = this.getTestObjects(null, TestRule.class, null);
        ArrayList<ITestRule> result = new ArrayList<ITestRule>();
        for (TestObject testObject : testRules) {
            ITestRule element = (ITestRule)((Object)testObject);
            if (!element.getTestParameterName().equals(testRuleParameter)) continue;
            result.add(element);
        }
        return result.toArray(new ITestRule[0]);
    }

    @Override
    public ITestRule[] getTestRuleObjects() {
        return this.getTestObjects(null, TestRule.class, null).toArray(new ITestRule[0]);
    }

    @Override
    public ITestObject[] getInputTestObjects() {
        return this.getTestObjects(TestParameterType.INPUT, null, null).toArray(new ITestObject[0]);
    }

    @Override
    public ITestValue[] getInputTestValues() {
        return this.getTestObjects(TestParameterType.INPUT, TestValue.class, null).toArray(new ITestValue[0]);
    }

    @Override
    public ITestPolicyCmpt[] getInputTestPolicyCmpts() {
        return this.getTestObjects(TestParameterType.INPUT, TestPolicyCmpt.class, null).toArray(new ITestPolicyCmpt[0]);
    }

    @Override
    public ITestObject[] getExpectedResultTestObjects() {
        return this.getTestObjects(TestParameterType.EXPECTED_RESULT, null, null).toArray(new ITestObject[0]);
    }

    @Override
    public ITestValue[] getExpectedResultTestValues() {
        return this.getTestObjects(TestParameterType.EXPECTED_RESULT, TestValue.class, null).toArray(new ITestValue[0]);
    }

    @Override
    public ITestRule[] getExpectedResultTestRules() {
        return this.getTestObjects(TestParameterType.EXPECTED_RESULT, TestRule.class, null).toArray(new ITestRule[0]);
    }

    @Override
    public ITestPolicyCmpt[] getExpectedResultTestPolicyCmpts() {
        return this.getTestObjects(TestParameterType.EXPECTED_RESULT, TestPolicyCmpt.class, null).toArray(new ITestPolicyCmpt[0]);
    }

    @Override
    public void removeTestObject(ITestObject testObject) {
        if (testObject.isRoot()) {
            this.testObjects.remove(testObject);
        } else {
            this.remove(testObject);
        }
        this.objectHasChanged();
    }

    public ITestPolicyCmptTypeParameter findTestPolicyCmptTypeParameter(ITestPolicyCmpt testPolicyCmpt, IIpsProject ipsProject) {
        return this.findTestPolicyCmptTypeParameter(testPolicyCmpt, null, ipsProject);
    }

    public ITestPolicyCmptTypeParameter findTestPolicyCmptTypeParameter(ITestPolicyCmptLink link, IIpsProject ipsProject) {
        return this.findTestPolicyCmptTypeParameter(null, link, ipsProject);
    }

    private ITestPolicyCmptTypeParameter findTestPolicyCmptTypeParameter(ITestPolicyCmpt testPolicyCmptBase, ITestPolicyCmptLink link, IIpsProject ipsProject) {
        ArgumentCheck.isTrue((testPolicyCmptBase != null || link != null ? 1 : 0) != 0);
        ArgumentCheck.isTrue((testPolicyCmptBase == null || link == null ? 1 : 0) != 0);
        ITestCaseType testCaseTypeFound = this.findTestCaseType(ipsProject);
        if (testCaseTypeFound == null) {
            return null;
        }
        TestCaseHierarchyPath hierarchyPath = null;
        if (testPolicyCmptBase != null) {
            hierarchyPath = new TestCaseHierarchyPath(testPolicyCmptBase, false);
        } else if (link != null) {
            hierarchyPath = new TestCaseHierarchyPath(link, false);
        } else {
            throw new IpsException((IStatus)new IpsStatus(Messages.TestCase_Error_NoLinkOrPolicyCmptGiven));
        }
        String testPolicyCmptTypeName = hierarchyPath.next();
        ITestParameter testParam = testCaseTypeFound.getTestParameterByName(testPolicyCmptTypeName);
        if (testParam == null) {
            return null;
        }
        if (!(testParam instanceof ITestPolicyCmptTypeParameter)) {
            throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCase_Error_WrongInstanceParam, testPolicyCmptTypeName, testParam.getClass().getName())));
        }
        if (!testPolicyCmptTypeName.equals(testParam.getName())) {
            return null;
        }
        ITestPolicyCmptTypeParameter policyCmptTypeParam = (ITestPolicyCmptTypeParameter)testParam;
        while (hierarchyPath.hasNext()) {
            testPolicyCmptTypeName = hierarchyPath.next();
            if ((policyCmptTypeParam = policyCmptTypeParam.getTestPolicyCmptTypeParamChild(testPolicyCmptTypeName)) != null && testPolicyCmptTypeName.equals(policyCmptTypeParam.getName())) continue;
            return null;
        }
        return policyCmptTypeParam;
    }

    private void remove(ITestObject testObject) {
        ITestObject iTestObject = testObject;
        if (iTestObject instanceof ITestPolicyCmpt) {
            ITestPolicyCmpt testPolicyCmpt;
            ITestPolicyCmpt iTestPolicyCmpt = (ITestPolicyCmpt)iTestObject;
            ITestPolicyCmpt cfr_ignored_0 = (ITestPolicyCmpt)iTestObject;
            if (testPolicyCmpt.isRoot()) {
                this.removeTestObject(testObject);
            } else {
                TestCaseHierarchyPath hierarchyPath = new TestCaseHierarchyPath(testPolicyCmpt);
                if ((testPolicyCmpt = this.findTestPolicyCmpt(hierarchyPath.toString())) == null) {
                    throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCase_Error_TestPolicyCmptNotFound, hierarchyPath.toString())));
                }
                ITestPolicyCmptLink link = (ITestPolicyCmptLink)testPolicyCmpt.getParent();
                if (link != null) {
                    ((ITestPolicyCmpt)link.getParent()).removeLink(link);
                }
            }
        } else {
            this.removeTestObject(testObject);
        }
    }

    @Override
    public ITestPolicyCmpt findTestPolicyCmpt(String testPolicyCmptPath) {
        TestCaseHierarchyPath path = new TestCaseHierarchyPath(testPolicyCmptPath);
        ITestPolicyCmpt pc = null;
        String currElem = path.next();
        List<TestObject> testPoliyCmpts = this.getTestObjects(null, TestPolicyCmpt.class, currElem);
        if (testPoliyCmpts.size() != 1) {
            if (testPoliyCmpts.size() == 0) {
                return null;
            }
            throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCase_Error_MoreThanOneObject, currElem)));
        }
        this.assertInstanceOfTestPolicyCmpt(currElem, testPoliyCmpts.get(0));
        pc = this.searchChildTestPolicyCmpt((ITestPolicyCmpt)((Object)testPoliyCmpts.get(0)), path);
        return pc;
    }

    private void assertInstanceOfTestPolicyCmpt(String currElem, ITestObject testObject) {
        if (!(testObject instanceof ITestPolicyCmpt)) {
            throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCase_Error_WrongInstanceTestPolicyCmpt, currElem, testObject.getClass().getName())));
        }
    }

    private ITestPolicyCmpt searchChildTestPolicyCmpt(ITestPolicyCmpt pc, TestCaseHierarchyPath path) {
        String searchedPath = path.toString();
        while (pc != null && path.hasNext()) {
            boolean found = false;
            String currElem = path.next();
            ITestPolicyCmptLink[] prs = pc.getTestPolicyCmptLinks(currElem);
            currElem = path.next();
            pc = null;
            ITestPolicyCmptLink[] iTestPolicyCmptLinkArray = prs;
            int n = prs.length;
            int n2 = 0;
            while (n2 < n) {
                ITestPolicyCmptLink link = iTestPolicyCmptLinkArray[n2];
                ITestPolicyCmpt pcTarget = link.findTarget();
                if (pcTarget == null) {
                    return null;
                }
                if (currElem.equals(pcTarget.getName())) {
                    if (found) {
                        throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCase_Error_MoreThanOneObject, searchedPath)));
                    }
                    found = true;
                    pc = pcTarget;
                }
                ++n2;
            }
        }
        return pc;
    }

    @Override
    public String generateUniqueNameForTestPolicyCmpt(ITestPolicyCmpt newTestPolicyCmpt, String name) {
        String uniqueLabel = name;
        int idx = 1;
        String newUniqueLabel = uniqueLabel;
        if (newTestPolicyCmpt.isRoot()) {
            ITestPolicyCmpt[] testPolicyCmpts = this.getTestPolicyCmpts();
            int i = 0;
            while (i < testPolicyCmpts.length) {
                ITestPolicyCmpt cmpt = testPolicyCmpts[i];
                if (newUniqueLabel.equals(cmpt.getName()) && !cmpt.equals(newTestPolicyCmpt)) {
                    newUniqueLabel = String.valueOf(uniqueLabel) + " (" + ++idx + ")";
                    i = -1;
                }
                ++i;
            }
        } else {
            ITestPolicyCmpt parent = newTestPolicyCmpt.getParentTestPolicyCmpt();
            ITestPolicyCmptLink[] links = parent.getTestPolicyCmptLinks();
            ArrayList<String> names = new ArrayList<String>();
            ITestPolicyCmptLink[] iTestPolicyCmptLinkArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                ITestPolicyCmpt child;
                ITestPolicyCmptLink link = iTestPolicyCmptLinkArray[n2];
                if (link.isComposition() && !(child = link.findTarget()).equals(newTestPolicyCmpt)) {
                    names.add(child.getName());
                }
                ++n2;
            }
            while (names.contains(newUniqueLabel)) {
                newUniqueLabel = String.valueOf(uniqueLabel) + " (" + ++idx + ")";
            }
        }
        return newUniqueLabel;
    }

    @Override
    public IValidationRule[] getTestRuleCandidates(IIpsProject ipsProject) {
        HashSet<IValidationRule> result = new HashSet<IValidationRule>();
        ITestCaseType testCaseTypeFound = this.findTestCaseType(ipsProject);
        if (testCaseTypeFound != null) {
            result.addAll(Arrays.asList(testCaseTypeFound.getTestRuleCandidates(ipsProject)));
            result.addAll(this.getTestCaseTestRuleCandidates(ipsProject));
        }
        return result.toArray(new IValidationRule[result.size()]);
    }

    @Override
    public IValidationRule findValidationRule(String validationRuleName, IIpsProject ipsProject) {
        IValidationRule[] validationRules;
        IValidationRule[] iValidationRuleArray = validationRules = this.getTestRuleCandidates(ipsProject);
        int n = validationRules.length;
        int n2 = 0;
        while (n2 < n) {
            IValidationRule validationRule = iValidationRuleArray[n2];
            if (validationRule.getName().equals(validationRuleName)) {
                return validationRule;
            }
            ++n2;
        }
        return null;
    }

    private Collection<IValidationRule> getTestCaseTestRuleCandidates(IIpsProject ipsProject) {
        ArrayList<IValidationRule> result = new ArrayList<IValidationRule>();
        this.getValidationRules(this.getTestPolicyCmpts(), result, ipsProject);
        return result;
    }

    private void getValidationRules(ITestPolicyCmpt[] testPolicyCmpts, List<IValidationRule> validationRules, IIpsProject ipsProject) {
        ITestPolicyCmpt[] iTestPolicyCmptArray = testPolicyCmpts;
        int n = testPolicyCmpts.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmpt testPolicyCmpt = iTestPolicyCmptArray[n2];
            this.getValidationRules(testPolicyCmpt, validationRules, ipsProject);
            ++n2;
        }
    }

    private void getValidationRules(ITestPolicyCmpt testPolicyCmpt, List<IValidationRule> validationRules, IIpsProject ipsProject) {
        ITestPolicyCmptLink[] rs;
        ITestPolicyCmptLink[] iTestPolicyCmptLinkArray = rs = testPolicyCmpt.getTestPolicyCmptLinks();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptLink element = iTestPolicyCmptLinkArray[n2];
            ITestPolicyCmpt tpc = element.findTarget();
            if (tpc != null) {
                this.getValidationRules(tpc, validationRules, ipsProject);
            }
            ++n2;
        }
        ITestPolicyCmptTypeParameter typeParam = testPolicyCmpt.findTestPolicyCmptTypeParameter(ipsProject);
        if (typeParam == null) {
            return;
        }
        IPolicyCmptType pct = typeParam.findPolicyCmptType(ipsProject);
        if (pct == null) {
            return;
        }
        validationRules.addAll(pct.getValidationRules());
        IProductCmpt pc = testPolicyCmpt.findProductCmpt(ipsProject);
        if (pc == null) {
            return;
        }
        IPolicyCmptType pctOfPc = pc.findPolicyCmptType(ipsProject);
        if (pctOfPc == null) {
            return;
        }
        if (!pctOfPc.equals(pct)) {
            ITypeHierarchy supertypeHierarchy = pctOfPc.getSupertypeHierarchy();
            validationRules.addAll(supertypeHierarchy.getAllRules(pctOfPc));
        }
    }

    private ITestPolicyCmpt newTestPolicyCmptInternal(String id) {
        TestPolicyCmpt p = new TestPolicyCmpt(this, id);
        this.testObjects.add(p);
        return p;
    }

    private ITestValue newTestValueInternal(String id) {
        TestValue v = new TestValue(this, id);
        this.testObjects.add(v);
        return v;
    }

    private ITestRule newTestRuleInternal(String id) {
        TestRule v = new TestRule(this, id);
        this.testObjects.add(v);
        return v;
    }

    private List<TestObject> getTestObjects(TestParameterType type, Class<?> parameterClass, String name) {
        ArrayList<TestObject> result = new ArrayList<TestObject>(this.testObjects.size());
        for (IIpsObjectPart iIpsObjectPart : this.testObjects) {
            TestObject testObject = (TestObject)iIpsObjectPart;
            boolean addParameter = true;
            if (type != null && !this.isTypeOrDefault(testObject.getTestParameterName(), type, TestObject.DEFAULT_TYPE) || parameterClass != null && !testObject.getClass().equals(parameterClass)) {
                addParameter = false;
                continue;
            }
            if (name != null && !name.equals(testObject.getName())) {
                addParameter = false;
                continue;
            }
            if (!addParameter) continue;
            result.add(testObject);
        }
        return result;
    }

    boolean isTypeOrDefault(String testParameterName, TestParameterType type, TestParameterType defaultType) {
        try {
            ITestCaseType testCaseTypeFound = this.findTestCaseType(this.getIpsProject());
            if (testCaseTypeFound == null) {
                return type.equals((Object)defaultType);
            }
            ITestParameter testParameter = testCaseTypeFound.getTestParameterByName(testParameterName);
            if (testParameter == null) {
                return type.equals((Object)defaultType);
            }
            return this.isTypeOrDefault(testParameter, type);
        }
        catch (IpsException ipsException) {
            return false;
        }
    }

    boolean isTypeOrDefault(ITestParameter testParameter, TestParameterType type) {
        block4: {
            if ((!testParameter.isInputOrCombinedParameter() || !type.equals((Object)TestParameterType.INPUT)) && (!testParameter.isExpextedResultOrCombinedParameter() || !type.equals((Object)TestParameterType.EXPECTED_RESULT))) break block4;
            return true;
        }
        try {
            if (testParameter.isCombinedParameter() && type.equals((Object)TestParameterType.COMBINED)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void validateThis(MessageList messageList, IIpsProject ipsProject) {
        super.validateThis(messageList, ipsProject);
        ITestCaseType testCaseTypeFound = this.findTestCaseType(ipsProject);
        if (testCaseTypeFound == null) {
            String text = MessageFormat.format(Messages.TestCase_ValidateError_TestCaseTypeNotFound, this.testCaseTypeName);
            Message msg = new Message("TESTCASE-TestCaseTypeNotFound", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
            messageList.add(msg);
        }
    }

    @Override
    public void clearTestValues(TestParameterType testParameterType) {
        if (TestParameterType.isTypeMatching(TestParameterType.INPUT, testParameterType)) {
            this.clearAllInputTestValues();
        }
        if (TestParameterType.isTypeMatching(TestParameterType.EXPECTED_RESULT, testParameterType)) {
            this.clearAllExpectedTestValues();
        }
    }

    private void clearAllInputTestValues() {
        this.clearTestValues(this.getInputTestValues());
        this.clearTestAttributeValues(true);
    }

    private void clearAllExpectedTestValues() {
        this.clearTestValues(this.getExpectedResultTestValues());
        this.clearTestAttributeValues(false);
    }

    private void clearTestValues(ITestValue[] testValues) {
        ITestValue[] iTestValueArray = testValues;
        int n = testValues.length;
        int n2 = 0;
        while (n2 < n) {
            ITestValue testValue = iTestValueArray[n2];
            testValue.setDefaultValue();
            ++n2;
        }
    }

    private void clearTestAttributeValues(boolean input) {
        ITestPolicyCmpt[] testPolicyCmpt;
        ITestPolicyCmpt[] iTestPolicyCmptArray = testPolicyCmpt = this.getAllTestPolicyCmpt();
        int n = testPolicyCmpt.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttributeValue[] testAttributeValues;
            ITestPolicyCmpt element = iTestPolicyCmptArray[n2];
            ITestAttributeValue[] iTestAttributeValueArray = testAttributeValues = element.getTestAttributeValues();
            int n3 = testAttributeValues.length;
            int n4 = 0;
            while (n4 < n3) {
                ITestAttributeValue testAttributeValue = iTestAttributeValueArray[n4];
                if (input && testAttributeValue.isInputAttribute(this.getIpsProject()) || !input && testAttributeValue.isExpectedResultAttribute(this.getIpsProject())) {
                    testAttributeValue.setDefaultValue();
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public IIpsSrcFile findMetaClassSrcFile(IIpsProject ipsProject) {
        return ipsProject.findIpsSrcFile(IpsObjectType.TEST_CASE_TYPE, this.getTestCaseType());
    }

    @Override
    public String getMetaClass() {
        return this.getTestCaseType();
    }
}

