/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.testcase.ITestCase;
import org.faktorips.devtools.model.testcase.ITestPolicyCmpt;
import org.faktorips.devtools.model.testcase.ITestPolicyCmptLink;

public class TestCaseHierarchyPath {
    public static final String SEPARATOR = "//";
    public static final String OFFSET_SEPARATOR = "#";
    private String hierarchyPath = "";

    public TestCaseHierarchyPath(String hierarchyPath) {
        this.hierarchyPath = hierarchyPath;
    }

    public TestCaseHierarchyPath(ITestPolicyCmpt currTestPolicyCmpt) {
        this.hierarchyPath = this.evalHierarchyPathForTestCase(currTestPolicyCmpt, "");
    }

    public TestCaseHierarchyPath(ITestPolicyCmpt currTestPolicyCmpt, boolean evalForTestCase) {
        this.hierarchyPath = evalForTestCase ? this.evalHierarchyPathForTestCase(currTestPolicyCmpt, "") : this.evalHierarchyPathForTestCaseType(currTestPolicyCmpt, "");
    }

    public TestCaseHierarchyPath(ITestPolicyCmptLink link, boolean evalforTestCase) {
        String linkPath = link.getTestPolicyCmptTypeParameter();
        this.hierarchyPath = evalforTestCase ? this.evalHierarchyPathForTestCase((ITestPolicyCmpt)link.getParent(), linkPath) : this.evalHierarchyPathForTestCaseType((ITestPolicyCmpt)link.getParent(), linkPath);
    }

    public static String unqualifiedName(String hierarchyPath) {
        int index = hierarchyPath.lastIndexOf(SEPARATOR);
        if (index == -1) {
            return hierarchyPath;
        }
        return hierarchyPath.substring(index + SEPARATOR.length());
    }

    public static String evalTestPolicyCmptParamPath(ITestPolicyCmpt testPolicyCmpt) {
        int n;
        int n2;
        IIpsObjectPart[] iIpsObjectPartArray;
        String pathWithOffset = "";
        ITestPolicyCmpt policyCmpt = testPolicyCmpt;
        while (!policyCmpt.isRoot()) {
            int offset = 0;
            ITestPolicyCmpt parent = policyCmpt.getParentTestPolicyCmpt();
            ITestPolicyCmptLink[] links = parent.getTestPolicyCmptLinks();
            iIpsObjectPartArray = links;
            n2 = links.length;
            n = 0;
            while (n < n2) {
                IIpsObjectPart link = iIpsObjectPartArray[n];
                if (link.findTarget().equals(policyCmpt)) break;
                if (link.getTestPolicyCmptTypeParameter().equals(policyCmpt.getTestPolicyCmptTypeParameter())) {
                    ++offset;
                }
                ++n;
            }
            pathWithOffset = String.valueOf(policyCmpt.getTestPolicyCmptTypeParameter()) + OFFSET_SEPARATOR + offset + (pathWithOffset.length() > 0 ? "." + pathWithOffset : "");
            policyCmpt = parent;
        }
        ITestCase testCase = policyCmpt.getTestCase();
        ITestPolicyCmpt[] tpcs = testCase.getTestPolicyCmpts();
        int offset = 0;
        iIpsObjectPartArray = tpcs;
        n2 = tpcs.length;
        n = 0;
        while (n < n2) {
            IIpsObjectPart tpc = iIpsObjectPartArray[n];
            if (policyCmpt.equals(tpc)) break;
            if (policyCmpt.getTestPolicyCmptTypeParameter().equals(tpc.getTestPolicyCmptTypeParameter())) {
                ++offset;
            }
            ++n;
        }
        return String.valueOf(policyCmpt.getTestPolicyCmptTypeParameter()) + OFFSET_SEPARATOR + offset + (pathWithOffset.length() > 0 ? "." + pathWithOffset : "");
    }

    public String getHierarchyPath() {
        return this.hierarchyPath;
    }

    public boolean hasNext() {
        return this.hierarchyPath.length() > 0;
    }

    public String next() {
        String next = "";
        if (this.hierarchyPath.indexOf(SEPARATOR) >= 0) {
            next = this.hierarchyPath.substring(0, this.hierarchyPath.indexOf(SEPARATOR));
            this.hierarchyPath = this.hierarchyPath.substring(this.hierarchyPath.indexOf(SEPARATOR) + SEPARATOR.length());
        } else {
            next = this.hierarchyPath;
            this.hierarchyPath = "";
        }
        return next;
    }

    public String toString() {
        return this.hierarchyPath;
    }

    /*
     * Unable to fully structure code
     */
    public int count() {
        count = 0;
        tempHierarchyPath = new TestCaseHierarchyPath(this.hierarchyPath);
        if (this.hierarchyPath.length() > 0) ** GOTO lbl8
        return 0;
lbl-1000:
        // 1 sources

        {
            tempHierarchyPath.next();
            ++count;
lbl8:
            // 2 sources

            ** while (tempHierarchyPath.hasNext())
        }
lbl9:
        // 1 sources

        return count;
    }

    public static String getFolderName(String hierarchyPath) {
        int index = hierarchyPath.lastIndexOf(SEPARATOR);
        if (index == -1) {
            return "";
        }
        return hierarchyPath.substring(0, index);
    }

    private String evalHierarchyPathForTestCaseType(ITestPolicyCmpt currTestPolicyCmpt, String hierarchyPath) {
        String path = hierarchyPath;
        ITestPolicyCmpt policyCmpt = currTestPolicyCmpt;
        while (!policyCmpt.isRoot()) {
            if (path.length() > 0) {
                path = SEPARATOR + path;
            }
            ITestPolicyCmptLink testPcTypeLink = (ITestPolicyCmptLink)policyCmpt.getParent();
            path = String.valueOf(testPcTypeLink.getTestPolicyCmptTypeParameter()) + path;
            policyCmpt = (ITestPolicyCmpt)testPcTypeLink.getParent();
        }
        return String.valueOf(policyCmpt.getTestPolicyCmptTypeParameter()) + (path.length() > 0 ? SEPARATOR + path : "");
    }

    private String evalHierarchyPathForTestCase(ITestPolicyCmpt currTestPolicyCmpt, String hierarchyPath) {
        String path = hierarchyPath;
        ITestPolicyCmpt policyCmpt = currTestPolicyCmpt;
        while (!policyCmpt.isRoot()) {
            if (path.length() > 0) {
                path = SEPARATOR + path;
            }
            path = SEPARATOR + policyCmpt.getName() + path;
            ITestPolicyCmptLink testPcTypeLink = (ITestPolicyCmptLink)policyCmpt.getParent();
            path = String.valueOf(testPcTypeLink.getTestPolicyCmptTypeParameter()) + path;
            policyCmpt = (ITestPolicyCmpt)testPcTypeLink.getParent();
        }
        return String.valueOf(policyCmpt.getName()) + (path.length() > 0 ? SEPARATOR + path : "");
    }
}

