/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsobject.AbstractFixDifferencesComposite;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.testcase.ITestAttributeValue;
import org.faktorips.devtools.model.testcase.ITestCase;
import org.faktorips.devtools.model.testcase.ITestCaseTestCaseTypeDelta;
import org.faktorips.devtools.model.testcase.ITestObject;
import org.faktorips.devtools.model.testcase.ITestPolicyCmpt;
import org.faktorips.devtools.model.testcase.ITestPolicyCmptLink;
import org.faktorips.devtools.model.testcase.ITestRule;
import org.faktorips.devtools.model.testcase.ITestValue;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.ITestRuleParameter;
import org.faktorips.devtools.model.testcasetype.ITestValueParameter;
import org.faktorips.util.ArgumentCheck;

public class TestCaseTestCaseTypeDelta
extends AbstractFixDifferencesComposite
implements ITestCaseTestCaseTypeDelta {
    private ITestCase testCase;
    private ITestCaseType testCaseType;
    private ITestValue[] testValuesWithMissingTestValueParam;
    private ITestRule[] testRulesWithMissingTestRuleParam;
    private ITestPolicyCmpt[] testPolicyCmptsWithMissingTypeParam;
    private ITestPolicyCmptLink[] testPolicyCmptLinksWithMissingTypeParam;
    private ITestAttributeValue[] testAttributeValuesWithMissingTestAttribute;
    private ITestPolicyCmpt[] testPolicyCmptWithDifferentSortOrder;
    private ITestPolicyCmpt[] testPolicyCmptWithDifferentSortOrderTestAttr;
    private ITestValueParameter[] testValueParametersWithMissingTestValue;
    private ITestPolicyCmptTypeParameter[] testPolicyCmptTypeParametersWithMissingTestPolicyCmpt;
    private ITestAttribute[] testAttributesWithMissingTestAttributeValue;
    private boolean differentTestParameterOrder = false;
    private HashMap<ITestAttribute, List<ITestPolicyCmpt>> testAttributes2TestPolicyCmpt = new HashMap();
    private List<ITestPolicyCmpt> testPolicyCmptChildWithWrongSortOrder = new ArrayList<ITestPolicyCmpt>();
    private List<ITestPolicyCmpt> testPolicyCmptWithWrongSortOrderAttribute = new ArrayList<ITestPolicyCmpt>();
    private List<ITestPolicyCmpt> testCaseSideObjects;
    private boolean errorInTestCaseType;
    private IIpsProject ipsProject;

    public TestCaseTestCaseTypeDelta(ITestCase testCase, ITestCaseType testCaseType) {
        ArgumentCheck.notNull((Object)testCase);
        ArgumentCheck.notNull((Object)testCaseType);
        this.testCase = testCase;
        this.testCaseType = testCaseType;
        this.ipsProject = testCase.getIpsProject();
        if (testCaseType.validate(this.ipsProject).containsErrorMsg()) {
            this.errorInTestCaseType = true;
            return;
        }
        this.computeTestValueWithMissingTestParameter();
        this.computeTestRuleWithMissingTestParameter();
        this.testCaseSideObjects = this.computeTestPolicyCmptStructWithMissingTestParameter();
        this.computeTestValueParameterWithMissingTestValue();
        this.computeTestPolicyCmptTypeParameterWithMissingTestPolicyCmpt(this.testCaseSideObjects);
        this.computeTestRuleSortOrder();
        this.testPolicyCmptWithDifferentSortOrderTestAttr = this.testPolicyCmptWithWrongSortOrderAttribute.toArray(new ITestPolicyCmpt[0]);
    }

    @Override
    public IIpsElement getCorrespondingIpsElement() {
        return this.getTestCase();
    }

    @Override
    public ITestPolicyCmpt[] getTestPolicyCmptForMissingTestAttribute(ITestAttribute testAttribute) {
        List<ITestPolicyCmpt> testPolicyCmptsWithMissingTestAttr = this.testAttributes2TestPolicyCmpt.get(testAttribute);
        if (testPolicyCmptsWithMissingTestAttr != null) {
            return testPolicyCmptsWithMissingTestAttr.toArray(new ITestPolicyCmpt[0]);
        }
        return new ITestPolicyCmpt[0];
    }

    private void computeTestValueParameterWithMissingTestValue() {
        ArrayList<ITestValueParameter> missing = new ArrayList<ITestValueParameter>();
        ITestValueParameter[] params = this.testCaseType.getTestValueParameters();
        List<ITestValue> values = Arrays.asList(this.testCase.getTestValues());
        ITestValueParameter[] iTestValueParameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ITestValueParameter param = iTestValueParameterArray[n2];
            boolean found = false;
            for (ITestValue value : values) {
                if (!value.getTestValueParameter().equals(param.getName())) continue;
                found = true;
                this.checkSortOrder(param, value);
                break;
            }
            if (!found) {
                missing.add(param);
            }
            ++n2;
        }
        this.testValueParametersWithMissingTestValue = missing.toArray(new ITestValueParameter[0]);
    }

    private void computeTestRuleSortOrder() {
        if (this.differentTestParameterOrder) {
            return;
        }
        ITestRuleParameter[] params = this.testCaseType.getTestRuleParameters();
        List<ITestRule> rules = Arrays.asList(this.testCase.getTestRuleObjects());
        if (rules.size() == 0) {
            return;
        }
        ITestRuleParameter[] iTestRuleParameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ITestRuleParameter param = iTestRuleParameterArray[n2];
            for (ITestRule rule : rules) {
                if (!rule.getTestRuleParameter().equals(param.getName())) continue;
                this.checkSortOrder(param, rule);
                break;
            }
            if (this.differentTestParameterOrder) break;
            ++n2;
        }
    }

    private void checkSortOrder(ITestParameter testParameter, ITestObject testObject) {
        if (this.differentTestParameterOrder) {
            return;
        }
        ArrayList<ITestParameter> testParams = new ArrayList<ITestParameter>();
        testParams.addAll(Arrays.asList(this.testCaseType.getTestParameters()));
        ArrayList<ITestObject> testObjects = new ArrayList<ITestObject>();
        testObjects.addAll(Arrays.asList(this.testCase.getTestObjects()));
        if (testParameter instanceof ITestRuleParameter && this.testCase.getTestRule(testParameter.getName()).length == 0) {
            return;
        }
        this.removeTestRulesWithSameParamFromLists(testParams, testObjects);
        List<ITestParameter> cleanedList = this.removeTestPolicyCmptParamsWithNoTestObjectFromLists(testParams, testObjects);
        int idxInTestCaseType = cleanedList.indexOf(testParameter);
        int idxInTestCase = testObjects.indexOf(testObject);
        if (idxInTestCase == -1) {
            throw new RuntimeException("Object not found in test case: " + testObject);
        }
        if (idxInTestCaseType != idxInTestCase) {
            this.differentTestParameterOrder = true;
        }
    }

    private List<ITestParameter> removeTestPolicyCmptParamsWithNoTestObjectFromLists(List<ITestParameter> testParams, List<ITestObject> testObjects) {
        ArrayList<String> testObjectParams = new ArrayList<String>(testObjects.size());
        int i = 0;
        while (i < testObjects.size()) {
            testObjectParams.add(testObjects.get(i).getTestParameterName());
            ++i;
        }
        ArrayList<ITestParameter> paramsWithTestObjectsOnly = new ArrayList<ITestParameter>(testParams.size());
        int i2 = 0;
        while (i2 < testParams.size()) {
            ITestParameter testParameter = testParams.get(i2);
            if (!(testParameter instanceof ITestPolicyCmptTypeParameter)) {
                paramsWithTestObjectsOnly.add(testParameter);
            } else if (testObjectParams.contains(testParameter.getName())) {
                paramsWithTestObjectsOnly.add(testParameter);
            }
            ++i2;
        }
        return paramsWithTestObjectsOnly;
    }

    private void removeTestRulesWithSameParamFromLists(List<ITestParameter> testParams, List<ITestObject> testObjects) {
        ArrayList<IIpsObjectPart> elementsToRemove = new ArrayList<IIpsObjectPart>();
        String prevTestRuleParam = null;
        for (ITestObject iTestObject : testObjects) {
            if (!(iTestObject instanceof ITestRule)) continue;
            String testRuleParam = ((ITestRule)iTestObject).getTestRuleParameter();
            if (testRuleParam.equals(prevTestRuleParam)) {
                elementsToRemove.add(iTestObject);
            }
            prevTestRuleParam = testRuleParam;
        }
        for (IIpsObjectPart iIpsObjectPart : elementsToRemove) {
            testObjects.remove(iIpsObjectPart);
        }
        elementsToRemove = new ArrayList();
        for (ITestParameter iTestParameter : testParams) {
            if (!(iTestParameter instanceof ITestRuleParameter) || this.testCase.getTestRule(iTestParameter.getName()).length != 0) continue;
            elementsToRemove.add(iTestParameter);
        }
        for (IIpsObjectPart iIpsObjectPart : elementsToRemove) {
            testParams.remove(iIpsObjectPart);
        }
    }

    private boolean hasChildDifferntSortOrder(ITestPolicyCmpt cmpt) {
        return this.testPolicyCmptChildWithWrongSortOrder.contains(cmpt);
    }

    private void computeTestPolicyCmptTypeParameterWithMissingTestPolicyCmpt(List<ITestPolicyCmpt> testCaseSideObjects) {
        ArrayList<ITestPolicyCmptTypeParameter> missingTestPolicyCmptTypeParameter = new ArrayList<ITestPolicyCmptTypeParameter>();
        missingTestPolicyCmptTypeParameter.addAll(Arrays.asList(this.testCaseType.getTestPolicyCmptTypeParameters()));
        ArrayList<ITestAttribute> missingTestAttributes = new ArrayList<ITestAttribute>();
        ArrayList<ITestPolicyCmpt> differentSortOrderForTestPolicyCmpts = new ArrayList<ITestPolicyCmpt>();
        for (ITestPolicyCmpt element : testCaseSideObjects) {
            ITestPolicyCmptTypeParameter param = element.findTestPolicyCmptTypeParameter(this.ipsProject);
            if (param == null) continue;
            missingTestPolicyCmptTypeParameter.remove(param);
            this.computeTestAttributeWithMissingTestAttributeValue(param, element, missingTestAttributes);
            if (element.isRoot()) {
                this.checkSortOrder(param, element);
                continue;
            }
            ITestPolicyCmpt parent = element.getParentTestPolicyCmpt();
            if (differentSortOrderForTestPolicyCmpts.contains(parent) || !this.hasChildDifferntSortOrder(element)) continue;
            this.differentTestParameterOrder = true;
            differentSortOrderForTestPolicyCmpts.add(parent);
        }
        ArrayList<ITestPolicyCmptTypeParameter> toRemove = new ArrayList<ITestPolicyCmptTypeParameter>();
        for (ITestPolicyCmptTypeParameter testPolicyCmptTypeParameter : missingTestPolicyCmptTypeParameter) {
            if (!testPolicyCmptTypeParameter.isRoot()) continue;
            toRemove.add(testPolicyCmptTypeParameter);
        }
        for (ITestPolicyCmptTypeParameter iTestPolicyCmptTypeParameter : toRemove) {
            missingTestPolicyCmptTypeParameter.remove(iTestPolicyCmptTypeParameter);
        }
        this.testPolicyCmptTypeParametersWithMissingTestPolicyCmpt = missingTestPolicyCmptTypeParameter.toArray(new ITestPolicyCmptTypeParameter[0]);
        this.testAttributesWithMissingTestAttributeValue = missingTestAttributes.toArray(new ITestAttribute[0]);
        this.testPolicyCmptWithDifferentSortOrder = differentSortOrderForTestPolicyCmpts.toArray(new ITestPolicyCmpt[0]);
    }

    private void computeTestAttributeWithMissingTestAttributeValue(ITestPolicyCmptTypeParameter param, ITestPolicyCmpt cmpt, List<ITestAttribute> missingTestAttributes) {
        ITestAttributeValue[] testAttrValues;
        ArrayList<ITestAttribute> testAttributes = new ArrayList<ITestAttribute>();
        testAttributes.addAll(Arrays.asList(param.getTestAttributes()));
        ITestAttributeValue[] iTestAttributeValueArray = testAttrValues = cmpt.getTestAttributeValues();
        int n = testAttrValues.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttributeValue testAttrValue = iTestAttributeValueArray[n2];
            ITestAttribute testAttr = testAttrValue.findTestAttribute(this.testCase.getIpsProject());
            if (testAttr != null) {
                testAttributes.remove(testAttr);
            }
            ++n2;
        }
        for (ITestAttribute testAttr : testAttributes) {
            if (missingTestAttributes.contains(testAttr)) continue;
            missingTestAttributes.add(testAttr);
        }
        for (ITestAttribute testAttr : testAttributes) {
            List cmptWithMissingTestAttrList = this.testAttributes2TestPolicyCmpt.computeIfAbsent(testAttr, $ -> new ArrayList(1));
            cmptWithMissingTestAttrList.add(cmpt);
            this.addDifferentTestAttributeSortOrder(cmpt);
        }
    }

    private void computeTestValueWithMissingTestParameter() {
        ITestValue[] testValues;
        ArrayList<ITestValue> missing = new ArrayList<ITestValue>();
        ITestValue[] iTestValueArray = testValues = this.testCase.getTestValues();
        int n = testValues.length;
        int n2 = 0;
        while (n2 < n) {
            ITestValue testValue = iTestValueArray[n2];
            ITestParameter testParameter = this.testCaseType.getTestParameterByName(testValue.getTestValueParameter());
            if (testParameter == null || !(testParameter instanceof ITestValueParameter)) {
                missing.add(testValue);
            }
            ++n2;
        }
        this.testValuesWithMissingTestValueParam = missing.toArray(new ITestValue[0]);
    }

    private void computeTestRuleWithMissingTestParameter() {
        ITestRule[] testRules;
        ArrayList<ITestRule> missing = new ArrayList<ITestRule>();
        ITestRule[] iTestRuleArray = testRules = this.testCase.getTestRuleObjects();
        int n = testRules.length;
        int n2 = 0;
        while (n2 < n) {
            ITestRule testRule = iTestRuleArray[n2];
            ITestParameter testParameter = this.testCaseType.getTestParameterByName(testRule.getTestRuleParameter());
            if (testParameter == null || !(testParameter instanceof ITestRuleParameter)) {
                missing.add(testRule);
            }
            ++n2;
        }
        this.testRulesWithMissingTestRuleParam = missing.toArray(new ITestRule[0]);
    }

    private List<ITestPolicyCmpt> computeTestPolicyCmptStructWithMissingTestParameter() {
        ITestPolicyCmpt[] testPolicyCmpts;
        ArrayList<ITestPolicyCmpt> missingTestPolicyCmpts = new ArrayList<ITestPolicyCmpt>();
        ArrayList<ITestPolicyCmptLink> missingTestPolicyCmptLinks = new ArrayList<ITestPolicyCmptLink>();
        ArrayList<ITestAttributeValue> missingTestAttributeValues = new ArrayList<ITestAttributeValue>();
        ArrayList<ITestPolicyCmpt> allTestPolicyCmpt = new ArrayList<ITestPolicyCmpt>();
        ITestPolicyCmpt[] iTestPolicyCmptArray = testPolicyCmpts = this.testCase.getTestPolicyCmpts();
        int n = testPolicyCmpts.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmpt cmpt = iTestPolicyCmptArray[n2];
            allTestPolicyCmpt.add(cmpt);
            this.computeTestPolicyCmptStructWithMissingTestParameter(cmpt, missingTestPolicyCmpts, missingTestPolicyCmptLinks, missingTestAttributeValues, allTestPolicyCmpt);
            ++n2;
        }
        this.testPolicyCmptsWithMissingTypeParam = missingTestPolicyCmpts.toArray(new ITestPolicyCmpt[0]);
        this.testPolicyCmptLinksWithMissingTypeParam = missingTestPolicyCmptLinks.toArray(new ITestPolicyCmptLink[0]);
        this.testAttributeValuesWithMissingTestAttribute = missingTestAttributeValues.toArray(new ITestAttributeValue[0]);
        return allTestPolicyCmpt;
    }

    private void computeTestPolicyCmptStructWithMissingTestParameter(ITestPolicyCmpt cmpt, List<ITestPolicyCmpt> missingTestPolicyCmpts, List<ITestPolicyCmptLink> missingTestPolicyCmptLinks, List<ITestAttributeValue> missingTestAttributeValues, List<ITestPolicyCmpt> allTestPolicyCmpt) {
        ITestPolicyCmptTypeParameter param = cmpt.findTestPolicyCmptTypeParameter(this.ipsProject);
        if (param == null) {
            missingTestPolicyCmpts.add(cmpt);
        } else {
            this.computeTestPolicyCmptLinkStructWithMissingTestParameter(cmpt.getTestPolicyCmptLinks(), missingTestPolicyCmpts, missingTestPolicyCmptLinks, missingTestAttributeValues, allTestPolicyCmpt);
            this.computeTestAttributeValuesWithMissingTestAttribute(cmpt, missingTestAttributeValues);
            this.computeSortOrderOfTestAttributes(cmpt, param);
        }
    }

    private void computeSortOrderOfTestAttributes(ITestPolicyCmpt cmpt, ITestPolicyCmptTypeParameter param) {
        ITestAttribute[] testAttr;
        if (this.testPolicyCmptWithWrongSortOrderAttribute.contains(cmpt)) {
            return;
        }
        ITestAttributeValue[] testAttrValue = cmpt.getTestAttributeValues();
        if (testAttrValue.length != (testAttr = param.getTestAttributes()).length) {
            this.addDifferentTestAttributeSortOrder(cmpt);
            return;
        }
        int i = 0;
        while (i < testAttr.length) {
            if (!testAttr[i].getName().equals(testAttrValue[i].getTestAttribute())) {
                this.addDifferentTestAttributeSortOrder(cmpt);
                return;
            }
            ++i;
        }
    }

    private List<ITestPolicyCmptLink> computeTestPolicyCmptLinkStructWithMissingTestParameter(ITestPolicyCmptLink[] testPolicyCmptLinks, List<ITestPolicyCmpt> missingTestPolicyCmpt, List<ITestPolicyCmptLink> missingTestPolicyCmptLink, List<ITestAttributeValue> missingTestAttributeValue, List<ITestPolicyCmpt> allTestPolicyCmpt) {
        ArrayList<ITestPolicyCmptLink> objects = new ArrayList<ITestPolicyCmptLink>();
        ITestPolicyCmptTypeParameter prevParam = null;
        ITestPolicyCmptLink[] iTestPolicyCmptLinkArray = testPolicyCmptLinks;
        int n = testPolicyCmptLinks.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                ITestPolicyCmptTypeParameter param;
                block6: {
                    ITestPolicyCmptLink testPolicyCmptLink;
                    block5: {
                        testPolicyCmptLink = iTestPolicyCmptLinkArray[n2];
                        objects.add(testPolicyCmptLink);
                        param = testPolicyCmptLink.findTestPolicyCmptTypeParameter(this.ipsProject);
                        if (param != null) break block5;
                        missingTestPolicyCmptLink.add(testPolicyCmptLink);
                        break block6;
                    }
                    if (!testPolicyCmptLink.isComposition()) break block6;
                    ITestPolicyCmpt cmpt = testPolicyCmptLink.findTarget();
                    if (cmpt == null) break block7;
                    allTestPolicyCmpt.add(cmpt);
                    if (prevParam != null && this.isWrongIfTestPolicyCmptLinkSortOrder(prevParam, param)) {
                        this.testPolicyCmptChildWithWrongSortOrder.add(cmpt);
                    }
                    this.computeTestPolicyCmptStructWithMissingTestParameter(cmpt, missingTestPolicyCmpt, missingTestPolicyCmptLink, missingTestAttributeValue, allTestPolicyCmpt);
                }
                prevParam = param;
            }
            ++n2;
        }
        return objects;
    }

    private boolean isWrongIfTestPolicyCmptLinkSortOrder(ITestPolicyCmptTypeParameter prevParam, ITestPolicyCmptTypeParameter param) {
        ArgumentCheck.isTrue((!param.isRoot() ? 1 : 0) != 0);
        ITestPolicyCmptTypeParameter parentPrev = (ITestPolicyCmptTypeParameter)prevParam.getParent();
        ITestPolicyCmptTypeParameter parent = (ITestPolicyCmptTypeParameter)param.getParent();
        ArgumentCheck.isTrue((parent == parentPrev ? 1 : 0) != 0);
        ITestPolicyCmptTypeParameter[] childs = parent.getTestPolicyCmptTypeParamChilds();
        boolean prevBefore = false;
        ITestPolicyCmptTypeParameter[] iTestPolicyCmptTypeParameterArray = childs;
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptTypeParameter child = iTestPolicyCmptTypeParameterArray[n2];
            if (child == prevParam) {
                prevBefore = true;
            } else if (child == param && !prevBefore) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void computeTestAttributeValuesWithMissingTestAttribute(ITestPolicyCmpt cmpt, List<ITestAttributeValue> missingTestAttributeValue) {
        ITestAttributeValue[] testAttributeValues;
        ITestAttributeValue[] iTestAttributeValueArray = testAttributeValues = cmpt.getTestAttributeValues();
        int n = testAttributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttributeValue testAttributeValue = iTestAttributeValueArray[n2];
            ITestAttribute testAttribute = testAttributeValue.findTestAttribute(this.testCase.getIpsProject());
            if (testAttribute == null) {
                missingTestAttributeValue.add(testAttributeValue);
                this.addDifferentTestAttributeSortOrder(cmpt);
            }
            ++n2;
        }
    }

    private void addDifferentTestAttributeSortOrder(ITestPolicyCmpt policyCmpt) {
        if (this.testPolicyCmptWithWrongSortOrderAttribute.contains(policyCmpt)) {
            return;
        }
        this.testPolicyCmptWithWrongSortOrderAttribute.add(policyCmpt);
        this.differentTestParameterOrder = true;
        ArgumentCheck.isTrue((this.testPolicyCmptWithDifferentSortOrder == null ? 1 : 0) != 0);
    }

    @Override
    public boolean isEmptyThis() {
        return this.errorInTestCaseType || this.testValuesWithMissingTestValueParam.length == 0 && this.testPolicyCmptsWithMissingTypeParam.length == 0 && this.testPolicyCmptLinksWithMissingTypeParam.length == 0 && this.testAttributeValuesWithMissingTestAttribute.length == 0 && this.testAttributesWithMissingTestAttributeValue.length == 0 && this.testPolicyCmptTypeParametersWithMissingTestPolicyCmpt.length == 0 && this.testValueParametersWithMissingTestValue.length == 0 && this.testRulesWithMissingTestRuleParam.length == 0 && !this.differentTestParameterOrder;
    }

    @Override
    public boolean isDifferentTestParameterOrder() {
        return this.differentTestParameterOrder;
    }

    @Override
    public ITestCaseType getTestCaseType() {
        return this.testCaseType;
    }

    @Override
    public ITestCase getTestCase() {
        return this.testCase;
    }

    @Override
    public ITestValue[] getTestValuesWithMissingTestValueParam() {
        return this.testValuesWithMissingTestValueParam;
    }

    @Override
    public ITestRule[] getTestRulesWithMissingTestValueParam() {
        return this.testRulesWithMissingTestRuleParam;
    }

    @Override
    public ITestPolicyCmpt[] getTestPolicyCmptsWithMissingTypeParam() {
        return this.testPolicyCmptsWithMissingTypeParam;
    }

    @Override
    public ITestPolicyCmptLink[] getTestPolicyCmptLinkWithMissingTypeParam() {
        return this.testPolicyCmptLinksWithMissingTypeParam;
    }

    @Override
    public ITestAttributeValue[] getTestAttributeValuesWithMissingTestAttribute() {
        return this.testAttributeValuesWithMissingTestAttribute;
    }

    @Override
    public ITestPolicyCmpt[] getTestPolicyCmptWithDifferentSortOrder() {
        return this.testPolicyCmptWithDifferentSortOrder;
    }

    @Override
    public ITestPolicyCmpt[] getTestPolicyCmptWithDifferentSortOrderTestAttr() {
        return this.testPolicyCmptWithDifferentSortOrderTestAttr;
    }

    @Override
    public ITestValueParameter[] getTestValueParametersWithMissingTestValue() {
        return this.testValueParametersWithMissingTestValue;
    }

    @Override
    public ITestPolicyCmptTypeParameter[] getTestPolicyCmptTypeParametersWithMissingTestPolicyCmpt() {
        return this.testPolicyCmptTypeParametersWithMissingTestPolicyCmpt;
    }

    @Override
    public ITestAttribute[] getTestAttributesWithMissingTestAttributeValue() {
        return this.testAttributesWithMissingTestAttributeValue;
    }

    @Override
    protected void fix() {
        try {
            this.testCase.fixDifferences(this);
        }
        catch (IpsException e) {
            IpsLog.log(e);
        }
    }
}

