/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.testcase.TestCase;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.testcase.ITestObject;
import org.faktorips.devtools.model.testcase.ITestPolicyCmpt;
import org.faktorips.devtools.model.testcase.ITestPolicyCmptLink;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TestObject
extends IpsObjectPart
implements ITestObject {
    public static final TestParameterType DEFAULT_TYPE = TestParameterType.COMBINED;

    public TestObject(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    public abstract ITestObject getRoot();

    @Override
    public abstract boolean isRoot();

    @Override
    public boolean isInput() {
        TestObject root = (TestObject)this.getRoot();
        TestCase testCase = (TestCase)root.getParent();
        try {
            ITestPolicyCmptTypeParameter param = null;
            if (this instanceof ITestPolicyCmpt) {
                param = testCase.findTestPolicyCmptTypeParameter((ITestPolicyCmpt)((Object)this), this.getIpsProject());
            } else if (this instanceof ITestPolicyCmptLink) {
                param = testCase.findTestPolicyCmptTypeParameter((ITestPolicyCmptLink)((Object)this), this.getIpsProject());
            }
            if (param != null) {
                return testCase.isTypeOrDefault(param, TestParameterType.INPUT);
            }
        }
        catch (IpsException ipsException) {
            // empty catch block
        }
        return testCase.isTypeOrDefault(root.getTestParameterName(), TestParameterType.INPUT, DEFAULT_TYPE);
    }

    @Override
    public boolean isExpectedResult() {
        TestObject root = (TestObject)this.getRoot();
        TestCase testCase = (TestCase)root.getParent();
        try {
            ITestPolicyCmptTypeParameter param = null;
            if (this instanceof ITestPolicyCmpt) {
                param = testCase.findTestPolicyCmptTypeParameter((ITestPolicyCmpt)((Object)this), this.getIpsProject());
            } else if (this instanceof ITestPolicyCmptLink) {
                param = testCase.findTestPolicyCmptTypeParameter((ITestPolicyCmptLink)((Object)this), this.getIpsProject());
            }
            if (param != null) {
                return testCase.isTypeOrDefault(param, TestParameterType.EXPECTED_RESULT);
            }
        }
        catch (IpsException ipsException) {
            // empty catch block
        }
        return testCase.isTypeOrDefault(root.getTestParameterName(), TestParameterType.EXPECTED_RESULT, DEFAULT_TYPE);
    }

    @Override
    public boolean isCombined() {
        TestObject root = (TestObject)this.getRoot();
        TestCase testCase = (TestCase)root.getParent();
        try {
            ITestPolicyCmptTypeParameter param = null;
            if (this instanceof ITestPolicyCmpt) {
                param = testCase.findTestPolicyCmptTypeParameter((ITestPolicyCmpt)((Object)this), this.getIpsProject());
            } else if (this instanceof ITestPolicyCmptLink) {
                param = testCase.findTestPolicyCmptTypeParameter((ITestPolicyCmptLink)((Object)this), this.getIpsProject());
            }
            if (param != null) {
                return testCase.isTypeOrDefault(param, TestParameterType.COMBINED);
            }
        }
        catch (IpsException ipsException) {
            // empty catch block
        }
        return testCase.isTypeOrDefault(root.getTestParameterName(), TestParameterType.COMBINED, DEFAULT_TYPE);
    }

    @Override
    protected Element createElement(Document doc) {
        throw new RuntimeException("Not implemented!");
    }
}

