/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.testcase.Messages;
import org.faktorips.devtools.model.internal.testcase.TestAttributeValue;
import org.faktorips.devtools.model.internal.testcase.TestCase;
import org.faktorips.devtools.model.internal.testcase.TestObject;
import org.faktorips.devtools.model.internal.testcase.TestPolicyCmptLink;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.testcase.ITestAttributeValue;
import org.faktorips.devtools.model.testcase.ITestCase;
import org.faktorips.devtools.model.testcase.ITestObject;
import org.faktorips.devtools.model.testcase.ITestPolicyCmpt;
import org.faktorips.devtools.model.testcase.ITestPolicyCmptLink;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestPolicyCmpt
extends TestObject
implements ITestPolicyCmpt {
    static final String TAG_NAME = "PolicyCmptTypeObject";
    private String testPolicyCmptType = "";
    private String productCmpt = "";
    private String policyCmptType = "";
    private List<ITestAttributeValue> testAttributeValues = new ArrayList<ITestAttributeValue>(0);
    private List<ITestPolicyCmptLink> testPolicyCmptLinks = new ArrayList<ITestPolicyCmptLink>(0);

    public TestPolicyCmpt(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        int size = this.testAttributeValues.size() + this.testPolicyCmptLinks.size();
        ArrayList<IIpsObjectPart> children = new ArrayList<IIpsObjectPart>(size);
        children.addAll(this.testAttributeValues);
        children.addAll(this.testPolicyCmptLinks);
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.testAttributeValues = new ArrayList<ITestAttributeValue>();
        this.testPolicyCmptLinks = new ArrayList<ITestPolicyCmptLink>();
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof TestAttributeValue) {
            this.testAttributeValues.add((TestAttributeValue)part);
            return true;
        }
        if (part instanceof TestPolicyCmptLink) {
            this.testPolicyCmptLinks.add((TestPolicyCmptLink)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof TestAttributeValue) {
            this.testAttributeValues.remove(part);
            return true;
        }
        if (part instanceof TestPolicyCmptLink) {
            this.testPolicyCmptLinks.remove(part);
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if (xmlTagName.equals("AttributeValue")) {
            return this.newTestAttributeValueInternal(id);
        }
        if (xmlTagName.equals("Link")) {
            return this.newTestPcTypeLinkInternal(id);
        }
        return null;
    }

    @Override
    public String getTestPolicyCmptTypeParameter() {
        return this.testPolicyCmptType;
    }

    @Override
    public void setTestPolicyCmptTypeParameter(String testPolicyCmptTypeParameter) {
        String oldPolicyCmptType = this.testPolicyCmptType;
        this.testPolicyCmptType = testPolicyCmptTypeParameter;
        this.valueChanged(oldPolicyCmptType, testPolicyCmptTypeParameter);
    }

    @Override
    public ITestParameter findTestParameter(IIpsProject ipsProject) {
        return this.findTestPolicyCmptTypeParameter(ipsProject);
    }

    @Override
    public ITestPolicyCmptTypeParameter findTestPolicyCmptTypeParameter(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.testPolicyCmptType)) {
            return null;
        }
        return ((TestCase)this.getTestCase()).findTestPolicyCmptTypeParameter(this, ipsProject);
    }

    @Override
    public String getTestParameterName() {
        return this.testPolicyCmptType;
    }

    @Override
    public void setProductCmpt(String newProductCmpt) {
        String oldTestProductCmpt = this.productCmpt;
        this.productCmpt = newProductCmpt;
        this.valueChanged(oldTestProductCmpt, newProductCmpt);
    }

    @Override
    public String getProductCmpt() {
        return this.productCmpt;
    }

    @Override
    public void setProductCmptAndNameAfterIfApplicable(String prodCmptQName) {
        String oldProdCmptName = this.getNullSafeUnqualifiedName(this.getProductCmpt());
        String pctParameterName = this.getNullSafeUnqualifiedName(this.getTestPolicyCmptTypeParameter());
        this.setProductCmpt(prodCmptQName);
        if (this.getName() == null || IpsStringUtils.isEmpty((String)oldProdCmptName) && this.getName().equals(pctParameterName) || this.getName().matches(String.valueOf(oldProdCmptName) + "( \\([1-9][0-9]*\\))?")) {
            String uniqueName = null;
            uniqueName = IpsStringUtils.isEmpty((String)prodCmptQName) ? this.getTestCase().generateUniqueNameForTestPolicyCmpt(this, pctParameterName) : this.getTestCase().generateUniqueNameForTestPolicyCmpt(this, StringUtil.unqualifiedName((String)prodCmptQName));
            this.setName(uniqueName);
        }
    }

    private String getNullSafeUnqualifiedName(String qName) {
        return qName == null ? "" : StringUtil.unqualifiedName((String)qName);
    }

    @Override
    public IProductCmpt findProductCmpt(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.productCmpt)) {
            return null;
        }
        return ipsProject.findProductCmpt(this.productCmpt);
    }

    @Override
    public boolean isProductRelevant() {
        return !IpsStringUtils.isEmpty((String)this.productCmpt);
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.valueChanged(oldName, newName);
    }

    @Override
    public ITestCase getTestCase() {
        return (ITestCase)this.getRoot().getParent();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("name");
        this.testPolicyCmptType = element.getAttribute("testPolicyCmptType");
        this.policyCmptType = element.getAttribute("policyCmptType");
        this.productCmpt = element.getAttribute("productCmpt");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        element.setAttribute("testPolicyCmptType", this.testPolicyCmptType);
        element.setAttribute("policyCmptType", this.policyCmptType);
        element.setAttribute("productCmpt", this.productCmpt);
    }

    @Override
    public ITestAttributeValue newTestAttributeValue() {
        TestAttributeValue a = this.newTestAttributeValueInternal(this.getNextPartId());
        this.objectHasChanged();
        return a;
    }

    private TestAttributeValue newTestAttributeValueInternal(String id) {
        TestAttributeValue a = new TestAttributeValue(this, id);
        this.testAttributeValues.add(a);
        return a;
    }

    @Override
    public ITestAttributeValue getTestAttributeValue(String name) {
        for (ITestAttributeValue a : this.testAttributeValues) {
            if (!a.getTestAttribute().equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    public ITestAttributeValue[] getTestAttributeValues() {
        ITestAttributeValue[] a = new ITestAttributeValue[this.testAttributeValues.size()];
        this.testAttributeValues.toArray(a);
        return a;
    }

    void removeTestAttributeValue(TestAttributeValue attribute) {
        this.testAttributeValues.remove(attribute);
    }

    @Override
    public ITestPolicyCmptLink getTestPolicyCmptLink(String testPolicyCmptType) {
        ArgumentCheck.notNull((Object)testPolicyCmptType);
        for (ITestPolicyCmptLink r : this.testPolicyCmptLinks) {
            if (!r.getTestPolicyCmptTypeParameter().equals(testPolicyCmptType)) continue;
            return r;
        }
        return null;
    }

    @Override
    public ITestPolicyCmptLink[] getTestPolicyCmptLinks() {
        ITestPolicyCmptLink[] r = new ITestPolicyCmptLink[this.testPolicyCmptLinks.size()];
        this.testPolicyCmptLinks.toArray(r);
        return r;
    }

    @Override
    public ITestPolicyCmptLink[] getTestPolicyCmptLinks(String typeParameterName) {
        ArrayList<ITestPolicyCmptLink> links = new ArrayList<ITestPolicyCmptLink>();
        for (ITestPolicyCmptLink element : this.testPolicyCmptLinks) {
            if (!element.getTestPolicyCmptTypeParameter().equals(typeParameterName)) continue;
            links.add(element);
        }
        return links.toArray(new ITestPolicyCmptLink[0]);
    }

    @Override
    public ITestPolicyCmptLink newTestPolicyCmptLink() {
        TestPolicyCmptLink r = this.newTestPcTypeLinkInternal(this.getNextPartId());
        this.objectHasChanged();
        return r;
    }

    private TestPolicyCmptLink newTestPcTypeLinkInternal(String id) {
        TestPolicyCmptLink r = new TestPolicyCmptLink(this, id);
        this.testPolicyCmptLinks.add(r);
        return r;
    }

    void removeTestPcTypeLink(TestPolicyCmptLink link) {
        this.testPolicyCmptLinks.remove(link);
    }

    @Override
    public boolean isRoot() {
        return !(this.getParent() instanceof TestPolicyCmptLink);
    }

    @Override
    public ITestObject getRoot() {
        ITestPolicyCmpt testPolicyCmpt = this;
        while (!testPolicyCmpt.isRoot()) {
            testPolicyCmpt = testPolicyCmpt.getParentTestPolicyCmpt();
        }
        return testPolicyCmpt;
    }

    @Override
    public ITestPolicyCmpt getParentTestPolicyCmpt() {
        if (this.isRoot()) {
            return null;
        }
        ITestPolicyCmptLink testPcTypeLink = (ITestPolicyCmptLink)this.getParent();
        return (ITestPolicyCmpt)testPcTypeLink.getParent();
    }

    @Override
    public void removeLink(ITestPolicyCmptLink link) {
        int idx = 0;
        int foundIdx = -1;
        for (ITestPolicyCmptLink element : this.testPolicyCmptLinks) {
            if (element == link) {
                foundIdx = idx;
                break;
            }
            ++idx;
        }
        if (foundIdx >= 0) {
            this.testPolicyCmptLinks.remove(foundIdx);
            this.objectHasChanged();
        }
    }

    @Override
    public ITestPolicyCmptLink addTestPcTypeLink(ITestPolicyCmptTypeParameter typeParam, String productCmpt, String policyCmptType, String targetName) {
        return this.addTestPcTypeLink(typeParam, productCmpt, policyCmptType, targetName, false);
    }

    @Override
    public ITestPolicyCmptLink addTestPcTypeLink(final ITestPolicyCmptTypeParameter typeParam, final String productCmpt, final String policyCmptType, final String targetName, final boolean recursivelyAddRequired) {
        ArgumentCheck.notNull((Object)typeParam);
        if (!IpsStringUtils.isEmpty((String)productCmpt) && !IpsStringUtils.isEmpty((String)policyCmptType)) {
            throw new IpsException((IStatus)new IpsStatus(Messages.TestPolicyCmpt_Error_ProductCmpAndPolicyCmptTypeGiven));
        }
        final IPolicyCmptTypeAssociation policyCmptTypeAssociation = typeParam.findAssociation(typeParam.getIpsProject());
        if (policyCmptTypeAssociation == null) {
            throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestPolicyCmpt_Error_LinkNotFound, typeParam.getAssociation())));
        }
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<ITestPolicyCmptLink>(this.getIpsSrcFile()){
            private ITestPolicyCmptLink result;

            @Override
            protected ITestPolicyCmptLink getResult() {
                return this.result;
            }

            @Override
            protected boolean execute() {
                this.result = TestPolicyCmpt.this.addTestPolicyComponentLink(typeParam, productCmpt, policyCmptType, targetName, recursivelyAddRequired, policyCmptTypeAssociation);
                return true;
            }
        });
    }

    @Override
    public void addRequiredLinks(final IIpsProject ipsProject) {
        final IProductCmpt originalProductCmpt = this.findProductCmpt(this.getIpsProject());
        if (originalProductCmpt == null) {
            throw new IllegalStateException();
        }
        ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Void>(this.getIpsSrcFile()){

            @Override
            protected boolean execute() {
                ITestPolicyCmptTypeParameter[] iTestPolicyCmptTypeParameterArray = TestPolicyCmpt.this.findTestPolicyCmptTypeParameter(ipsProject).getTestPolicyCmptTypeParamChilds();
                int n = iTestPolicyCmptTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITestPolicyCmptTypeParameter childParameter = iTestPolicyCmptTypeParameterArray[n2];
                    boolean addedViaTestParameter = TestPolicyCmpt.this.addRequiredLinksViaTestParameter(childParameter);
                    if (!addedViaTestParameter) {
                        TestPolicyCmpt.this.addRequiredLinksViaParentProductCmpt(childParameter, originalProductCmpt);
                    }
                    ++n2;
                }
                return true;
            }
        });
    }

    private boolean addRequiredLinksViaTestParameter(ITestPolicyCmptTypeParameter testParameter) {
        IIpsSrcFile[] allowedProductCmptSrcFiles = testParameter.getAllowedProductCmpt(this.getIpsProject(), null);
        if (allowedProductCmptSrcFiles.length != 1 || testParameter.getMinInstances() == 0) {
            return false;
        }
        int i = 0;
        while (i < testParameter.getMinInstances()) {
            this.addTestPcTypeLink(testParameter, allowedProductCmptSrcFiles[0].getQualifiedNameType().getName(), null, null, true);
            ++i;
        }
        return true;
    }

    private void addRequiredLinksViaParentProductCmpt(ITestPolicyCmptTypeParameter testParameter, IProductCmpt originalProductCmpt) {
        IIpsSrcFile[] allowedProductCmptSrcFiles = testParameter.getAllowedProductCmpt(this.getIpsProject(), originalProductCmpt);
        List<IProductCmptLink> links = originalProductCmpt.getLinksIncludingGenerations();
        IIpsSrcFile[] iIpsSrcFileArray = allowedProductCmptSrcFiles;
        int n = allowedProductCmptSrcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFile allowedProductCmptSrcFile = iIpsSrcFileArray[n2];
            for (IProductCmptLink link : links) {
                if (!link.getTarget().equals(allowedProductCmptSrcFile.getQualifiedNameType().getName())) continue;
                int i = 0;
                while (i < link.getMinCardinality()) {
                    this.addTestPcTypeLink(testParameter, allowedProductCmptSrcFile.getQualifiedNameType().getName(), null, null, true);
                    ++i;
                }
            }
            ++n2;
        }
    }

    @Override
    public void updateDefaultTestAttributeValues() {
        ITestAttributeValue[] testAttrValues;
        IProductCmptGeneration generation = this.findProductCmpsCurrentGeneration(this.getIpsProject());
        ITestAttributeValue[] iTestAttributeValueArray = testAttrValues = this.getTestAttributeValues();
        int n = testAttrValues.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttributeValue testAttrValue = iTestAttributeValueArray[n2];
            if (generation != null) {
                ITestAttribute testAttribute = testAttrValue.findTestAttribute(this.getIpsProject());
                if (testAttribute != null && !testAttribute.isAttributeRelevantByProductCmpt(generation.getProductCmpt(), this.getIpsProject())) {
                    ((TestAttributeValue)testAttrValue).setValue(null);
                } else {
                    ((TestAttributeValue)testAttrValue).setDefaultTestAttributeValueInternal(generation);
                }
            }
            ++n2;
        }
    }

    @Override
    public int getIndexOfChildTestPolicyCmpt(ITestPolicyCmpt testPolicyCmpt) {
        Assert.isNotNull((Object)testPolicyCmpt);
        int idx = 0;
        for (ITestPolicyCmptLink testPolicyCmptLink : this.testPolicyCmptLinks) {
            if (testPolicyCmpt.equals(testPolicyCmptLink.findTarget())) {
                return idx;
            }
            ++idx;
        }
        throw new IpsException((IStatus)new IpsStatus(Messages.TestPolicyCmpt_Error_MoveNotPossibleBelongsToNoLink));
    }

    @Override
    public int[] moveTestPolicyCmptLink(int[] indexes, boolean up) {
        ListElementMover<ITestPolicyCmptLink> mover = new ListElementMover<ITestPolicyCmptLink>(this.testPolicyCmptLinks);
        int[] newIdxs = mover.move(indexes, up);
        this.valueChanged(indexes, newIdxs);
        return newIdxs;
    }

    public IProductCmptGeneration findProductCmpsCurrentGeneration(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.productCmpt)) {
            return null;
        }
        IProductCmpt productCmptObj = ipsProject.findProductCmpt(this.productCmpt);
        if (productCmptObj == null) {
            return null;
        }
        return productCmptObj.getLatestProductCmptGeneration();
    }

    void fixDifferentChildSortOrder() {
        ITestPolicyCmptTypeParameter[] paramChild;
        List<ITestPolicyCmptLink> oldLinks = this.testPolicyCmptLinks;
        IIpsProject ipsProject = this.getIpsProject();
        HashMap<ITestPolicyCmptTypeParameter, List> param2Links = new HashMap<ITestPolicyCmptTypeParameter, List>(oldLinks.size());
        for (ITestPolicyCmptLink testPolicyCmptLink : oldLinks) {
            ITestPolicyCmptTypeParameter paramOfLink = testPolicyCmptLink.findTestPolicyCmptTypeParameter(ipsProject);
            List linkList = param2Links.computeIfAbsent(paramOfLink, $ -> new ArrayList());
            linkList.add(testPolicyCmptLink);
        }
        ArrayList<ITestPolicyCmptLink> newChildList = new ArrayList<ITestPolicyCmptLink>();
        ITestPolicyCmptTypeParameter param = this.findTestPolicyCmptTypeParameter(this.getIpsProject());
        if (param == null) {
            throw new RuntimeException("Test parameter not found: " + this.testPolicyCmptType + "!");
        }
        ITestPolicyCmptTypeParameter[] iTestPolicyCmptTypeParameterArray = paramChild = param.getTestPolicyCmptTypeParamChilds();
        int n = paramChild.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptTypeParameter element = iTestPolicyCmptTypeParameterArray[n2];
            List links = (List)param2Links.get(element);
            if (links != null) {
                newChildList.addAll(links);
            }
            ++n2;
        }
        this.testPolicyCmptLinks = newChildList;
        this.valueChanged(false, true);
    }

    void fixDifferentTestAttrValueSortOrder() {
        ITestAttribute[] testAttr;
        ArrayList<ITestAttributeValue> newTestAttrValueList = new ArrayList<ITestAttributeValue>();
        ITestPolicyCmptTypeParameter param = this.findTestPolicyCmptTypeParameter(this.getIpsProject());
        ITestAttribute[] iTestAttributeArray = testAttr = param.getTestAttributes();
        int n = testAttr.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttribute element = iTestAttributeArray[n2];
            ITestAttributeValue testAttrValue = this.getTestAttributeValue(element.getName());
            if (testAttrValue == null) {
                throw new IpsException((IStatus)new IpsStatus("Couldn't fix the sort order of the test attribute values, because there is a mismatch between test case and its corresponding type!"));
            }
            newTestAttrValueList.add(testAttrValue);
            ++n2;
        }
        this.testAttributeValues = newTestAttrValueList;
        this.valueChanged(false, true);
    }

    protected ITestPolicyCmptLink[] getPolicyCmptLink() {
        return this.testPolicyCmptLinks.toArray(new ITestPolicyCmptLink[this.testPolicyCmptLinks.size()]);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        Message msg;
        String text;
        super.validateThis(list, ipsProject);
        ITestPolicyCmptTypeParameter param = this.findTestPolicyCmptTypeParameter(ipsProject);
        IProductCmpt productCmptObj = this.findProductCmpt(ipsProject);
        if (param == null) {
            text = MessageFormat.format(Messages.TestPolicyCmpt_ValidationError_TestCaseTypeParamNotFound, this.testPolicyCmptType);
            msg = new Message("TESTPOLICYCMPT-TestCaseTypeParamNotFound", text, Message.ERROR, (Object)this, new String[]{"testPolicyCmptType"});
            list.add(msg);
        } else {
            IPolicyCmptType policyCmptTypeUsed;
            IPolicyCmptType policyCmptTypeDefinedInTestType;
            if (param.isRequiresProductCmpt() && !this.hasProductCmpt()) {
                text = Messages.TestPolicyCmpt_ValidationError_ProductCmptRequired;
                msg = new Message("TESTPOLICYCMPT-ProductCmptIsRequired", text, Message.ERROR, (Object)this, new String[]{"productCmpt"});
                list.add(msg);
            }
            if ((policyCmptTypeDefinedInTestType = param.findPolicyCmptType(ipsProject)) == null) {
                String text2 = MessageFormat.format(Messages.TestPolicyCmpt_ValidationWarning_PolicyCmptNotExists, param.getPolicyCmptType(), this.testPolicyCmptType);
                Message msg2 = new Message("TESTPOLICYCMPTTYPEPARAMETER-PolicyCmptTypeNotExists", text2, Message.WARNING, (Object)this, new String[]{"policyCmptType"});
                list.add(msg2);
            }
            if ((policyCmptTypeUsed = this.findPolicyCmptType()) != null) {
                if (policyCmptTypeUsed.isAbstract()) {
                    text = MessageFormat.format(Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationError_PolicyCmptIsAbstract, policyCmptTypeUsed.getQualifiedName());
                    msg = new Message("TESTPOLICYCMPT-policyCmptTypeIsAbstract", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
                    list.add(msg);
                } else if (policyCmptTypeDefinedInTestType != null && !policyCmptTypeUsed.isSubtypeOrSameType(policyCmptTypeDefinedInTestType, ipsProject)) {
                    text = MessageFormat.format(Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationErrorPolicyCmptTypeNoSubtypeOrSameTypeParam, policyCmptTypeUsed.getQualifiedName(), policyCmptTypeDefinedInTestType.getQualifiedName());
                    msg = new Message("TESTPOLICYCMPT-PolicyCmptTypeNotAssignable", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
                    list.add(msg);
                }
            } else {
                String policyCmptTypeUsedQName = this.findPolicyCmptTypeQName(ipsProject);
                String text3 = MessageFormat.format(Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationError_PolicyCmptTypeNotExists, policyCmptTypeUsedQName);
                Message msg3 = new Message("TESTPOLICYCMPTTYPEPARAMETER-PolicyCmptTypeNotExists", text3, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
                list.add(msg3);
            }
        }
        if (this.hasProductCmpt() && productCmptObj == null) {
            text = MessageFormat.format(Messages.TestPolicyCmpt_ValidationWarning_ProductComponentNotExists, this.productCmpt, this.testPolicyCmptType);
            msg = new Message("TESTPOLICYCMPT-ProductCmptNotExists", text, Message.ERROR, (Object)this, new String[]{"productCmpt"});
            list.add(msg);
        }
        if (param != null) {
            ITestPolicyCmptTypeParameter[] paramForLinks;
            ITestPolicyCmptTypeParameter[] iTestPolicyCmptTypeParameterArray = paramForLinks = param.getTestPolicyCmptTypeParamChilds();
            int n = paramForLinks.length;
            int n2 = 0;
            while (n2 < n) {
                Message msg4;
                String text4;
                ITestPolicyCmptTypeParameter paramForLink = iTestPolicyCmptTypeParameterArray[n2];
                int currNumberOfInstances = this.getTestPolicyCmptLinks(paramForLink.getName()).length;
                int minInstances = paramForLink.getMinInstances();
                int maxInstances = paramForLink.getMaxInstances();
                if (currNumberOfInstances < minInstances) {
                    text4 = MessageFormat.format(Messages.TestPolicyCmptLink_ValidationError_MinimumNotReached, "" + paramForLink.getMinInstances(), paramForLink.getName());
                    msg4 = new Message("TESTPOLICYCMPT-MinInstancesNotReached", text4, Message.ERROR, (Object)this, new String[]{"minInstances"});
                    list.add(msg4);
                }
                if (currNumberOfInstances > maxInstances) {
                    text4 = MessageFormat.format(Messages.TestPolicyCmptLink_ValidationError_MaximumReached, "" + maxInstances, paramForLink.getName());
                    msg4 = new Message("TESTPOLICYCMPT-MaxInstancesReached", text4, Message.ERROR, (Object)this, new String[]{"maxInstances"});
                    list.add(msg4);
                }
                ++n2;
            }
        }
        if (IpsStringUtils.isNotEmpty((String)this.policyCmptType) && this.hasProductCmpt()) {
            text = Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationError_PolicyCmptTypeNotAllowedIfProductCmptIsSet;
            msg = new Message("TESTPOLICYCMPT-PolicyCmptTypeAndProductCmptTypeGiven", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
            list.add(msg);
        }
        this.validateAllowedProductCmpt(list, param, productCmptObj, ipsProject);
    }

    private String findPolicyCmptTypeQName(IIpsProject ipsProject) {
        if (IpsStringUtils.isNotEmpty((String)this.productCmpt)) {
            IProductCmpt productCmptFound = this.findProductCmpt(ipsProject);
            if (productCmptFound != null) {
                IPolicyCmptType policyCmptType = productCmptFound.findPolicyCmptType(ipsProject);
                if (policyCmptType == null) {
                    return null;
                }
                return policyCmptType.getQualifiedName();
            }
        } else {
            if (!IpsStringUtils.isEmpty((String)this.policyCmptType)) {
                return this.policyCmptType;
            }
            ITestPolicyCmptTypeParameter testPolicyCmptTypeParam = this.findTestPolicyCmptTypeParameter(ipsProject);
            if (testPolicyCmptTypeParam != null) {
                return testPolicyCmptTypeParam.getPolicyCmptType();
            }
        }
        return null;
    }

    private void validateAllowedProductCmpt(MessageList list, ITestPolicyCmptTypeParameter param, IProductCmpt productCmptCandidateObj, IIpsProject ipsProject) {
        if (param == null || productCmptCandidateObj == null) {
            return;
        }
        IPolicyCmptType policyCmptType = param.findPolicyCmptType(ipsProject);
        IPolicyCmptType policyCmptTypeOfCandidate = productCmptCandidateObj.findPolicyCmptType(ipsProject);
        if (!(policyCmptType == null || policyCmptType.equals(policyCmptTypeOfCandidate) || policyCmptTypeOfCandidate != null && policyCmptTypeOfCandidate.isSubtypeOf(policyCmptType, ipsProject))) {
            String text = MessageFormat.format(Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationError_ProductCmpNotAllowedRoot, productCmptCandidateObj.getName());
            Message msg = new Message("TESTPOLICYCMPT-WrongProductCmptOfLink", text, Message.ERROR, (Object)this, new String[]{"productCmpt"});
            list.add(msg);
            return;
        }
        if (!this.isRoot()) {
            ITestPolicyCmpt parentTestPolicyCmpt = this.getParentTestPolicyCmpt();
            if (parentTestPolicyCmpt == null) {
                return;
            }
            IPolicyCmptType parentPolicyCmptType = parentTestPolicyCmpt.findPolicyCmptType();
            if (parentPolicyCmptType == null || !parentPolicyCmptType.isConfigurableByProductCmptType()) {
                return;
            }
            ITestPolicyCmptTypeParameter parentParameter = param.getParentTestPolicyCmptTypeParam();
            if (parentParameter == null) {
                return;
            }
            IProductCmpt productCmptOfParent = parentTestPolicyCmpt.findProductCmpt(ipsProject);
            if (productCmptOfParent == null) {
                String text = MessageFormat.format(Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationError_ProductCmpCouldNotValidatedParentNotFound, productCmptCandidateObj.getName());
                Message msg = new Message("TESTPOLICYCMPT-ParentProductCmptOfLinkNotSpecified", text, Message.WARNING, (Object)this, new String[]{"productCmpt"});
                list.add(msg);
                return;
            }
            IPolicyCmptTypeAssociation association = param.findAssociation(ipsProject);
            if (association == null) {
                return;
            }
            IProductCmptTypeAssociation productCmptTypeAssociation = association.findMatchingProductCmptTypeAssociation(ipsProject);
            if (productCmptTypeAssociation == null) {
                return;
            }
            if (!productCmptOfParent.isReferencingProductCmpt(ipsProject, productCmptCandidateObj)) {
                String text = MessageFormat.format(Messages.TestPolicyCmpt_TestPolicyCmpt_ValidationError_ProductCmpNotAllowed, productCmptCandidateObj.getName());
                Message msg = new Message("TESTPOLICYCMPT-WrongProductCmptOfLink", text, Message.ERROR, (Object)this, new String[]{"productCmpt"});
                list.add(msg);
            }
        }
    }

    @Override
    public IAttribute findProductCmptTypeAttribute(String attribute, IIpsProject ipsProject) {
        if (!this.hasProductCmpt()) {
            return null;
        }
        IProductCmpt productCmptObj = this.findProductCmpt(ipsProject);
        if (productCmptObj == null) {
            return null;
        }
        IPolicyCmptType pct = productCmptObj.findPolicyCmptType(ipsProject);
        if (pct == null) {
            return null;
        }
        return pct.findPolicyCmptTypeAttribute(attribute, ipsProject);
    }

    @Override
    public IPolicyCmptType findPolicyCmptType() {
        String policyCmptTypeQName;
        IIpsProject ipsProject;
        block3: {
            ipsProject = this.getTestCase().getIpsProject();
            try {
                policyCmptTypeQName = this.findPolicyCmptTypeQName(ipsProject);
                if (policyCmptTypeQName != null) break block3;
                return null;
            }
            catch (IpsException e) {
                IpsLog.logAndShowErrorDialog((Exception)((Object)e));
                return null;
            }
        }
        return ipsProject.findPolicyCmptType(policyCmptTypeQName);
    }

    @Override
    public boolean hasProductCmpt() {
        return !IpsStringUtils.isEmpty((String)this.getProductCmpt());
    }

    @Override
    public String getPolicyCmptType() {
        return this.policyCmptType;
    }

    @Override
    public void setPolicyCmptType(String policyCmptType) {
        String oldPolicyCmptType = this.policyCmptType;
        this.policyCmptType = policyCmptType;
        this.valueChanged(oldPolicyCmptType, policyCmptType);
    }

    private ITestPolicyCmptLink addTestPolicyComponentLink(ITestPolicyCmptTypeParameter typeParam, String productCmpt, String policyCmptType, String targetName, boolean recursivelyAddRequired, IPolicyCmptTypeAssociation policyCmptTypeAssociation) {
        TestPolicyCmptLink result;
        if (!policyCmptTypeAssociation.isAssoziation()) {
            ITestAttribute[] attributes;
            result = new TestPolicyCmptLink(this, this.getNextPartId());
            result.setTestPolicyCmptTypeParameter(typeParam.getName());
            ITestPolicyCmpt newTestPolicyCmpt = result.newTargetTestPolicyCmptChild();
            newTestPolicyCmpt.setTestPolicyCmptTypeParameter(typeParam.getName());
            newTestPolicyCmpt.setPolicyCmptType(IpsStringUtils.isEmpty((String)policyCmptType) ? "" : policyCmptType);
            newTestPolicyCmpt.setProductCmptAndNameAfterIfApplicable(productCmpt);
            ITestAttribute[] iTestAttributeArray = attributes = typeParam.getTestAttributes();
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                ITestAttribute attribute = iTestAttributeArray[n2];
                ITestAttributeValue attrValue = newTestPolicyCmpt.newTestAttributeValue();
                attrValue.setTestAttribute(attribute.getName());
                ++n2;
            }
            newTestPolicyCmpt.updateDefaultTestAttributeValues();
            if (recursivelyAddRequired && newTestPolicyCmpt.findProductCmpt(this.getIpsProject()) != null) {
                newTestPolicyCmpt.addRequiredLinks(typeParam.getIpsProject());
            }
        } else {
            result = new TestPolicyCmptLink(this, this.getNextPartId());
            result.setTestPolicyCmptTypeParameter(typeParam.getName());
            result.setTarget(targetName);
        }
        ITestPolicyCmptLink prevLinkWithSameName = null;
        for (ITestPolicyCmptLink currLink : this.testPolicyCmptLinks) {
            if (!result.getTestPolicyCmptTypeParameter().equals(currLink.getTestPolicyCmptTypeParameter())) continue;
            prevLinkWithSameName = currLink;
        }
        if (prevLinkWithSameName != null) {
            int idx = this.testPolicyCmptLinks.indexOf(prevLinkWithSameName);
            this.testPolicyCmptLinks.add(idx + 1, result);
        } else {
            this.testPolicyCmptLinks.add(result);
        }
        this.fixDifferentChildSortOrder();
        return result;
    }
}

