/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.testcase.Messages;
import org.faktorips.devtools.model.internal.testcase.TestObject;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.testcase.ITestCase;
import org.faktorips.devtools.model.testcase.ITestObject;
import org.faktorips.devtools.model.testcase.ITestRule;
import org.faktorips.devtools.model.testcase.TestRuleViolationType;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestRuleParameter;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestRule
extends TestObject
implements ITestRule {
    static final String TAG_NAME = "RuleObject";
    private String testRuleParameter = "";
    private String validationRule = "";
    private TestRuleViolationType violationType = TestRuleViolationType.VIOLATED;

    public TestRule(IIpsObject parent, String id) {
        super(parent, id);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.testRuleParameter = element.getAttribute("testRuleParameter");
        this.validationRule = element.getAttribute("validationRule");
        this.violationType = TestRuleViolationType.getTestRuleViolationType(element.getAttribute("violationType"));
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("testRuleParameter", this.testRuleParameter);
        element.setAttribute("validationRule", this.validationRule);
        element.setAttribute("violationType", this.violationType.getId());
    }

    @Override
    public String getTestParameterName() {
        return this.testRuleParameter;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public ITestObject getRoot() {
        return this;
    }

    @Override
    public String getTestRuleParameter() {
        return this.testRuleParameter;
    }

    @Override
    public void setTestRuleParameter(String testRuleParameter) {
        String oldTestRuleParameter = this.testRuleParameter;
        this.testRuleParameter = testRuleParameter;
        this.valueChanged(oldTestRuleParameter, testRuleParameter);
    }

    @Override
    public ITestParameter findTestParameter(IIpsProject ipsProject) {
        return this.findTestRuleParameter(ipsProject);
    }

    @Override
    public ITestRuleParameter findTestRuleParameter(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.testRuleParameter)) {
            return null;
        }
        ITestCaseType testCaseType = ((ITestCase)this.getParent()).findTestCaseType(ipsProject);
        if (testCaseType == null) {
            return null;
        }
        ITestParameter param = testCaseType.getTestParameterByName(this.testRuleParameter);
        if (param instanceof ITestRuleParameter) {
            return (ITestRuleParameter)param;
        }
        return null;
    }

    @Override
    public String getValidationRule() {
        return this.validationRule;
    }

    @Override
    public void setValidationRule(String validationRule) {
        String oldValidationRule = this.validationRule;
        this.validationRule = validationRule;
        this.valueChanged(oldValidationRule, validationRule);
    }

    @Override
    public IValidationRule findValidationRule(IIpsProject ipsProject) {
        ITestCase testCase = (ITestCase)this.getParent();
        return testCase.findValidationRule(this.validationRule, ipsProject);
    }

    @Override
    public TestRuleViolationType getViolationType() {
        return this.violationType;
    }

    @Override
    public void setViolationType(TestRuleViolationType violationType) {
        TestRuleViolationType oldViolationType = this.violationType;
        this.violationType = violationType;
        this.valueChanged(oldViolationType, violationType);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        ITestRule[] rules;
        super.validateThis(list, ipsProject);
        if (this.findValidationRule(ipsProject) == null) {
            String text = MessageFormat.format(Messages.TestRule_ValidationError_ValidationRuleNotAvailable, this.validationRule);
            Message msg = new Message("TESTRULE-ValidationRuleNotExists", text, Message.ERROR, (Object)this, new String[]{"validationRule"});
            list.add(msg);
        }
        ITestCase testCase = (ITestCase)this.getParent();
        ITestRule[] iTestRuleArray = rules = testCase.getTestRuleObjects();
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            ITestRule rule = iTestRuleArray[n2];
            if (rule != this && rule.getValidationRule().equals(this.validationRule)) {
                String text = MessageFormat.format(Messages.TestRule_ValidationError_DuplicateValidationRule, this.validationRule);
                Message msg = new Message("TESTRULE-DuplicateValidationRule", text, Message.ERROR, (Object)this, new String[]{"validationRule"});
                list.add(msg);
                break;
            }
            ++n2;
        }
        ITestRuleParameter param = this.findTestRuleParameter(ipsProject);
        if (param == null) {
            String text = MessageFormat.format(Messages.TestRule_ValidationError_TestRuleParameterNotFound, this.getTestRuleParameter());
            Message msg = new Message("TESTRULE-TestRuleParamNotFound", text, Message.ERROR, (Object)this, new String[]{"testRuleParameter"});
            list.add(msg);
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.getTestRuleParameter()) + "/" + this.getValidationRule();
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return new IIpsElement[0];
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }
}

