/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcase;

import java.text.MessageFormat;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.testcase.Messages;
import org.faktorips.devtools.model.internal.testcase.TestObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.testcase.ITestCase;
import org.faktorips.devtools.model.testcase.ITestObject;
import org.faktorips.devtools.model.testcase.ITestValue;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestValueParameter;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestValue
extends TestObject
implements ITestValue {
    static final String TAG_NAME = "ValueObject";
    private String testValueParameter = "";
    private String value = "";

    public TestValue(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.testValueParameter = element.getAttribute("testValueParameter");
        this.value = ValueToXmlHelper.getValueFromElement((Element)element, (String)"Value");
        if (this.value == null) {
            this.value = ValueToXmlHelper.getValueFromElement((Element)element, (String)"value");
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("testValueParameter", this.testValueParameter);
        ValueToXmlHelper.addValueToElement((String)this.value, (Element)element, (String)"Value");
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public String getTestValueParameter() {
        return this.testValueParameter;
    }

    @Override
    public void setTestValueParameter(String testValueParameter) {
        String oldTValueParameter = this.testValueParameter;
        this.testValueParameter = testValueParameter;
        this.valueChanged(oldTValueParameter, testValueParameter);
    }

    @Override
    public String getTestParameterName() {
        return this.testValueParameter;
    }

    @Override
    public ITestParameter findTestParameter(IIpsProject ipsProject) {
        return this.findTestValueParameter(ipsProject);
    }

    @Override
    public ITestValueParameter findTestValueParameter(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.testValueParameter)) {
            return null;
        }
        ITestCaseType testCaseType = ((ITestCase)this.getParent()).findTestCaseType(ipsProject);
        if (testCaseType == null) {
            return null;
        }
        ITestParameter param = testCaseType.getTestParameterByName(this.testValueParameter);
        if (param instanceof ITestValueParameter) {
            return (ITestValueParameter)param;
        }
        return null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public void setDefaultValue() {
        ITestValueParameter parameter = this.findTestValueParameter(this.getIpsProject());
        if (parameter == null) {
            return;
        }
        ValueDatatype valueDatatype = parameter.findValueDatatype(this.getIpsProject());
        if (valueDatatype != null) {
            this.setValue(valueDatatype.getDefaultValue());
        }
    }

    @Override
    public ITestObject getRoot() {
        return this;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ITestValueParameter param = this.findTestValueParameter(ipsProject);
        if (param == null) {
            String text = MessageFormat.format(Messages.TestValue_ValidateError_TestValueParamNotFound, this.getTestValueParameter());
            Message msg = new Message("TESTVALUE-TestValueParamNotFound", text, Message.ERROR, (Object)this, new String[]{"value"});
            list.add(msg);
        } else {
            Message msg;
            String text;
            ValueDatatype datatype = param.findValueDatatype(ipsProject);
            if (datatype == null) {
                text = MessageFormat.format(Messages.TestValue_ValidateError_DatatypeNotFound, param.getValueDatatype());
                msg = new Message("TESTVALUEPARAMETER-ValueDatatypeNotFound", text, Message.WARNING, (Object)this, new String[]{"value"});
                list.add(msg);
            } else {
                ValidationUtils.checkValue(param.getDatatype(), this.value, this, "value", list);
            }
            if (param.isCombinedParameter() || !this.isInput() && !this.isExpectedResult()) {
                text = MessageFormat.format(Messages.TestValue_ErrorWrongType, param.getName());
                msg = new Message("TESTVALUEPARAMETER-WrongType", text, Message.WARNING, (Object)this, new String[]{"testParameterType"});
                list.add(msg);
            }
        }
    }

    @Override
    public String getName() {
        return this.getTestValueParameter();
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return new IIpsElement[0];
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }
}

