/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcasetype;

import java.text.MessageFormat;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.testcasetype.Messages;
import org.faktorips.devtools.model.internal.testcasetype.TestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestAttribute
extends AtomicIpsObjectPart
implements ITestAttribute {
    static final String TAG_NAME = "TestAttribute";
    private String attribute = "";
    private String datatype = "";
    private String policyCmptType = "";
    private TestParameterType type = TestParameterType.COMBINED;

    public TestAttribute(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.valueChanged(oldName, name);
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(String newAttribute) {
        String oldAttribute = this.attribute;
        this.attribute = newAttribute;
        this.valueChanged(oldAttribute, newAttribute);
    }

    @Override
    public void setAttribute(IPolicyCmptTypeAttribute policyCmptTypeAttribute) {
        String oldAttribute = this.attribute;
        String oldPolicyCmptTypeNameOfAttribute = this.policyCmptType;
        this.attribute = policyCmptTypeAttribute.getName();
        String policyCmptTypeNameOfAttribute = policyCmptTypeAttribute.getPolicyCmptType().getQualifiedName();
        this.policyCmptType = !policyCmptTypeNameOfAttribute.equals(this.getTestPolicyCmptTypeParameter().getPolicyCmptType()) ? policyCmptTypeNameOfAttribute : "";
        if (!this.valueChanged(oldAttribute, this.attribute)) {
            this.valueChanged(oldPolicyCmptTypeNameOfAttribute, this.policyCmptType);
        }
    }

    @Override
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(String newDatatype) {
        String oldDatatype = this.datatype;
        this.datatype = newDatatype;
        this.valueChanged(oldDatatype, newDatatype);
    }

    @Override
    public ValueDatatype findDatatype(IIpsProject project) {
        if (IpsStringUtils.isEmpty((String)this.attribute)) {
            return project.findValueDatatype(this.datatype);
        }
        IPolicyCmptTypeAttribute attr = this.findAttribute(project);
        if (attr == null) {
            return null;
        }
        return attr.findDatatype(project);
    }

    @Override
    public String getPolicyCmptType() {
        return this.policyCmptType;
    }

    @Override
    public void setPolicyCmptType(String policyCmptType) {
        String oldPolicyCmptType = this.policyCmptType;
        this.policyCmptType = policyCmptType;
        this.valueChanged(oldPolicyCmptType, policyCmptType);
    }

    @Override
    public String getCorrespondingPolicyCmptType() {
        IPolicyCmptTypeAttribute attribute = this.findAttribute(this.getIpsProject());
        if (attribute != null) {
            return attribute.getPolicyCmptType().getQualifiedName();
        }
        return this.policyCmptType;
    }

    @Override
    public TestPolicyCmptTypeParameter getTestPolicyCmptTypeParameter() {
        return (TestPolicyCmptTypeParameter)this.getParent();
    }

    @Override
    public IPolicyCmptTypeAttribute findAttribute(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.attribute)) {
            return null;
        }
        IPolicyCmptType pcType = null;
        pcType = IpsStringUtils.isEmpty((String)this.policyCmptType) ? ((TestPolicyCmptTypeParameter)this.getParent()).findPolicyCmptType(ipsProject) : ipsProject.findPolicyCmptType(this.policyCmptType);
        if (pcType == null) {
            return null;
        }
        return pcType.findPolicyCmptTypeAttribute(this.attribute, ipsProject);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("name");
        this.attribute = element.getAttribute("attribute");
        this.datatype = element.getAttribute("datatype");
        this.policyCmptType = element.getAttribute("policyCmptType");
        this.type = TestParameterType.getTestParameterType(element.getAttribute("testAttributeType"));
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        element.setAttribute("attribute", this.attribute);
        element.setAttribute("datatype", this.datatype);
        element.setAttribute("policyCmptType", this.policyCmptType);
        element.setAttribute("testAttributeType", this.type.getId());
    }

    @Override
    public boolean isExpextedResultAttribute() {
        return this.type == TestParameterType.EXPECTED_RESULT;
    }

    @Override
    public boolean isInputAttribute() {
        return this.type == TestParameterType.INPUT;
    }

    @Override
    public TestParameterType getTestAttributeType() {
        return this.type;
    }

    @Override
    public void setTestAttributeType(TestParameterType type) {
        ArgumentCheck.isTrue((type == TestParameterType.INPUT || type == TestParameterType.EXPECTED_RESULT ? 1 : 0) != 0);
        TestParameterType oldType = this.type;
        this.type = type;
        this.valueChanged((Object)oldType, (Object)type);
    }

    @Override
    public boolean isAttributeRelevantByProductCmpt(IProductCmpt productCmpt, IIpsProject ipsProject) {
        boolean reqProductCmpt = ((ITestPolicyCmptTypeParameter)this.getParent()).isRequiresProductCmpt();
        if (!reqProductCmpt) {
            return true;
        }
        if (productCmpt == null) {
            return false;
        }
        IPolicyCmptType policyCmptType = productCmpt.findPolicyCmptType(ipsProject);
        return policyCmptType.findPolicyCmptTypeAttribute(this.getAttribute(), ipsProject) != null;
    }

    @Override
    public boolean isBasedOnModelAttribute() {
        return !IpsStringUtils.isEmpty((String)this.attribute) && IpsStringUtils.isEmpty((String)this.datatype);
    }

    @Override
    protected void validateThis(MessageList messageList, IIpsProject ipsProject) {
        ITestAttribute[] testAttributes;
        TestParameterType parentType;
        Message msg;
        String text;
        super.validateThis(messageList, ipsProject);
        if (IpsStringUtils.isEmpty((String)this.getName())) {
            String text2 = Messages.TestAttribute_TestAttribute_Error_NameIsEmpty;
            Message msg2 = new Message("TESTATTRIBUTE-AttributeNameIsEmpty", text2, Message.ERROR, (Object)this, new String[]{"name"});
            messageList.add(msg2);
        }
        IPolicyCmptTypeAttribute modelAttribute = this.findAttribute(ipsProject);
        if (this.isBasedOnModelAttribute() && modelAttribute == null) {
            text = MessageFormat.format(Messages.TestAttribute_Error_AttributeNotFound, this.getAttribute());
            msg = new Message("TESTATTRIBUTE-AttributeNotFound", text, Message.ERROR, (Object)this, new String[]{"attribute"});
            messageList.add(msg);
        }
        if (IpsStringUtils.isNotEmpty((String)this.attribute) && IpsStringUtils.isNotEmpty((String)this.datatype)) {
            text = Messages.TestAttribute_Error_AttributeAndDatatypeGiven;
            msg = new Message("TESTATTRIBUTE-DatatypeAndAttributeAreGiven", text, Message.ERROR, (Object)this, new String[]{"datatype"});
            messageList.add(msg);
        }
        if (!this.isBasedOnModelAttribute()) {
            ValidationUtils.checkDatatypeReference(this.datatype, false, this, "datatype", "TESTATTRIBUTE-DatatypeNotFound", messageList, ipsProject);
        }
        if (!this.isInputAttribute() && !this.isExpextedResultAttribute()) {
            text = MessageFormat.format(Messages.TestAttribute_Error_TypeNotAllowed, new Object[]{this.type, this.name});
            msg = new Message("TESTATTRIBUTE-WrongType", text, Message.ERROR, (Object)this, new String[]{"testAttributeType"});
            messageList.add(msg);
        }
        if (!TestParameterType.isChildTypeMatching(this.type, parentType = ((ITestPolicyCmptTypeParameter)this.getParent()).getTestParameterType())) {
            String text3 = MessageFormat.format(Messages.TestAttribute_Error_TypeNotAllowedIfParent, new Object[]{this.type, parentType.getName()});
            Message msg3 = new Message("TESTATTRIBUTE-TypeDoesNotMatchParentType", text3, Message.ERROR, (Object)this, new String[]{"testAttributeType"});
            messageList.add(msg3);
        }
        TestPolicyCmptTypeParameter typeParam = (TestPolicyCmptTypeParameter)this.getParent();
        ITestAttribute[] iTestAttributeArray = testAttributes = typeParam.getTestAttributes();
        int n = testAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttribute testAttribute = iTestAttributeArray[n2];
            if (testAttribute != this && testAttribute.getName().equals(this.name)) {
                String text4 = MessageFormat.format(Messages.TestAttribute_Error_DuplicateName, this.name);
                Message msg4 = new Message("TESTATTRIBUTE-DuplicateTestAttributeName", text4, Message.ERROR, (Object)this, new String[]{"name"});
                messageList.add(msg4);
                break;
            }
            if (this.isBasedOnModelAttribute() && testAttribute != this && testAttribute.getAttribute().equals(this.attribute) && testAttribute.getTestAttributeType() == this.type) {
                String text5 = MessageFormat.format(Messages.TestAttribute_ValidationError_DuplicateAttributeAndType, this.attribute, this.type.getName());
                Message msg5 = new Message("TESTATTRIBUTE-DuplicateAttributeAndType", text5, Message.ERROR, (Object)this, new String[]{"attribute"});
                messageList.add(msg5);
                break;
            }
            ++n2;
        }
        if (modelAttribute != null) {
            ValueDatatype valueDatatype;
            if (AttributeType.DERIVED_ON_THE_FLY.equals((Object)modelAttribute.getAttributeType())) {
                String text6 = Messages.TestAttribute_ValidationWarning_DerivedOnTheFlyAttributesAreNotSupported;
                Message msg6 = new Message("TESTATTRIBUTE-DerivedAttributesOnTheFlyNotSupported", text6, Message.WARNING, (Object)this, new String[]{"testAttributeType"});
                messageList.add(msg6);
            }
            if (this.isBasedOnModelAttribute() && (valueDatatype = this.findDatatype(this.getIpsProject())) != null && valueDatatype.isAbstract()) {
                String text7 = MessageFormat.format(Messages.TestAttribute_ValidationError_AbstractAttribute, this.attribute, valueDatatype);
                Message msg7 = new Message("TESTATTRIBUTE-AbstractAttributesNotSupported", text7, Message.ERROR, (Object)this);
                messageList.add(msg7);
            }
        }
        this.validateName(messageList, ipsProject);
    }

    private void validateName(MessageList messageList, IIpsProject ipsProject) {
        if (this.isBasedOnModelAttribute()) {
            return;
        }
        if (this.name == null || !ValidationUtils.validateFieldName(this.name, ipsProject)) {
            messageList.add(new Message("TESTATTRIBUTE-InvalidTestAttributeName", MessageFormat.format(Messages.TestAttribute_TestAttribute_Error_InvalidTestAttributeName, this.name), Message.ERROR, (Object)this, new String[]{"name"}));
        }
    }
}

