/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcasetype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.DatatypeDependency;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.testcasetype.Messages;
import org.faktorips.devtools.model.internal.testcasetype.TestParameter;
import org.faktorips.devtools.model.internal.testcasetype.TestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.internal.testcasetype.TestRuleParameter;
import org.faktorips.devtools.model.internal.testcasetype.TestValueParameter;
import org.faktorips.devtools.model.internal.util.TreeSetHelper;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.ITestRuleParameter;
import org.faktorips.devtools.model.testcasetype.ITestValueParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;

public class TestCaseType
extends IpsObject
implements ITestCaseType {
    private List<ITestParameter> testParameters = new ArrayList<ITestParameter>();

    public TestCaseType(IIpsSrcFile file) {
        super(file);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return this.testParameters.toArray(new IIpsElement[this.testParameters.size()]);
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.testParameters.clear();
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof ITestParameter) {
            this.testParameters.add((ITestParameter)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof ITestParameter) {
            this.testParameters.remove(part);
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if ("PolicyCmptTypeParameter".equals(xmlTagName)) {
            return this.newTestPolicyCmptTypeParameterInternal(id);
        }
        if ("ValueParameter".equals(xmlTagName)) {
            return this.newTestValueParameterInternal(id);
        }
        if ("RuleParameter".equals(xmlTagName)) {
            return this.newTestRuleParameterInternal(id);
        }
        return null;
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.TEST_CASE_TYPE;
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        HashSet<IDependency> dependencies = new HashSet<IDependency>();
        this.addDependenciesForTestPolicyCmptTypeParams(dependencies, details, this.getTestPolicyCmptTypeParameters());
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    private void addDependenciesForTestPolicyCmptTypeParams(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details, ITestPolicyCmptTypeParameter[] parameters) {
        ITestPolicyCmptTypeParameter[] iTestPolicyCmptTypeParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptTypeParameter parameter = iTestPolicyCmptTypeParameterArray[n2];
            if (IpsStringUtils.isNotEmpty((String)parameter.getPolicyCmptType())) {
                IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(this.getQualifiedNameType(), new QualifiedNameType(parameter.getPolicyCmptType(), IpsObjectType.POLICY_CMPT_TYPE));
                dependencies.add(dependency);
                this.addDetails(details, dependency, parameter, "policyCmptType");
            }
            this.addDependenciesForTestPolicyCmptTypeParameterAttributes(parameter.getTestAttributes(), details, dependencies);
            this.addDependenciesForTestPolicyCmptTypeParams(dependencies, details, parameter.getTestPolicyCmptTypeParamChilds());
            ++n2;
        }
    }

    private void addDependenciesForTestPolicyCmptTypeParameterAttributes(ITestAttribute[] attributes, Map<IDependency, List<IDependencyDetail>> details, Set<IDependency> dependencies) {
        ITestAttribute[] iTestAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttribute attribute = iTestAttributeArray[n2];
            if (!IpsStringUtils.isEmpty((String)attribute.getPolicyCmptType())) {
                DatatypeDependency dependency = new DatatypeDependency(this.getQualifiedNameType(), attribute.getPolicyCmptType());
                dependencies.add(dependency);
                this.addDetails(details, dependency, attribute, "policyCmptType");
            }
            ++n2;
        }
    }

    @Override
    public ITestValueParameter[] getTestValueParameters() {
        return this.getTestParameters(null, TestValueParameter.class, null).toArray(new ITestValueParameter[0]);
    }

    @Override
    public ITestRuleParameter[] getTestRuleParameters() {
        return this.getTestParameters(null, TestRuleParameter.class, null).toArray(new ITestRuleParameter[0]);
    }

    @Override
    public ITestPolicyCmptTypeParameter[] getTestPolicyCmptTypeParameters() {
        return this.getTestParameters(null, TestPolicyCmptTypeParameter.class, null).toArray(new ITestPolicyCmptTypeParameter[0]);
    }

    @Override
    public ITestParameter[] getInputTestParameters() {
        return this.getTestParameters(TestParameterType.INPUT, null, null).toArray(new ITestParameter[0]);
    }

    @Override
    public ITestValueParameter[] getInputTestValueParameters() {
        return this.getTestParameters(TestParameterType.INPUT, TestValueParameter.class, null).toArray(new ITestValueParameter[0]);
    }

    @Override
    public ITestPolicyCmptTypeParameter[] getInputTestPolicyCmptTypeParameters() {
        return this.getTestParameters(TestParameterType.INPUT, TestPolicyCmptTypeParameter.class, null).toArray(new ITestPolicyCmptTypeParameter[0]);
    }

    @Override
    public ITestValueParameter getInputTestValueParameter(String inputTestValueParameter) {
        ITestValueParameter[] parameters = this.getTestParameters(TestParameterType.INPUT, TestValueParameter.class, inputTestValueParameter).toArray(new ITestValueParameter[0]);
        if (parameters.length == 0) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCaseType_Error_MoreThanOneValueParamWithTypeAndName, new Object[]{TestParameterType.INPUT, inputTestValueParameter})));
    }

    @Override
    public ITestPolicyCmptTypeParameter getInputTestPolicyCmptTypeParameter(String inputTestPolicyCmptTypeParameter) {
        ITestPolicyCmptTypeParameter[] parameters = this.getTestParameters(TestParameterType.INPUT, TestPolicyCmptTypeParameter.class, inputTestPolicyCmptTypeParameter).toArray(new ITestPolicyCmptTypeParameter[0]);
        if (parameters.length == 0) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCaseType_Error_MoreThanOnePolicyParamWithTypeAndName, new Object[]{TestParameterType.INPUT, inputTestPolicyCmptTypeParameter})));
    }

    @Override
    public ITestParameter getTestParameterByName(String testParameterName) {
        List<TestParameter> foundTestParameter = this.getTestParameters(null, null, testParameterName);
        if (foundTestParameter.size() == 0) {
            return null;
        }
        return foundTestParameter.get(0);
    }

    @Override
    public ITestParameter[] getTestParameters() {
        List<TestParameter> foundTestParameter = this.getTestParameters(null, null, null);
        if (foundTestParameter.size() == 0) {
            return new ITestParameter[0];
        }
        return foundTestParameter.toArray(new ITestParameter[0]);
    }

    @Override
    public ITestParameter[] getExpectedResultTestParameters() {
        return this.getTestParameters(TestParameterType.EXPECTED_RESULT, null, null).toArray(new ITestParameter[0]);
    }

    @Override
    public ITestValueParameter[] getExpectedResultTestValueParameters() {
        return this.getTestParameters(TestParameterType.EXPECTED_RESULT, TestValueParameter.class, null).toArray(new ITestValueParameter[0]);
    }

    @Override
    public ITestPolicyCmptTypeParameter[] getExpectedResultTestPolicyCmptTypeParameters() {
        return this.getTestParameters(TestParameterType.EXPECTED_RESULT, TestPolicyCmptTypeParameter.class, null).toArray(new ITestPolicyCmptTypeParameter[0]);
    }

    @Override
    public ITestValueParameter getExpectedResultTestValueParameter(String expResultTestValueParameter) {
        ITestValueParameter[] parameters = this.getTestParameters(TestParameterType.EXPECTED_RESULT, TestValueParameter.class, expResultTestValueParameter).toArray(new ITestValueParameter[0]);
        if (parameters.length == 0) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCaseType_Error_MoreThanOneParamWithTypeAndName, new Object[]{TestParameterType.INPUT, expResultTestValueParameter})));
    }

    @Override
    public ITestPolicyCmptTypeParameter getExpectedResultTestPolicyCmptTypeParameter(String expResultTestPolicyCmptTypeParameter) {
        ITestPolicyCmptTypeParameter[] parameters = this.getTestParameters(TestParameterType.EXPECTED_RESULT, TestPolicyCmptTypeParameter.class, expResultTestPolicyCmptTypeParameter).toArray(new ITestPolicyCmptTypeParameter[0]);
        if (parameters.length == 0) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        throw new IpsException((IStatus)new IpsStatus(MessageFormat.format(Messages.TestCaseType_Error_MoreThanOnePolicyParamWithTypeAndName, new Object[]{TestParameterType.INPUT, expResultTestPolicyCmptTypeParameter})));
    }

    @Override
    public ITestValueParameter newInputTestValueParameter() {
        TestValueParameter param = this.newTestValueParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.INPUT);
        this.objectHasChanged();
        return param;
    }

    @Override
    public ITestPolicyCmptTypeParameter newInputTestPolicyCmptTypeParameter() {
        TestPolicyCmptTypeParameter param = this.newTestPolicyCmptTypeParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.INPUT);
        this.objectHasChanged();
        return param;
    }

    @Override
    public ITestValueParameter newExpectedResultValueParameter() {
        TestValueParameter param = this.newTestValueParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.EXPECTED_RESULT);
        this.objectHasChanged();
        return param;
    }

    @Override
    public ITestPolicyCmptTypeParameter newExpectedResultPolicyCmptTypeParameter() {
        TestPolicyCmptTypeParameter param = this.newTestPolicyCmptTypeParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.EXPECTED_RESULT);
        this.objectHasChanged();
        return param;
    }

    @Override
    public TestRuleParameter newExpectedResultRuleParameter() {
        TestRuleParameter param = this.newTestRuleParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.EXPECTED_RESULT);
        this.objectHasChanged();
        return param;
    }

    @Override
    public ITestValueParameter newCombinedValueParameter() {
        TestValueParameter param = this.newTestValueParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.COMBINED);
        this.objectHasChanged();
        return param;
    }

    @Override
    public ITestPolicyCmptTypeParameter newCombinedPolicyCmptTypeParameter() {
        TestPolicyCmptTypeParameter param = this.newTestPolicyCmptTypeParameterInternal(this.getNextPartId());
        param.setTestParameterType(TestParameterType.COMBINED);
        this.objectHasChanged();
        return param;
    }

    void removeTestParameter(TestParameter param) {
        this.testParameters.remove(param);
    }

    private List<TestParameter> getTestParameters(TestParameterType type, Class<?> parameterClass, String name) {
        ArrayList<TestParameter> result = new ArrayList<TestParameter>(this.testParameters.size());
        for (ITestParameter iTestParameter : this.testParameters) {
            TestParameter parameter = (TestParameter)iTestParameter;
            boolean addParameter = true;
            if (parameter.getTestParameterType() != null && type != null && !TestParameterType.isTypeMatching(type, parameter.getTestParameterType())) {
                addParameter = false;
                continue;
            }
            if (parameterClass != null && !parameter.getClass().equals(parameterClass) || name != null && !name.equals(parameter.getName())) {
                addParameter = false;
                continue;
            }
            if (!addParameter) continue;
            result.add(parameter);
        }
        return result;
    }

    private TestPolicyCmptTypeParameter newTestPolicyCmptTypeParameterInternal(String id) {
        TestPolicyCmptTypeParameter p = new TestPolicyCmptTypeParameter(this, id);
        this.testParameters.add(p);
        return p;
    }

    private TestValueParameter newTestValueParameterInternal(String id) {
        TestValueParameter p = new TestValueParameter(this, id);
        this.testParameters.add(p);
        return p;
    }

    private TestRuleParameter newTestRuleParameterInternal(String id) {
        TestRuleParameter p = new TestRuleParameter(this, id);
        this.testParameters.add(p);
        return p;
    }

    @Override
    public String generateUniqueNameForTestAttribute(ITestAttribute testAttribute, String name) {
        ITestAttribute[] testAttribues;
        ITestPolicyCmptTypeParameter testPolicyCmptTypeParam = (ITestPolicyCmptTypeParameter)testAttribute.getParent();
        String uniqueName = name;
        int idx = 1;
        ITestAttribute[] iTestAttributeArray = testAttribues = testPolicyCmptTypeParam.getTestAttributes();
        int n = testAttribues.length;
        int n2 = 0;
        while (n2 < n) {
            ITestAttribute testAttribue = iTestAttributeArray[n2];
            if (testAttribue != testAttribute && testAttribue.getName().equals(uniqueName)) {
                uniqueName = String.valueOf(name) + " (" + idx++ + ")";
            }
            ++n2;
        }
        return uniqueName;
    }

    @Override
    public int[] moveTestParameters(int[] indexes, boolean up) {
        ListElementMover<ITestParameter> mover = new ListElementMover<ITestParameter>(this.testParameters);
        int[] newIdxs = mover.move(indexes, up);
        this.valueChanged(indexes, newIdxs);
        return newIdxs;
    }

    @Override
    public IValidationRule[] getTestRuleCandidates(IIpsProject ipsProject) {
        ArrayList<IValidationRule> validationRules = new ArrayList<IValidationRule>();
        this.getValidationRules(this.getTestPolicyCmptTypeParameters(), validationRules, ipsProject);
        return validationRules.toArray(new IValidationRule[0]);
    }

    @Override
    public IValidationRule findValidationRule(String validationRuleName, IIpsProject ipsProject) {
        IValidationRule[] validationRules;
        IValidationRule[] iValidationRuleArray = validationRules = this.getTestRuleCandidates(ipsProject);
        int n = validationRules.length;
        int n2 = 0;
        while (n2 < n) {
            IValidationRule validationRule = iValidationRuleArray[n2];
            if (validationRule.getName().equals(validationRuleName)) {
                return validationRule;
            }
            ++n2;
        }
        return null;
    }

    private void getValidationRules(ITestPolicyCmptTypeParameter[] testPolicyCmptTypeParameters, List<IValidationRule> validationRules, IIpsProject ipsProject) {
        ITestPolicyCmptTypeParameter[] iTestPolicyCmptTypeParameterArray = testPolicyCmptTypeParameters;
        int n = testPolicyCmptTypeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITestPolicyCmptTypeParameter parameter = iTestPolicyCmptTypeParameterArray[n2];
            IPolicyCmptType policyCmptType = parameter.findPolicyCmptType(ipsProject);
            if (policyCmptType != null) {
                validationRules.addAll(policyCmptType.getSupertypeHierarchy().getAllRules(policyCmptType));
                this.getValidationRules(parameter.getTestPolicyCmptTypeParamChilds(), validationRules, ipsProject);
            }
            ++n2;
        }
    }

    public ITestParameter[] getAllTestParameter() {
        ITestParameter[] parameters;
        ArrayList<ITestParameter> allParameters = new ArrayList<ITestParameter>();
        ITestParameter[] iTestParameterArray = parameters = this.getTestParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITestParameter parameter = iTestParameterArray[n2];
            this.getAllChildTestParameter(parameter, allParameters);
            ++n2;
        }
        return allParameters.toArray(new ITestParameter[allParameters.size()]);
    }

    private void getAllChildTestParameter(ITestParameter testParameter, List<ITestParameter> allParameters) {
        IIpsElement[] elems;
        allParameters.add(testParameter);
        IIpsElement[] iIpsElementArray = elems = testParameter.getChildren();
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsElement elem = iIpsElementArray[n2];
            if (elem instanceof ITestParameter) {
                this.getAllChildTestParameter((ITestParameter)elem, allParameters);
            }
            ++n2;
        }
    }

    @Override
    public Collection<IIpsSrcFile> searchMetaObjectSrcFiles(boolean includeSubtypes) {
        IIpsProject[] searchProjects;
        TreeSet<IIpsSrcFile> result = TreeSetHelper.newIpsSrcFileTreeSet();
        IIpsProject[] iIpsProjectArray = searchProjects = this.getIpsProject().findReferencingProjectLeavesOrSelf();
        int n = searchProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject project = iIpsProjectArray[n2];
            result.addAll(Arrays.asList(project.findAllTestCaseSrcFiles(this)));
            ++n2;
        }
        return result;
    }
}

