/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcasetype;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.testcasetype.Messages;
import org.faktorips.devtools.model.internal.testcasetype.TestCaseType;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TestParameter
extends IpsObjectPart
implements ITestParameter {
    protected TestParameterType type = TestParameterType.COMBINED;

    public TestParameter(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    public abstract boolean isRoot();

    @Override
    public abstract ITestParameter getRootParameter();

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.valueChanged(oldName, newName);
    }

    @Override
    protected Element createElement(Document doc) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("name");
        this.type = TestParameterType.getTestParameterType(element.getAttribute("testParameterType"));
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        element.setAttribute("testParameterType", this.type.getId());
    }

    @Override
    public boolean isInputOrCombinedParameter() {
        return this.type == TestParameterType.INPUT || this.type == TestParameterType.COMBINED;
    }

    @Override
    public boolean isExpextedResultOrCombinedParameter() {
        return TestParameterType.EXPECTED_RESULT == this.type || TestParameterType.COMBINED == this.type;
    }

    @Override
    public boolean isCombinedParameter() {
        return this.type == TestParameterType.COMBINED;
    }

    @Override
    public TestParameterType getTestParameterType() {
        return this.type;
    }

    @Override
    public abstract void setTestParameterType(TestParameterType var1);

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ITestParameter[] testParameters = null;
        if (this.isRoot()) {
            testParameters = ((ITestCaseType)this.getParent()).getTestParameters();
        } else {
            IIpsElement[] childrenOfParent = ((ITestParameter)this.getParent()).getChildren();
            ArrayList<ITestParameter> testParameterChildrenOfParent = new ArrayList<ITestParameter>(childrenOfParent.length);
            IIpsElement[] iIpsElementArray = childrenOfParent;
            int n = childrenOfParent.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsElement element = iIpsElementArray[n2];
                if (element instanceof ITestParameter) {
                    testParameterChildrenOfParent.add((ITestParameter)element);
                }
                ++n2;
            }
            testParameters = testParameterChildrenOfParent.toArray(new ITestParameter[0]);
        }
        if (testParameters != null) {
            ITestParameter[] iTestParameterArray = testParameters;
            int n = testParameters.length;
            int testParameterChildrenOfParent = 0;
            while (testParameterChildrenOfParent < n) {
                ITestParameter testParameter = iTestParameterArray[testParameterChildrenOfParent];
                if (testParameter != this && testParameter.getName().equals(this.name)) {
                    String text = MessageFormat.format(Messages.TestParameter_ValidationError_DuplicateName, this.name);
                    Message msg = new Message("TESTPARAMETER-DuplicateName", text, Message.ERROR, (Object)this, new String[]{"name"});
                    list.add(msg);
                    break;
                }
                ++testParameterChildrenOfParent;
            }
        }
        if (!ValidationUtils.validateFieldName(this.name, ipsProject)) {
            String text = MessageFormat.format(Messages.TestParameter_ValidateError_InvalidTestParamName, this.name);
            Message msg = new Message("TESTPARAMETER-InvalidName", text, Message.ERROR, (Object)this, new String[]{"name"});
            list.add(msg);
        }
    }

    public TestCaseType getTestCaseType() {
        if (this.isRoot()) {
            return (TestCaseType)this.getParent();
        }
        ITestParameter root = this.getRootParameter();
        return (TestCaseType)root.getParent();
    }
}

