/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcasetype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.testcasetype.Messages;
import org.faktorips.devtools.model.internal.testcasetype.TestAttribute;
import org.faktorips.devtools.model.internal.testcasetype.TestParameter;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.testcasetype.ITestAttribute;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestPolicyCmptTypeParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestPolicyCmptTypeParameter
extends TestParameter
implements ITestPolicyCmptTypeParameter {
    static final String TAG_NAME = "PolicyCmptTypeParameter";
    private String policyCmptType = "";
    private String association = "";
    private boolean requiresProductCmpt = false;
    private List<ITestAttribute> testAttributes = new ArrayList<ITestAttribute>(0);
    private List<ITestPolicyCmptTypeParameter> testPolicyCmptTypeChilds = new ArrayList<ITestPolicyCmptTypeParameter>(0);
    private int minInstances = 0;
    private int maxInstances = 1;

    public TestPolicyCmptTypeParameter(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        int size = this.testAttributes.size() + this.testPolicyCmptTypeChilds.size();
        ArrayList<IDescribedElement> children = new ArrayList<IDescribedElement>(size);
        children.addAll(this.testAttributes);
        children.addAll(this.testPolicyCmptTypeChilds);
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.testAttributes = new ArrayList<ITestAttribute>();
        this.testPolicyCmptTypeChilds = new ArrayList<ITestPolicyCmptTypeParameter>();
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof ITestAttribute) {
            this.testAttributes.add((ITestAttribute)part);
            return true;
        }
        if (part instanceof TestPolicyCmptTypeParameter) {
            this.testPolicyCmptTypeChilds.add((TestPolicyCmptTypeParameter)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof TestAttribute) {
            this.testAttributes.remove(part);
            return true;
        }
        if (part instanceof TestPolicyCmptTypeParameter) {
            this.testPolicyCmptTypeChilds.remove(part);
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if (xmlTagName.equals("TestAttribute")) {
            return this.newTestAttributeInternal(id);
        }
        if (xmlTagName.equals(TAG_NAME)) {
            return this.newTestPolicyCmptTypeParamChildInternal(id);
        }
        return null;
    }

    @Override
    public String getDatatype() {
        return this.getPolicyCmptType();
    }

    @Override
    public void setDatatype(String datatype) {
        this.setPolicyCmptType(datatype);
    }

    @Override
    public void setTestParameterType(TestParameterType testParameterType) {
        ArgumentCheck.isTrue((testParameterType.equals((Object)TestParameterType.INPUT) || testParameterType.equals((Object)TestParameterType.EXPECTED_RESULT) || testParameterType.equals((Object)TestParameterType.COMBINED) ? 1 : 0) != 0);
        TestParameterType oldType = this.type;
        this.type = testParameterType;
        this.valueChanged((Object)oldType, (Object)testParameterType);
    }

    @Override
    public String getPolicyCmptType() {
        return this.policyCmptType;
    }

    @Override
    public void setPolicyCmptType(String policyCmptType) {
        String oldPolicyCmptType = this.policyCmptType;
        this.policyCmptType = policyCmptType;
        this.valueChanged(oldPolicyCmptType, policyCmptType);
    }

    @Override
    public IPolicyCmptType findPolicyCmptType(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.policyCmptType)) {
            return null;
        }
        return ipsProject.findPolicyCmptType(this.policyCmptType);
    }

    @Override
    public String getAssociation() {
        return this.association;
    }

    @Override
    public void setAssociation(String association) {
        String oldAssociation = this.association;
        this.association = association;
        this.valueChanged(oldAssociation, association);
    }

    @Override
    public IPolicyCmptTypeAssociation findAssociation(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.association) || this.isRoot()) {
            return null;
        }
        ITestPolicyCmptTypeParameter parent = (ITestPolicyCmptTypeParameter)this.getParent();
        IPolicyCmptType pcType = parent.findPolicyCmptType(ipsProject);
        while (pcType != null) {
            List<IPolicyCmptTypeAssociation> associations = pcType.getPolicyCmptTypeAssociations();
            for (IPolicyCmptTypeAssociation association2 : associations) {
                if (!association2.getName().equals(this.association)) continue;
                return association2;
            }
            pcType = (IPolicyCmptType)pcType.findSupertype(ipsProject);
        }
        return null;
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.policyCmptType = element.getAttribute("policyCmptType");
        this.association = element.getAttribute("association");
        this.requiresProductCmpt = XmlUtil.getBooleanAttributeOrFalse(element, "requiresProductCmpt");
        try {
            this.minInstances = Integer.parseInt(element.getAttribute("minInstances"));
        }
        catch (NumberFormatException e) {
            this.minInstances = 0;
        }
        try {
            this.maxInstances = Integer.parseInt(element.getAttribute("maxInstances"));
        }
        catch (NumberFormatException e) {
            this.maxInstances = 0;
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("policyCmptType", this.policyCmptType);
        element.setAttribute("association", this.association);
        if (this.requiresProductCmpt) {
            element.setAttribute("requiresProductCmpt", "" + this.requiresProductCmpt);
        }
        element.setAttribute("minInstances", "" + this.minInstances);
        element.setAttribute("maxInstances", "" + this.maxInstances);
    }

    @Override
    public ITestAttribute newInputTestAttribute() {
        TestAttribute a = this.newTestAttributeInternal(this.getNextPartId());
        a.setTestAttributeType(TestParameterType.INPUT);
        this.objectHasChanged();
        return a;
    }

    @Override
    public ITestAttribute newExpectedResultTestAttribute() {
        TestAttribute a = this.newTestAttributeInternal(this.getNextPartId());
        a.setTestAttributeType(TestParameterType.EXPECTED_RESULT);
        this.objectHasChanged();
        return a;
    }

    private TestAttribute newTestAttributeInternal(String id) {
        TestAttribute a = new TestAttribute(this, id);
        this.testAttributes.add(a);
        return a;
    }

    @Override
    public ITestPolicyCmptTypeParameter newTestPolicyCmptTypeParamChild() {
        TestPolicyCmptTypeParameter p = this.newTestPolicyCmptTypeParamChildInternal(this.getNextPartId());
        this.objectHasChanged();
        return p;
    }

    @Override
    public ITestAttribute getTestAttribute(String attributeName) {
        for (ITestAttribute a : this.testAttributes) {
            if (!a.getName().equals(attributeName)) continue;
            return a;
        }
        return null;
    }

    @Override
    public ITestAttribute[] getTestAttributes() {
        ITestAttribute[] a = new ITestAttribute[this.testAttributes.size()];
        this.testAttributes.toArray(a);
        return a;
    }

    @Override
    public ITestAttribute[] getTestAttributes(String attributeName) {
        ArrayList<ITestAttribute> testAttributeList = new ArrayList<ITestAttribute>();
        for (ITestAttribute testAttribute : this.testAttributes) {
            if (!testAttribute.getAttribute().equals(attributeName)) continue;
            testAttributeList.add(testAttribute);
        }
        return testAttributeList.toArray(new ITestAttribute[testAttributeList.size()]);
    }

    void removeTestAttribute(TestAttribute attribute) {
        this.testAttributes.remove(attribute);
    }

    public ITestPolicyCmptTypeParameter getTestPolicyCmptTypeChild(String name) {
        for (ITestPolicyCmptTypeParameter p : this.testPolicyCmptTypeChilds) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public ITestPolicyCmptTypeParameter[] getTestPolicyCmptTypeParamChilds() {
        ITestPolicyCmptTypeParameter[] p = new TestPolicyCmptTypeParameter[this.testPolicyCmptTypeChilds.size()];
        this.testPolicyCmptTypeChilds.toArray(p);
        return p;
    }

    @Override
    public ITestPolicyCmptTypeParameter getTestPolicyCmptTypeParamChild(String name) {
        for (ITestPolicyCmptTypeParameter p : this.testPolicyCmptTypeChilds) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private TestPolicyCmptTypeParameter newTestPolicyCmptTypeParamChildInternal(String id) {
        TestPolicyCmptTypeParameter p = new TestPolicyCmptTypeParameter(this, id);
        this.testPolicyCmptTypeChilds.add(p);
        return p;
    }

    @Override
    public ITestPolicyCmptTypeParameter getParentTestPolicyCmptTypeParam() {
        return (ITestPolicyCmptTypeParameter)this.getParent();
    }

    @Override
    public void removeTestPolicyCmptTypeParamChild(ITestPolicyCmptTypeParameter testPolicyCmptTypeParamChildName) {
        this.testPolicyCmptTypeChilds.remove(testPolicyCmptTypeParamChildName);
    }

    @Override
    public ITestParameter getRootParameter() {
        ITestParameter current = this;
        while (!current.isRoot()) {
            current = (ITestParameter)current.getParent();
        }
        return current;
    }

    @Override
    public boolean isRequiresProductCmpt() {
        return this.requiresProductCmpt;
    }

    @Override
    public void setRequiresProductCmpt(boolean newNeedsProductCmpt) {
        boolean oldRequiresProductCmpt = this.requiresProductCmpt;
        this.requiresProductCmpt = newNeedsProductCmpt;
        this.valueChanged(oldRequiresProductCmpt, newNeedsProductCmpt);
    }

    @Override
    public int getMinInstances() {
        return this.minInstances;
    }

    @Override
    public void setMinInstances(int minInstances) {
        int oldMinInstances = this.minInstances;
        this.minInstances = minInstances;
        this.valueChanged(oldMinInstances, minInstances);
    }

    @Override
    public int getMaxInstances() {
        return this.maxInstances;
    }

    @Override
    public void setMaxInstances(int maxInstances) {
        int oldMaxInstances = this.maxInstances;
        this.maxInstances = maxInstances;
        this.valueChanged(oldMaxInstances, maxInstances);
    }

    @Override
    public boolean isRoot() {
        return !(this.getParent() instanceof TestPolicyCmptTypeParameter);
    }

    @Override
    public int[] moveTestAttributes(int[] indexes, boolean up) {
        ListElementMover<ITestAttribute> mover = new ListElementMover<ITestAttribute>(this.testAttributes);
        int[] newIdxs = mover.move(indexes, up);
        this.valueChanged(indexes, newIdxs);
        return newIdxs;
    }

    @Override
    public int[] moveTestPolicyCmptTypeChild(int[] indexes, boolean up) {
        ListElementMover<ITestPolicyCmptTypeParameter> mover = new ListElementMover<ITestPolicyCmptTypeParameter>(this.testPolicyCmptTypeChilds);
        int[] newIdxs = mover.move(indexes, up);
        this.valueChanged(indexes, newIdxs);
        return newIdxs;
    }

    @Override
    public IIpsSrcFile[] getAllowedProductCmpt(IIpsProject ipsProjectToSearch, IProductCmpt productCmpt) {
        if (this.isRoot() || productCmpt == null) {
            IPolicyCmptType allowedPolicyCmptType = this.findPolicyCmptType(ipsProjectToSearch);
            if (allowedPolicyCmptType == null) {
                return new IIpsSrcFile[0];
            }
            IProductCmptType productCmptType = allowedPolicyCmptType.findProductCmptType(ipsProjectToSearch);
            if (productCmptType == null) {
                return new IIpsSrcFile[0];
            }
            return ipsProjectToSearch.findAllProductCmptSrcFiles(productCmptType, true);
        }
        IPolicyCmptTypeAssociation policyCmptTypeAssociation = this.findAssociation(ipsProjectToSearch);
        if (policyCmptTypeAssociation == null) {
            return new IIpsSrcFile[0];
        }
        IPolicyCmptType policyCmptTypeTarget = policyCmptTypeAssociation.findTargetPolicyCmptType(ipsProjectToSearch);
        if (policyCmptTypeTarget == null || !policyCmptTypeTarget.isConfigurableByProductCmptType()) {
            return new IIpsSrcFile[0];
        }
        IProductCmptType productCmptTypeTarget = policyCmptTypeTarget.findProductCmptType(ipsProjectToSearch);
        if (productCmptTypeTarget == null) {
            return new IIpsSrcFile[0];
        }
        IProductCmptTypeAssociation association2 = policyCmptTypeAssociation.findMatchingProductCmptTypeAssociation(ipsProjectToSearch);
        if (association2 == null) {
            return new IIpsSrcFile[0];
        }
        ArrayList<IIpsSrcFile> result = new ArrayList<IIpsSrcFile>(100);
        List<IProductCmptLink> links = productCmpt.getLinksIncludingGenerations();
        for (IProductCmptLink link : links) {
            IProductCmpt productCmptFound;
            IIpsSrcFile productCmptFoundSrc = ipsProjectToSearch.findIpsSrcFile(IpsObjectType.PRODUCT_CMPT, link.getTarget());
            if (productCmptFoundSrc == null || result.contains(productCmptFoundSrc) || (productCmptFound = (IProductCmpt)productCmptFoundSrc.getIpsObject()) == null) continue;
            IPolicyCmptType pcType = this.findPolicyCmptType(ipsProjectToSearch);
            IPolicyCmptType pcTypeOfProduct = productCmptFound.findPolicyCmptType(ipsProjectToSearch);
            if (pcType != null && pcTypeOfProduct != null && !pcTypeOfProduct.isSubtypeOrSameType(pcType, ipsProjectToSearch) || pcType == null || pcTypeOfProduct == null) continue;
            result.add(productCmptFoundSrc);
        }
        return result.toArray(new IIpsSrcFile[result.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        Message msg;
        String text;
        TestParameterType parentType;
        Message msg2;
        String text2;
        super.validateThis(list, ipsProject);
        IPolicyCmptType policyCmptTypeFound = this.findPolicyCmptType(ipsProject);
        if (policyCmptTypeFound == null) {
            text2 = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_PolicyCmptTypeNotExists, this.policyCmptType);
            msg2 = new Message("TESTPOLICYCMPTTYPEPARAMETER-PolicyCmptTypeNotExists", text2, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
            list.add(msg2);
        }
        if (this.minInstances > this.maxInstances) {
            text2 = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_MinGreaterThanMax, "" + this.minInstances, "" + this.maxInstances);
            msg2 = new Message("TESTPOLICYCMPTTYPEPARAMETER-MinInstancesIsGreaterThanMax", text2, Message.ERROR, (Object)this, new String[]{"minInstances"});
            list.add(msg2);
        }
        if (this.maxInstances < this.minInstances) {
            text2 = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_MaxLessThanMin, "" + this.minInstances, "" + this.maxInstances);
            msg2 = new Message("TESTPOLICYCMPTTYPEPARAMETER-MaxInstancesIsLessThanMin", text2, Message.ERROR, (Object)this, new String[]{"maxInstances"});
            list.add(msg2);
        }
        if (!this.isRoot() && !TestParameterType.isChildTypeMatching(this.type, parentType = ((ITestPolicyCmptTypeParameter)this.getParent()).getTestParameterType())) {
            text = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_TypeNotAllowed, this.type.getName(), parentType.getName());
            msg = new Message("TESTPOLICYCMPTTYPEPARAMETER-TypeDoesNotMatchParentType", text, Message.ERROR, (Object)this, new String[]{"testParameterType"});
            list.add(msg);
        }
        if (!this.isRoot()) {
            IPolicyCmptTypeAssociation associationFound = this.findAssociation(ipsProject);
            if (associationFound == null) {
                text = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_AssociationNotExists, this.association);
                msg = new Message("TESTPOLICYCMPTTYPEPARAMETER-AssociationNotExists", text, Message.ERROR, (Object)this, new String[]{"association"});
                list.add(msg);
            } else if (policyCmptTypeFound != null) {
                IPolicyCmptType targetOfAssociation = associationFound.findTargetPolicyCmptType(ipsProject);
                if (targetOfAssociation == null) {
                    text = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_TargetOfAssociationNotExists, associationFound.getTarget(), this.association);
                    msg = new Message("TESTPOLICYCMPTTYPEPARAMETER-TargetOfAssociationNotExists", text, Message.WARNING, (Object)this, new String[]{"association"});
                    list.add(msg);
                } else if (!policyCmptTypeFound.isSubtypeOrSameType(targetOfAssociation, ipsProject)) {
                    text = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_PolicyCmptNotAllowedForAssociation, this.policyCmptType, this.association);
                    msg = new Message("TESTPOLICYCMPTTYPEPARAMETER-WrongPolicyCmptTypeOfAssociation", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"});
                    list.add(msg);
                }
                if (associationFound.isAssoziation()) {
                    ITestParameter[] allTestParameter;
                    Object targetOfAssoziationInTestCaseType = null;
                    ITestParameter[] iTestParameterArray = allTestParameter = this.getTestCaseType().getAllTestParameter();
                    int n = allTestParameter.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITestParameter element = iTestParameterArray[n2];
                        ITestParameter iTestParameter = element;
                        if (iTestParameter instanceof ITestPolicyCmptTypeParameter) {
                            void tPCTP;
                            ITestPolicyCmptTypeParameter cfr_ignored_0 = (ITestPolicyCmptTypeParameter)iTestParameter;
                            ITestPolicyCmptTypeParameter cfr_ignored_1 = (ITestPolicyCmptTypeParameter)iTestParameter;
                            boolean isTestObject = this.isRoot();
                            if (!isTestObject) {
                                IPolicyCmptTypeAssociation association2 = tPCTP.findAssociation(ipsProject);
                                boolean bl = isTestObject = association2 == null || !association2.isAssoziation();
                            }
                            if (isTestObject && tPCTP.getPolicyCmptType().equals(associationFound.getTarget()) && (tPCTP.getTestParameterType().equals((Object)this.getTestParameterType()) || tPCTP.isCombinedParameter())) {
                                targetOfAssoziationInTestCaseType = tPCTP;
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (targetOfAssoziationInTestCaseType == null) {
                        String text3 = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationWarning_AccosiationTargetNotInTestCaseType, this.policyCmptType, this.association);
                        Message msg3 = new Message("TESTPOLICYCMPTTYPEPARAMETER-TargetOfAssociationNotExistsInTestcasetype", text3, Message.WARNING, (Object)this, new String[]{"policyCmptType"});
                        list.add(msg3);
                    }
                }
            }
        }
        if (this.isRoot() && policyCmptTypeFound != null && !this.isRequiresProductCmpt() && policyCmptTypeFound.isAbstract()) {
            text2 = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_MustRequireProdCmptIfRootAndAbstract, this.policyCmptType);
            msg2 = new Message("TESTPOLICYCMPTTYPEPARAMETER-MustRequireProdIfRootAndAbstract", text2, Message.ERROR, (Object)this, new String[]{"requiresProductCmpt"});
            list.add(msg2);
        }
        if (policyCmptTypeFound != null && this.requiresProductCmpt && !policyCmptTypeFound.isConfigurableByProductCmptType()) {
            text2 = MessageFormat.format(Messages.TestPolicyCmptTypeParameter_ValidationError_FlagRequiresIsTrueButPolicyCmptTypeIsNotConfByProduct, this.policyCmptType);
            msg2 = new Message("TESTPOLICYCMPTTYPEPARAMETER-RequiresProdButPolicyCmptTypeIsNotConfByProd", text2, Message.ERROR, (Object)this, new String[]{"requiresProductCmpt"});
            list.add(msg2);
        }
    }
}

