/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.testcasetype;

import java.text.MessageFormat;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.testcasetype.Messages;
import org.faktorips.devtools.model.internal.testcasetype.TestParameter;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.testcasetype.ITestParameter;
import org.faktorips.devtools.model.testcasetype.ITestValueParameter;
import org.faktorips.devtools.model.testcasetype.TestParameterType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestValueParameter
extends TestParameter
implements ITestValueParameter {
    static final String TAG_NAME = "ValueParameter";
    private String datatype = "";

    public TestValueParameter(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    public String getDatatype() {
        return this.getValueDatatype();
    }

    @Override
    public void setDatatype(String datatype) {
        this.setValueDatatype(datatype);
    }

    @Override
    public void setTestParameterType(TestParameterType testParameterType) {
        ArgumentCheck.isTrue((testParameterType.equals((Object)TestParameterType.INPUT) || testParameterType.equals((Object)TestParameterType.EXPECTED_RESULT) ? 1 : 0) != 0);
        TestParameterType oldType = this.type;
        this.type = testParameterType;
        this.valueChanged((Object)oldType, (Object)testParameterType);
    }

    @Override
    public String getValueDatatype() {
        return this.datatype;
    }

    @Override
    public void setValueDatatype(String datatypeId) {
        String oldDatatype = this.datatype;
        this.datatype = datatypeId;
        this.valueChanged(oldDatatype, datatypeId);
    }

    @Override
    public ValueDatatype findValueDatatype(IIpsProject ipsProject) {
        return ipsProject.findValueDatatype(this.datatype);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.datatype = element.getAttribute("valueDatatype");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("valueDatatype", this.datatype);
    }

    @Override
    public ITestParameter getRootParameter() {
        return this;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        Message msg;
        String text;
        super.validateThis(list, ipsProject);
        ValueDatatype datatype = this.findValueDatatype(ipsProject);
        if (datatype == null) {
            text = MessageFormat.format(Messages.TestValueParameter_ValidateError_ValueDatatypeNotFound, this.getDatatype());
            msg = new Message("TESTVALUEPARAMETER-ValueDatatypeNotFound", text, Message.ERROR, (Object)this, new String[]{"valueDatatype"});
            list.add(msg);
        }
        if (this.isCombinedParameter() || !this.isInputOrCombinedParameter() && !this.isExpextedResultOrCombinedParameter()) {
            text = MessageFormat.format(Messages.TestValueParameter_ValidationError_TypeNotAllowed, new Object[]{this.type, this.name});
            msg = new Message("TESTVALUEPARAMETER-WrongType", text, Message.ERROR, (Object)this, new String[]{"testParameterType"});
            list.add(msg);
        }
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return new IIpsElement[0];
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }
}

