/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.HierarchyVisitor;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.internal.type.TypePart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpttype.AggregationKind;
import org.faktorips.devtools.model.type.AssociationType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.QNameUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Association
extends TypePart
implements IAssociation {
    public static final String TAG_NAME = "Association";
    private AssociationType type = IAssociation.DEFAULT_RELATION_TYPE;
    private String target = "";
    private String targetRoleSingular = "";
    private String targetRolePlural = "";
    private int minCardinality = 0;
    private int maxCardinality = Integer.MAX_VALUE;
    private String subsettedDerivedUnion = "";
    private boolean derivedUnion = false;
    private boolean constrain = false;

    protected Association(IType parent, String id) {
        super(parent, id);
    }

    @Override
    public abstract IAssociation findMatchingAssociation();

    @Override
    public AggregationKind getAggregationKind() {
        return this.getAssociationType().getAggregationKind();
    }

    @Override
    public AssociationType getAssociationType() {
        return this.type;
    }

    protected void setAssociationTypeInternal(AssociationType newType) {
        this.type = newType;
    }

    @Override
    public void setAssociationType(AssociationType newType) {
        ArgumentCheck.notNull((Object)((Object)newType));
        AssociationType oldType = this.type;
        this.setAssociationTypeInternal(newType);
        this.valueChanged((Object)oldType, (Object)newType);
    }

    @Override
    public boolean isAssoziation() {
        return this.type.isAssoziation();
    }

    @Override
    public String getName() {
        return this.targetRoleSingular;
    }

    @Override
    public boolean isDerived() {
        return this.isDerivedUnion();
    }

    @Override
    public boolean isDerivedUnion() {
        return this.derivedUnion;
    }

    protected void setDerivedUnionInternal(boolean flag) {
        this.derivedUnion = flag;
    }

    @Override
    public void setDerivedUnion(boolean flag) {
        boolean oldValue = this.derivedUnion;
        this.setDerivedUnionInternal(flag);
        this.valueChanged(oldValue, this.derivedUnion);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(String newTarget) {
        String oldTarget = this.target;
        this.target = newTarget;
        this.valueChanged(oldTarget, newTarget);
    }

    @Override
    public IType findTarget(IIpsProject ipsProject) {
        return (IType)ipsProject.findIpsObject(this.getIpsObject().getIpsObjectType(), this.target);
    }

    @Override
    public String getTargetRoleSingular() {
        return this.targetRoleSingular;
    }

    @Override
    public String getDefaultTargetRoleSingular() {
        return StringUtils.capitalize((String)QNameUtil.getUnqualifiedName(this.target));
    }

    @Override
    public void setTargetRoleSingular(String newRole) {
        String oldRole = this.targetRoleSingular;
        this.targetRoleSingular = newRole;
        this.valueChanged(oldRole, newRole);
    }

    @Override
    public String getTargetRolePlural() {
        return this.targetRolePlural;
    }

    @Override
    public String getDefaultTargetRolePlural() {
        return this.targetRoleSingular;
    }

    @Override
    public void setTargetRolePlural(String newRole) {
        String oldRole = this.targetRolePlural;
        this.targetRolePlural = newRole;
        this.valueChanged(oldRole, newRole);
    }

    @Override
    public boolean isTargetRolePluralRequired() {
        return this.is1ToMany() || this.getIpsProject().getIpsArtefactBuilderSet().isRoleNamePluralRequiredForTo1Relations();
    }

    @Override
    public int getMinCardinality() {
        return this.minCardinality;
    }

    protected void setMinCardinalityInternal(int newValue) {
        this.minCardinality = newValue;
    }

    @Override
    public void setMinCardinality(int newValue) {
        int oldValue = this.minCardinality;
        this.setMinCardinalityInternal(newValue);
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    @Override
    public boolean is1ToMany() {
        return this.isQualified() || this.maxCardinality > 1;
    }

    @Override
    public boolean is1ToManyIgnoringQualifier() {
        return this.maxCardinality > 1;
    }

    @Override
    public boolean is1To1() {
        return this.maxCardinality == 1 && !this.isQualified();
    }

    public void setMaxCardinalityInternal(int newValue) {
        this.maxCardinality = newValue;
    }

    @Override
    public void setMaxCardinality(int newValue) {
        int oldValue = this.maxCardinality;
        this.setMaxCardinalityInternal(newValue);
        this.valueChanged(oldValue, newValue);
    }

    protected void setSubsettedDerivedUnionInternal(String newRelation) {
        this.subsettedDerivedUnion = newRelation;
    }

    @Override
    public void setSubsettedDerivedUnion(String newRelation) {
        String oldValue = this.subsettedDerivedUnion;
        this.setSubsettedDerivedUnionInternal(newRelation);
        this.valueChanged(oldValue, newRelation);
    }

    @Override
    public String getSubsettedDerivedUnion() {
        return this.subsettedDerivedUnion;
    }

    @Override
    public boolean isSubsetOfADerivedUnion() {
        return IpsStringUtils.isNotEmpty((String)this.subsettedDerivedUnion);
    }

    @Override
    public boolean isConstrain() {
        return this.constrain;
    }

    @Override
    public void setConstrain(boolean constrain) {
        boolean oldValue = this.constrain;
        this.constrain = constrain;
        this.valueChanged(oldValue, constrain);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + Objects.hash(new Object[]{this.constrain, this.derivedUnion, this.maxCardinality, this.minCardinality, this.subsettedDerivedUnion, this.target, this.targetRolePlural, this.targetRoleSingular, this.type});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Association other = (Association)obj;
        return this.constrain == other.constrain && this.derivedUnion == other.derivedUnion && this.maxCardinality == other.maxCardinality && this.minCardinality == other.minCardinality && Objects.equals(this.subsettedDerivedUnion, other.subsettedDerivedUnion) && Objects.equals(this.target, other.target) && Objects.equals(this.targetRolePlural, other.targetRolePlural) && Objects.equals(this.targetRoleSingular, other.targetRoleSingular) && Objects.equals(this.getParent(), other.getParent()) && this.type == other.type;
    }

    @Override
    public IAssociation findSuperAssociationWithSameName(IIpsProject ipsProject) {
        IType supertype = this.getType().findSupertype(ipsProject);
        if (supertype == null) {
            return null;
        }
        return supertype.findAssociation(this.getName(), ipsProject);
    }

    @Override
    public IAssociation findConstrainedAssociation(IIpsProject ipsProject) {
        AssociationHierarchyVisitor visitor = new AssociationHierarchyVisitor(ipsProject){

            @Override
            protected boolean continueVisiting() {
                return this.getLastVisited().isConstrain();
            }
        };
        visitor.start(this);
        return visitor.getSuperAssociation();
    }

    @Override
    public IAssociation findSubsettedDerivedUnion(IIpsProject project) {
        return this.getType().findAssociation(this.subsettedDerivedUnion, project);
    }

    @Override
    public IAssociation[] findDerivedUnionCandidates(IIpsProject ipsProject) {
        IType targetType = this.findTarget(ipsProject);
        if (targetType == null) {
            return new IAssociation[0];
        }
        DerivedUnionCandidatesFinder finder = new DerivedUnionCandidatesFinder(targetType, ipsProject);
        finder.start(this.getType());
        return finder.candidates.toArray(new IAssociation[finder.candidates.size()]);
    }

    @Override
    public boolean isSubsetOfDerivedUnion(IAssociation derivedUnion, IIpsProject project) {
        if (!this.isSubsetOfADerivedUnion()) {
            return false;
        }
        return derivedUnion.equals(this.findSubsettedDerivedUnion(project));
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.type = AssociationType.getRelationType(element.getAttribute("associationType"));
        if (this.type == null) {
            this.type = IAssociation.DEFAULT_RELATION_TYPE;
        }
        this.target = element.getAttribute("target");
        this.targetRoleSingular = element.getAttribute("targetRoleSingular");
        this.targetRolePlural = XmlUtil.getAttributeOrEmptyString(element, "targetRolePlural");
        try {
            this.minCardinality = Integer.parseInt(element.getAttribute("minCardinality"));
        }
        catch (NumberFormatException e) {
            this.minCardinality = 0;
        }
        String max = element.getAttribute("maxCardinality");
        if ("*".equals(max)) {
            this.maxCardinality = Integer.MAX_VALUE;
        } else {
            try {
                this.maxCardinality = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                this.maxCardinality = 0;
            }
        }
        this.derivedUnion = XmlUtil.getBooleanAttributeOrFalse(element, "derivedUnion");
        this.subsettedDerivedUnion = XmlUtil.getAttributeOrEmptyString(element, "subsettedDerivedUnion");
        this.constrain = XmlUtil.getBooleanAttributeOrFalse(element, "constrain");
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        newElement.setAttribute("associationType", this.type.getId());
        newElement.setAttribute("target", this.target);
        newElement.setAttribute("targetRoleSingular", this.targetRoleSingular);
        if (IpsStringUtils.isNotEmpty((String)this.targetRolePlural)) {
            newElement.setAttribute("targetRolePlural", this.targetRolePlural);
        }
        newElement.setAttribute("minCardinality", "" + this.minCardinality);
        if (this.maxCardinality == Integer.MAX_VALUE) {
            newElement.setAttribute("maxCardinality", "*");
        } else {
            newElement.setAttribute("maxCardinality", "" + this.maxCardinality);
        }
        if (this.derivedUnion) {
            newElement.setAttribute("derivedUnion", "" + this.derivedUnion);
        }
        if (IpsStringUtils.isNotEmpty((String)this.subsettedDerivedUnion)) {
            newElement.setAttribute("subsettedDerivedUnion", this.subsettedDerivedUnion);
        }
        if (this.isConstrain()) {
            newElement.setAttribute("constrain", String.valueOf(this.isConstrain()));
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        this.validateTarget(list);
        this.validateTargetRoleSingular(list, ipsProject);
        this.validateTargetRolePlural(list, ipsProject);
        this.validateMaxCardinality(list);
        this.validateMinCardinality(list);
        this.validateDerivedUnion(list, ipsProject);
        this.validateConstrain(list, ipsProject);
    }

    private void validateTarget(MessageList list) {
        ValidationUtils.checkIpsObjectReference(this.target, this.getIpsObject().getIpsObjectType(), "target", this, "target", "Association-TargetDoesNotExists", list);
    }

    private void validateTargetRoleSingular(MessageList list, IIpsProject ipsProject) {
        ValidationUtils.checkStringPropertyNotEmpty(this.targetRoleSingular, Messages.Association_msg_TargetRoleSingular, this, "targetRoleSingular", "Association-TargetRoleSingularMustBeSet", list);
        if (!ValidationUtils.validateFieldName(this.targetRoleSingular, ipsProject)) {
            String text = MessageFormat.format(Messages.Association_msg_TargetRoleSingularNotAValidJavaFieldName, this.targetRoleSingular);
            list.newError("Association-TargetRoleSingularNotAValidJavaFieldName", text, (Object)this, new String[]{"targetRoleSingular"});
        }
    }

    private void validateTargetRolePlural(MessageList list, IIpsProject ipsProject) {
        if (IpsStringUtils.isNotEmpty((String)this.targetRolePlural) && !ValidationUtils.validateFieldName(this.targetRolePlural, ipsProject)) {
            String text = MessageFormat.format(Messages.Association_msg_TargetRolePluralNotAValidJavaFieldName, this.targetRolePlural);
            list.newError("Association-TargetRolePluralNotAValidJavaFieldName", text, (Object)this, new String[]{"targetRolePlural"});
        }
        if (this.is1ToMany() || this.getIpsProject().getIpsArtefactBuilderSet().isRoleNamePluralRequiredForTo1Relations()) {
            ValidationUtils.checkStringPropertyNotEmpty(this.targetRolePlural, Messages.Association_msg_TargetRolePlural, this, "targetRolePlural", "Association-TargetRolePluralMustBeSet", list);
        }
    }

    private void validateMaxCardinality(MessageList list) {
        if (this.maxCardinality == 0) {
            String text = Messages.Association_msg_MaxCardinalityMustBeAtLeast1;
            list.add(new Message("Association-MaxCardinalityMustBeAtLeast1", text, Message.ERROR, (Object)this, new String[]{"maxCardinality"}));
        } else if (this.is1To1() && this.isDerivedUnion() && this.getAssociationType() != AssociationType.COMPOSITION_DETAIL_TO_MASTER) {
            String text = Messages.Association_msg_MaxCardinalityForDerivedUnionTooLow;
            list.add(new Message("Association-MaxCardinalityForContainerRelationTooLow", text, Message.ERROR, (Object)this, new String[]{"derivedUnion", "maxCardinality"}));
        }
    }

    private void validateMinCardinality(MessageList list) {
        if (this.minCardinality > this.maxCardinality) {
            String text = Messages.Association_msg_MinCardinalityGreaterThanMaxCardinality;
            list.add(new Message("Association-MaxIsLessThanMin", text, Message.ERROR, (Object)this, new String[]{"minCardinality", "maxCardinality"}));
        }
    }

    private void validateDerivedUnion(MessageList list, IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.subsettedDerivedUnion)) {
            return;
        }
        if (this.subsettedDerivedUnion.equals(this.getName())) {
            list.add(new Message("Association-DerivedUnionSubsetNotSameAsDerivedUnion", Messages.Association_msgDerivedUnionNotSubset, Message.ERROR, (Object)this, new String[]{"subsettedDerivedUnion"}));
            return;
        }
        IAssociation unionAss = this.findSubsettedDerivedUnion(ipsProject);
        if (unionAss == null) {
            String text = MessageFormat.format(Messages.Association_msg_DerivedUnionDoesNotExist, this.subsettedDerivedUnion);
            list.add(new Message("Association-DerivedUnionNotFound", text, Message.ERROR, (Object)this, new String[]{"subsettedDerivedUnion"}));
            return;
        }
        if (!unionAss.isDerivedUnion()) {
            String text = Messages.Association_msg_NotMarkedAsDerivedUnion;
            list.add(new Message("Association-NotMarkedAsDerivedUnion", text, Message.ERROR, (Object)this, new String[]{"subsettedDerivedUnion"}));
            return;
        }
        if (unionAss.isQualified() && this.isQualified() && unionAss.getMaxCardinality() < this.getMaxCardinality()) {
            list.add(new Message("Association-SubsetOfDerivedUnionSameMaxCardinality", Messages.Association_msgSubsetOfDerivedUnionSameMaxCardinality, Message.ERROR, (Object)this, new String[]{"maxCardinality"}));
        }
        this.validateDerivedUnionsTarget(list, ipsProject, unionAss);
    }

    private void validateDerivedUnionsTarget(MessageList list, IIpsProject ipsProject, IAssociation unionAss) {
        IType unionTarget = unionAss.findTarget(ipsProject);
        if (unionTarget == null) {
            String text = Messages.Association_msg_TargetOfDerivedUnionDoesNotExist;
            list.add(new Message("Association-ContainerRelationTargetDoesNotExist", text, Message.WARNING, (Object)this, new String[]{"subsettedDerivedUnion"}));
            return;
        }
        IType targetType = this.findTarget(ipsProject);
        if (targetType != null && !targetType.isSubtypeOrSameType(unionTarget, ipsProject)) {
            String text = Messages.Association_msg_TargetNotSubclass;
            list.add(new Message("PolicyCmptTypeRelation-TargetTypeNotASubtype", text, Message.ERROR, (Object)this, new String[]{"subsettedDerivedUnion"}));
        }
    }

    private void validateConstrain(MessageList list, IIpsProject ipsProject) {
        if (this.isConstrain()) {
            IAssociation constrainedAssociation = this.findConstrainedAssociation(ipsProject);
            if (constrainedAssociation == null) {
                String text = MessageFormat.format(Messages.Association_msg_ConstrainedAssociationSingularDoesNotExist, this.getName());
                list.newError("Association-ConstrainedwithSingularNotFound", text, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "targetRoleSingular")});
            } else {
                IAssociation parentAssociation = this.findSuperAssociationWithSameName(ipsProject);
                this.validateConstrainedAssociation(list, constrainedAssociation, parentAssociation);
            }
        }
    }

    private void validateConstrainedAssociation(MessageList list, IAssociation constrainedAssociation, IAssociation parentAssociation) {
        String text;
        if (!this.isCovariantTargetType(constrainedAssociation)) {
            text = MessageFormat.format(Messages.Association_msg_ConstrainedTargetNoSuperclass, this.getName());
            list.newError("Association-ConstrainedwithTargetSupertypeNotConvenient", text, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "target")});
        }
        if (!constrainedAssociation.getTargetRolePlural().equals(this.getTargetRolePlural())) {
            text = MessageFormat.format(Messages.Association_msg_ConstrainedAssociationPluralDoesNotExist, constrainedAssociation.getTargetRolePlural());
            list.newError("Association-ConstrainedwithPluralNotFound", text, (Object)this, new String[]{"targetRolePlural"});
        }
        this.validateConstrainedAssociationType(list, constrainedAssociation);
        this.validateConstrainedCardinality(list, parentAssociation);
        this.validateConstrainingNotDerivedUnion(list);
        this.validateConstrainedAssociationNotDerivedUnion(list, constrainedAssociation);
        this.validateConstrainedIsMatchingAssociationParallel(list, constrainedAssociation);
    }

    private void validateConstrainedIsMatchingAssociationParallel(MessageList list, IAssociation constrainedAssociation) {
        if (!this.isMatchingAssociationParallel(constrainedAssociation)) {
            String text = Messages.Association_msg_ConstrainedInvalidMatchingAssociation;
            list.newError("Association-ConstrainInvalidMatchingAssociation", text, (Object)this, new String[]{"constrain"});
        }
    }

    private boolean isMatchingAssociationParallel(IAssociation constrainedAssociation) {
        IAssociation constrainedMatchingAssociation;
        IAssociation matchingAssociation = this.findMatchingAssociation();
        if (this.isNoMatchingAssociationsDefined(matchingAssociation, constrainedMatchingAssociation = constrainedAssociation.findMatchingAssociation())) {
            return true;
        }
        if (matchingAssociation != null && constrainedMatchingAssociation != null) {
            if (matchingAssociation.equals(constrainedMatchingAssociation)) {
                return true;
            }
            IAssociation matchingConstrainedAssociation = matchingAssociation.findConstrainedAssociation(this.getIpsProject());
            return constrainedMatchingAssociation.equals(matchingConstrainedAssociation);
        }
        return false;
    }

    private boolean isNoMatchingAssociationsDefined(IAssociation matchingAssociation, IAssociation constrainedMatchingAssociation) {
        return matchingAssociation == null && constrainedMatchingAssociation == null;
    }

    private void validateConstrainedAssociationType(MessageList list, IAssociation superAssociation) {
        if (!this.isSameAssociationTypeAs(superAssociation)) {
            String text = MessageFormat.format(Messages.Association_msg_AssociationTypeNotEqualToSuperAssociation, superAssociation.getAssociationType().getName());
            list.newError("Association-AssociationTypeNotEqualSuperAssociation", text, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "associationType")});
        }
    }

    private boolean isSameAssociationTypeAs(IAssociation otherAssociation) {
        return otherAssociation.getAssociationType().equals((Object)this.getAssociationType());
    }

    private void validateConstrainedCardinality(MessageList list, IAssociation superAssociation) {
        String text;
        if (this.getMaxCardinality() == 1 && superAssociation.getMaxCardinality() > 1) {
            text = MessageFormat.format(Messages.Association_msg_MaxCardinalityForConstrainMustAllowMultipleItems, this.getStringCardinality(superAssociation.getMinCardinality()));
            list.newError("Association-MaxCardinalityNotValidConstraintForSuperAssociation", text, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "maxCardinality")});
        }
        if (superAssociation.getMinCardinality() > this.getMinCardinality()) {
            text = MessageFormat.format(Messages.Association_msg_MinCardinalityForConstrainHigherThanSuperAssociation, this.getStringCardinality(superAssociation.getMinCardinality()));
            list.newError("Association-MinCardinalityNotValidConstraintForSuperAssociation", text, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "minCardinality")});
        }
        if (superAssociation.getMaxCardinality() < this.getMaxCardinality()) {
            text = MessageFormat.format(Messages.Association_msg_MaxCardinalityForConstrainLowerThanSuperAssociation, this.getStringCardinality(superAssociation.getMaxCardinality()));
            list.newError("Association-MaxCardinalityNotValidConstraintForSuperAssociation", text, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "maxCardinality")});
        }
    }

    private String getStringCardinality(int cardinality) {
        if (cardinality == Integer.MAX_VALUE) {
            return "*";
        }
        return String.valueOf(cardinality);
    }

    private boolean isCovariantTargetType(IAssociation superAssociation) {
        IType targetType = this.findTarget(this.getIpsProject());
        IType superTargetType = superAssociation.findTarget(this.getIpsProject());
        if (targetType != null && superTargetType != null) {
            return targetType.isSubtypeOrSameType(superTargetType, this.getIpsProject());
        }
        return false;
    }

    private void validateConstrainingNotDerivedUnion(MessageList list) {
        if (this.isDerivedUnion()) {
            list.newError("Association-ConstrainDerivedUnion", Messages.Association_msg_ConstraintIsDerivedUnion, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "derivedUnion")});
        }
        if (this.isSubsetOfADerivedUnion()) {
            list.newError("Association-ConstrainSubsetDerivedUnion", Messages.Association_msg_ConstraintIsSubsetOfDerivedUnion, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "subsettedDerivedUnion")});
        }
    }

    private void validateConstrainedAssociationNotDerivedUnion(MessageList list, IAssociation superAssociation) {
        if (superAssociation.isDerivedUnion()) {
            list.newError("Association-ConstraintedDerivedUnion", Messages.Association_msg_ConstrainedIsDerivedUnion, (Object)this, new String[]{"constrain"});
        }
        if (superAssociation.isSubsetOfADerivedUnion()) {
            list.newError("Association-ConstraintedSubsetDerivedUnion", Messages.Association_msg_ConstrainedIsSubsetOfDerivedUnion, (Object)this, new String[]{"constrain"});
        }
    }

    @Override
    public boolean isPluralLabelSupported() {
        return true;
    }

    protected static abstract class AssociationHierarchyVisitor
    extends HierarchyVisitor<IAssociation> {
        protected AssociationHierarchyVisitor(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected IAssociation findSupertype(IAssociation currentType, IIpsProject ipsProject) {
            return currentType.findSuperAssociationWithSameName(ipsProject);
        }

        @Override
        protected boolean visit(IAssociation currentType) {
            return this.continueVisiting();
        }

        protected abstract boolean continueVisiting();

        public IAssociation getSuperAssociation() {
            if (this.getVisited().size() > 1) {
                return this.getLastVisited();
            }
            return null;
        }

        public IAssociation getLastVisited() {
            return (IAssociation)this.getVisited().get(this.getVisited().size() - 1);
        }
    }

    private class DerivedUnionCandidatesFinder
    extends TypeHierarchyVisitor<IType> {
        private List<IAssociation> candidates;
        private IType targetType;

        public DerivedUnionCandidatesFinder(IType targetType, IIpsProject ipsProject) {
            super(ipsProject);
            this.candidates = new ArrayList<IAssociation>();
            this.targetType = targetType;
        }

        @Override
        protected boolean visit(IType currentType) {
            List<IAssociation> associations = currentType.getAssociations();
            for (IAssociation association : associations) {
                IType derivedUnionTarget;
                if (!association.isDerivedUnion() || association.equals(Association.this) || (derivedUnionTarget = association.findTarget(this.getIpsProject())) == null || !this.targetType.isSubtypeOrSameType(derivedUnionTarget, this.getIpsProject())) continue;
                this.candidates.add(association);
            }
            return true;
        }
    }
}

