/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import java.text.MessageFormat;
import java.util.EnumSet;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ValueSetNullIncompatibleValidator;
import org.faktorips.devtools.model.internal.type.AttributeAbstractDatatypeValidator;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.internal.type.TypePart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.type.AttributeProperty;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Attribute
extends TypePart
implements IAttribute {
    static final String TAG_NAME = "Attribute";
    private String datatype = "";
    private String defaultValue = null;
    private boolean overwrites;
    private final EnumSet<AttributeProperty> properties = EnumSet.noneOf(AttributeProperty.class);

    public Attribute(IType parent, String id) {
        super(parent, id);
        this.name = "";
        this.initPropertyDefaultChangingOverTime();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.valueChanged(oldName, newName);
    }

    @Override
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(String newDatatype) {
        String oldDatatype = this.datatype;
        this.datatype = newDatatype;
        this.valueChanged(oldDatatype, newDatatype);
    }

    @Override
    public ValueDatatype findDatatype(IIpsProject project) {
        return project.findValueDatatype(this.datatype);
    }

    public ValueDatatype findValueDatatype(IIpsProject project) {
        return project.findValueDatatype(this.datatype);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String newValue) {
        String oldValue = this.defaultValue;
        this.defaultValue = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrites;
    }

    @Override
    public void setOverwrite(boolean overwrites) {
        boolean old = this.overwrites;
        this.overwrites = overwrites;
        this.valueChanged(old, overwrites, "overwrite");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.initPropertyDefaultChangingOverTime();
        if (element.hasAttribute("changingOverTime")) {
            String changingOverTimeAttribute = element.getAttribute("changingOverTime");
            this.setProperty(AttributeProperty.CHANGING_OVER_TIME, Boolean.parseBoolean(changingOverTimeAttribute));
        }
        this.name = element.getAttribute("name");
        this.datatype = element.getAttribute("datatype");
        this.defaultValue = ValueToXmlHelper.getValueFromElement((Element)element, (String)"DefaultValue");
        this.overwrites = XmlUtil.getBooleanAttributeOrFalse(element, "overwrite");
    }

    protected abstract void initPropertyDefaultChangingOverTime();

    protected void setProperty(AttributeProperty property, boolean state) {
        if (state) {
            this.properties.add(property);
        } else {
            this.properties.remove((Object)property);
        }
    }

    protected boolean isPropertySet(AttributeProperty property) {
        return this.properties.contains((Object)property);
    }

    @Override
    public boolean isChangingOverTime() {
        return this.isPropertySet(AttributeProperty.CHANGING_OVER_TIME);
    }

    @Override
    public void setChangingOverTime(boolean changesOverTime) {
        boolean oldValue = this.isPropertySet(AttributeProperty.CHANGING_OVER_TIME);
        this.setProperty(AttributeProperty.CHANGING_OVER_TIME, changesOverTime);
        this.valueChanged(oldValue, changesOverTime);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("changingOverTime", String.valueOf(this.isChangingOverTime()));
        element.setAttribute("name", this.name);
        element.setAttribute("datatype", this.datatype);
        ValueToXmlHelper.addValueToElement((String)this.defaultValue, (Element)element, (String)"DefaultValue");
        if (this.overwrites) {
            element.setAttribute("overwrite", "" + this.overwrites);
        }
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        ValueDatatype datatypeObject;
        super.validateThis(result, ipsProject);
        if (!ValidationUtils.validateFieldName(this.name, ipsProject)) {
            String invalidName = IpsStringUtils.isNotEmpty((String)this.name) ? " " + this.name : "";
            result.add(new Message("ATTRIBUTE-InvalidAttributeName", MessageFormat.format(Messages.Attribute_msg_InvalidAttributeName, invalidName), Message.ERROR, (Object)this, new String[]{"name"}));
        }
        if ((datatypeObject = ValidationUtils.checkValueDatatypeReference(this.getDatatype(), false, this, "datatype", "", result)) != null) {
            this.validateDefaultValue(datatypeObject, result, ipsProject);
        } else if (!IpsStringUtils.isEmpty((String)this.defaultValue)) {
            String text = MessageFormat.format(Messages.Attribute_msg_DefaultNotParsable_UnknownDatatype, this.defaultValue);
            result.add(new Message("ATTRIBUTE-DefaultNotParsableUnknownDatatype", text, Message.WARNING, (Object)this, new String[]{"defaultValue"}));
        }
        this.validateOverwritingAttribute(result, ipsProject);
        this.validateAbstractDatatype(result, ipsProject);
    }

    private void validateOverwritingAttribute(MessageList result, IIpsProject ipsProject) {
        if (this.overwrites) {
            IAttribute superAttr = this.findOverwrittenAttribute(ipsProject);
            if (superAttr == null) {
                String text = MessageFormat.format(Messages.Attribute_msgNothingToOverwrite, this.getName());
                result.add(new Message("ATTRIBUTE-NothingToOverwrite", text, Message.ERROR, (Object)this, new String[]{"overwrite", "name"}));
            } else {
                this.validateAgainstOverwrittenAttribute(result, superAttr);
            }
        }
    }

    private void validateAgainstOverwrittenAttribute(MessageList result, IAttribute superAttr) {
        this.validateOverwrittenDatatype(superAttr, result);
        if (!this.getValueSet().isDetailedSpecificationOf(superAttr.getValueSet())) {
            String text = MessageFormat.format(Messages.Attribute_ValueSet_not_SubValueSet_of_the_overridden_attribute, String.valueOf(this.getParent().getName()) + '.' + this.getName(), String.valueOf(superAttr.getParent().getName()) + '.' + superAttr.getName());
            String code = "ATTRIBUTE-OverwrittenAttributeModifier";
            result.newError(code, text, (Object)this.getValueSet(), new String[]{"values"});
        }
        this.validateNullIncompatible(result, superAttr.getValueSet());
        if (this.isChangingOverTimeValidationNecessary() && ((Attribute)superAttr).isChangingOverTimeValidationNecessary() && this.hasSuperAttributeDifferentChangingOverTime(superAttr)) {
            result.add(new Message("ATTRIBUTE-OverwrittenAttributeDifferentChangeOverTime", Messages.Attribute_msgOverwritten_ChangingOverTimeAttribute_different, Message.ERROR, (Object)this, new String[]{"changingOverTime"}));
        }
        if (!this.getModifier().equals((Object)superAttr.getModifier())) {
            result.add(new Message("ATTRIBUTE-OverwrittenAttributeDifferentModifier", Messages.Attribute_msg_Overwritten_modifier_different, Message.ERROR, (Object)this, new String[]{"modifier"}));
        }
    }

    protected abstract boolean isChangingOverTimeValidationNecessary();

    private boolean hasSuperAttributeDifferentChangingOverTime(IAttribute superAttr) {
        return this.isChangingOverTime() ^ superAttr.isChangingOverTime();
    }

    protected void validateOverwrittenDatatype(IAttribute superAttr, MessageList result) {
        if (!DatatypeUtil.isCovariant(this.findDatatype(this.getIpsProject()), superAttr.findDatatype(this.getIpsProject()))) {
            result.add(new Message("ATTRIBUTE-OverwrittenAttributeIncompatibleDatatype", MessageFormat.format(Messages.Attribute_msg_Overwritten_type_incompatible, this.getName()), Message.ERROR, (Object)this, new String[]{"datatype"}));
        }
    }

    protected void validateAbstractDatatype(MessageList result, IIpsProject ipsProject) {
        if (!this.getType().isAbstract()) {
            new AttributeAbstractDatatypeValidator(this, ipsProject).validateNotAbstractDatatype(result);
        }
    }

    private void validateNullIncompatible(MessageList list, IValueSet modelValueSet) {
        new ValueSetNullIncompatibleValidator(modelValueSet, this.getValueSet()).validateAndAppendMessages(list);
    }

    @Override
    public IAttribute findOverwrittenAttribute(IIpsProject ipsProject) {
        IType supertype = ((IType)this.getIpsObject()).findSupertype(ipsProject);
        if (supertype == null) {
            return null;
        }
        IAttribute candidate = supertype.findAttribute(this.name, ipsProject);
        if (candidate == this) {
            return null;
        }
        return candidate;
    }

    protected void validateDefaultValue(ValueDatatype valueDatatype, MessageList result, IIpsProject ipsProject) {
        this.validateDefaultValue(this.defaultValue, valueDatatype, result, ipsProject);
    }

    protected void validateDefaultValue(String defaultValueToValidate, ValueDatatype valueDatatype, MessageList result, IIpsProject ipsProject) {
        if (!this.isValueParsable(defaultValueToValidate, valueDatatype)) {
            this.addMessageDatatypeMissmatch(defaultValueToValidate, result);
        } else if (!this.isValueInValueSet(defaultValueToValidate, ipsProject)) {
            this.addMessageDefaultValueNotInValueSet(defaultValueToValidate, result);
        }
    }

    private boolean isValueParsable(String defaultValueToValidate, ValueDatatype valueDatatype) {
        return valueDatatype.isParsable(defaultValueToValidate);
    }

    private boolean isValueInValueSet(String defaultValueToValidate, IIpsProject ipsProject) {
        IValueSet valueSet = this.getValueSet();
        return valueSet == null || IpsStringUtils.isBlank((String)defaultValueToValidate) || valueSet.containsValue(defaultValueToValidate, ipsProject);
    }

    private void addMessageDatatypeMissmatch(String defaultValueToValidate, MessageList result) {
        String defaultValueInMsg = defaultValueToValidate;
        if (defaultValueToValidate == null) {
            defaultValueInMsg = IIpsModelExtensions.get().getModelPreferences().getNullPresentation();
        } else if (IpsStringUtils.isEmpty((String)defaultValueToValidate)) {
            defaultValueInMsg = Messages.Attribute_msg_DefaultValueIsEmptyString;
        }
        String text = MessageFormat.format(Messages.Attribute_msg_ValueTypeMismatch, defaultValueInMsg, this.getDatatype());
        result.newError("ATTRIBUTE-ValueTypeMissmatch", text, (Object)this, new String[]{"defaultValue"});
    }

    private void addMessageDefaultValueNotInValueSet(String defaultValueToValidate, MessageList result) {
        result.add(new Message("ATTRIBUTE-DefaultNotInValueSet", MessageFormat.format(Messages.Attribute_msg_DefaultNotInValueset, defaultValueToValidate), Message.WARNING, (Object)this, new String[]{"defaultValue"}));
    }
}

