/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import java.text.MessageFormat;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;

public class AttributeAbstractDatatypeValidator {
    private final IType type;
    private final IAttribute attribute;
    private IIpsProject ipsProject;

    public AttributeAbstractDatatypeValidator(IAttribute attribute, IIpsProject ipsProject) {
        this(attribute, attribute.getType(), ipsProject);
    }

    public AttributeAbstractDatatypeValidator(IAttribute attribute, IType type, IIpsProject ipsProject) {
        this.attribute = attribute;
        this.type = type;
        this.ipsProject = ipsProject;
    }

    public void validateNotAbstractDatatype(MessageList list) {
        ValueDatatype datatype = this.attribute.findDatatype(this.ipsProject);
        if (datatype != null && datatype.isAbstract()) {
            ObjectProperty[] invalidObjects;
            String text = MessageFormat.format(Messages.AttributeAbstractDatatypeValidator_msg, this.attribute.getName());
            if (!this.attribute.isOfType(this.getQualifiedNameType())) {
                text = String.valueOf(text) + Messages.AttributeAbstractDatatypeValidator_hint;
                invalidObjects = new ObjectProperty[]{this.getAbstractProperty()};
            } else {
                invalidObjects = new ObjectProperty[]{this.getDatatypeProperty(), this.getAbstractProperty()};
            }
            list.newError("Type-AbstractMissing", text, invalidObjects);
        }
    }

    private ObjectProperty getDatatypeProperty() {
        return new ObjectProperty((Object)this.attribute, "datatype");
    }

    private ObjectProperty getAbstractProperty() {
        return new ObjectProperty((Object)this.type, "abstract");
    }

    private QualifiedNameType getQualifiedNameType() {
        return this.type.getQualifiedNameType();
    }
}

