/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;

public abstract class DuplicatePropertyNameValidator
extends TypeHierarchyVisitor<IType> {
    private Map<String, ObjectProperty[]> properties = new HashMap<String, ObjectProperty[]>();
    private List<String> duplicateProperties = new ArrayList<String>();

    public DuplicatePropertyNameValidator(IIpsProject ipsProject) {
        super(ipsProject);
    }

    public void addMessagesForDuplicates(IType currentType, MessageList messages) {
        for (String propertyName : this.duplicateProperties) {
            ObjectProperty[] duplicateObjProperties = this.properties.get(propertyName);
            if (this.ignore(currentType, duplicateObjProperties)) continue;
            messages.add(this.createMessage(propertyName, duplicateObjProperties));
        }
    }

    protected Message createMessage(String propertyName, ObjectProperty[] invalidObjProperties) {
        String text = this.createNLSBinding(propertyName, invalidObjProperties);
        return new Message("Type-DuplicatePropertyName", text, Message.ERROR, invalidObjProperties);
    }

    private String createNLSBinding(String propertyName, ObjectProperty[] invalidObjProperties) {
        return MessageFormat.format(Messages.DuplicatePropertyNameValidator_msg, propertyName, this.createMoreSpecificErrorText(invalidObjProperties[0], invalidObjProperties[1]));
    }

    protected String createMoreSpecificErrorText(ObjectProperty invalidObjProperty1, ObjectProperty invalidObjProperty2) {
        if (this.isIpsObjectPartContainer(invalidObjProperty1, invalidObjProperty2)) {
            IpsObjectPartContainer ipsObjectContainer1;
            IpsObjectPartContainer ipsObjectContainer2 = (IpsObjectPartContainer)invalidObjProperty2.getObject();
            if (this.isDifferentIpsObject(ipsObjectContainer2, ipsObjectContainer1 = (IpsObjectPartContainer)invalidObjProperty1.getObject())) {
                return this.createTextForDiffITypes(ipsObjectContainer2);
            }
            if (this.isDifferentIpsObjectPartContainer(ipsObjectContainer2, ipsObjectContainer1)) {
                return this.createTextForDiffIpsObjPartContainer(invalidObjProperty1, invalidObjProperty2);
            }
        }
        return "";
    }

    private boolean isDifferentIpsObject(IpsObjectPartContainer ipsObjectContainer2, IpsObjectPartContainer ipsObjectContainer1) {
        return !ipsObjectContainer1.getIpsObject().equals(ipsObjectContainer2.getIpsObject());
    }

    private boolean isDifferentIpsObjectPartContainer(IpsObjectPartContainer ipsObjectContainer2, IpsObjectPartContainer ipsObjectContainer1) {
        return !ipsObjectContainer1.getClass().equals(ipsObjectContainer2.getClass());
    }

    private String createTextForDiffITypes(IpsObjectPartContainer ipsObjectContainer2) {
        return MessageFormat.format(Messages.DuplicatePropertyNameValidator_msg_DifferentElementsAndITypes, this.getObjectKindNameSingular(ipsObjectContainer2), ipsObjectContainer2.getIpsObject().getName());
    }

    private String createTextForDiffIpsObjPartContainer(ObjectProperty invalidObjProperty1, ObjectProperty invalidObjProperty2) {
        return MessageFormat.format(Messages.DuplicatePropertyNameValidator_msg_DifferentElementsSameType, StringUtils.capitalize((String)this.getObjectKindNamePlural(invalidObjProperty1)), this.getObjectKindNamePlural(invalidObjProperty2));
    }

    private boolean isIpsObjectPartContainer(ObjectProperty invalidObjProperty1, ObjectProperty invalidObjProperty2) {
        return invalidObjProperty1.getObject() instanceof IpsObjectPartContainer && invalidObjProperty2.getObject() instanceof IpsObjectPartContainer;
    }

    protected String getObjectKindNamePlural(ObjectProperty invalidObjProperty) {
        IIpsObjectPartContainer objectPartContainer = (IIpsObjectPartContainer)invalidObjProperty.getObject();
        if (objectPartContainer instanceof IAttribute) {
            return Messages.DuplicatePropertyNameValidator_PluralAttribute;
        }
        if (objectPartContainer instanceof IAssociation) {
            return Messages.DuplicatePropertyNameValidator_PluralAssociation;
        }
        if (objectPartContainer instanceof IMethod) {
            return Messages.DuplicatePropertyNameValidator_PluralMethod;
        }
        if (objectPartContainer instanceof IProductCmptType) {
            return Messages.DuplicatePropertyNameValidator_ProductCmptTypeItself;
        }
        return Messages.DuplicatePropertyNameValidator_PluralElement;
    }

    protected String getObjectKindNameSingular(IpsObjectPartContainer objectPartContainer) {
        if (objectPartContainer instanceof IAttribute) {
            return Messages.DuplicatePropertyNameValidator_SingularAttribute;
        }
        if (objectPartContainer instanceof IAssociation) {
            return Messages.DuplicatePropertyNameValidator_SingularAssociation;
        }
        if (objectPartContainer instanceof IMethod) {
            return Messages.DuplicatePropertyNameValidator_SingularMethod;
        }
        return Messages.DuplicatePropertyNameValidator_SingularElement;
    }

    protected boolean ignore(IType currentType, ObjectProperty[] duplicateObjectProperties) {
        if (!this.isOnePropertyInThisType(currentType, duplicateObjectProperties)) {
            return true;
        }
        if (!this.checkAssociationAndType(duplicateObjectProperties)) {
            return false;
        }
        if (this.ignoreConstrainingAssociation(duplicateObjectProperties)) {
            return true;
        }
        return this.ignoreDuplicateDetailToMasterAssociations(duplicateObjectProperties);
    }

    private boolean isOnePropertyInThisType(IType currentType, ObjectProperty[] duplicateObjectProperties) {
        ObjectProperty[] objectPropertyArray = duplicateObjectProperties;
        int n = duplicateObjectProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPartContainer part;
            ObjectProperty objectProperty = objectPropertyArray[n2];
            if (objectProperty.getObject() instanceof IIpsObjectPartContainer && (part = (IIpsObjectPartContainer)objectProperty.getObject()).getIpsObject().equals(currentType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean ignoreConstrainingAssociation(ObjectProperty[] duplicateObjectProperties) {
        return ((IAssociation)duplicateObjectProperties[0].getObject()).isConstrain();
    }

    private boolean checkAssociationAndType(ObjectProperty[] objectProperties) {
        IType typeToValidate = null;
        ObjectProperty[] objectPropertyArray = objectProperties;
        int n = objectProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectProperty property = objectPropertyArray[n2];
            if (!(property.getObject() instanceof IAssociation)) {
                return false;
            }
            IAssociation association = (IAssociation)property.getObject();
            if (typeToValidate == null ? (typeToValidate = association.getType()) == null : typeToValidate.equals(association.getType())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean ignoreDuplicateDetailToMasterAssociations(ObjectProperty[] duplicateObjectProperties) {
        ObjectProperty[] objectPropertyArray = duplicateObjectProperties;
        int n = duplicateObjectProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectProperty objectProperty = objectPropertyArray[n2];
            if (!(objectProperty.getObject() instanceof IPolicyCmptTypeAssociation)) {
                return false;
            }
            IPolicyCmptTypeAssociation association = (IPolicyCmptTypeAssociation)objectProperty.getObject();
            if (!association.getAssociationType().isCompositionDetailToMaster()) {
                return false;
            }
            ++n2;
        }
        return this.checkNotInverseofDerivedUnion(duplicateObjectProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkNotInverseofDerivedUnion(ObjectProperty[] objectProperties) {
        int index = 0;
        boolean foundNotInverseOfDerivedUnion = false;
        ObjectProperty[] objectPropertyArray = objectProperties;
        int n = objectProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectProperty property = objectPropertyArray[n2];
            IPolicyCmptTypeAssociation association = (IPolicyCmptTypeAssociation)property.getObject();
            try {
                IPolicyCmptType target = association.findTargetPolicyCmptType(this.getIpsProject());
                if (target == null) {
                    return false;
                }
                boolean isNotInverseOfDerivedUnion = this.checkNotInverseOfDerivedUnion(association);
                if (isNotInverseOfDerivedUnion && foundNotInverseOfDerivedUnion) {
                    return false;
                }
                foundNotInverseOfDerivedUnion = foundNotInverseOfDerivedUnion || isNotInverseOfDerivedUnion;
                int i = index;
                while (i < objectProperties.length) {
                    IPolicyCmptTypeAssociation nextAssociation = (IPolicyCmptTypeAssociation)objectProperties[i].getObject();
                    IPolicyCmptType nextTarget = nextAssociation.findTargetPolicyCmptType(this.getIpsProject());
                    if (nextTarget == null || !target.isSubtypeOrSameType(nextTarget, this.getIpsProject())) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (IpsException e) {
                IpsLog.log(e);
                return false;
            }
            ++index;
            ++n2;
        }
        return true;
    }

    private boolean checkNotInverseOfDerivedUnion(IPolicyCmptTypeAssociation association) {
        return !association.isInverseOfDerivedUnion() && !association.isSharedAssociation();
    }

    @Override
    protected boolean visit(IType currentType) {
        this.addAttributes(currentType);
        this.addAssociations(currentType);
        this.addMatchingType(currentType);
        return true;
    }

    private void addMatchingType(IType currentType) {
        IType matchingType = this.getMatchingType(currentType);
        if (matchingType != null) {
            this.addMatchingAttributes(matchingType);
        }
    }

    protected abstract IType getMatchingType(IType var1);

    private void addMatchingAttributes(IType matchingType) {
        for (IAttribute attribute : matchingType.getAttributes()) {
            this.add(attribute.getName(), new ObjectProperty((Object)attribute, "name"));
        }
    }

    private void addAttributes(IType currentType) {
        for (IAttribute attr : currentType.getAttributes()) {
            if (attr.isOverwrite()) continue;
            this.add(attr.getName(), new ObjectProperty((Object)attr, "name"));
        }
    }

    private void addAssociations(IType currentType) {
        for (IAssociation ass : currentType.getAssociations()) {
            if (ass.is1ToMany() && !ass.getTargetRoleSingular().equalsIgnoreCase(ass.getTargetRolePlural())) {
                this.add(ass.getTargetRolePlural(), new ObjectProperty((Object)ass, "targetRolePlural"));
            }
            this.add(ass.getTargetRoleSingular(), new ObjectProperty((Object)ass, "targetRoleSingular"));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void add(String originalPropertyName, ObjectProperty wrapper) {
        String propertyName = originalPropertyName.toLowerCase();
        ObjectProperty[] objInMap = this.properties.get(propertyName);
        if (objInMap == null) {
            this.properties.put(propertyName, new ObjectProperty[]{wrapper});
            return;
        }
        ObjectProperty[] objectPropertyArray = objInMap;
        if (objectPropertyArray instanceof ObjectProperty[]) {
            void objects;
            ObjectProperty[] objectPropertyArray2 = objectPropertyArray;
            int i = ((void)objects).length;
            ObjectProperty[] objectsCopy = (ObjectProperty[])Arrays.copyOf(objects, i + 1);
            objectsCopy[i] = wrapper;
            this.properties.put(propertyName, objectsCopy);
            if (i == 1) {
                this.duplicateProperties.add(propertyName);
            }
        }
    }

    protected Map<String, ObjectProperty[]> getProperties() {
        return this.properties;
    }
}

