/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.util.DatatypeComparator;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.DatatypeDependency;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObject;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.internal.method.Method;
import org.faktorips.devtools.model.internal.type.AttributeAbstractDatatypeValidator;
import org.faktorips.devtools.model.internal.type.DuplicatePropertyNameValidator;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.internal.type.TypeHierarchy;
import org.faktorips.devtools.model.internal.type.TypeValidations;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.method.IParameter;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.type.AssociationType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.ITypeHierarchy;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public abstract class Type
extends BaseIpsObject
implements IType {
    private String supertype = "";
    private boolean abstractFlag;

    public Type(IIpsSrcFile file) {
        super(file);
    }

    @Override
    public boolean isAbstract() {
        return this.abstractFlag;
    }

    @Override
    public void setAbstract(boolean newValue) {
        boolean oldValue = this.abstractFlag;
        this.abstractFlag = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public String getSupertype() {
        return this.supertype;
    }

    @Override
    public IType findSupertype(IIpsProject ipsProject) {
        return (IType)ipsProject.findIpsObject(this.getIpsObjectType(), this.supertype);
    }

    @Override
    public boolean hasSupertype() {
        return IpsStringUtils.isNotEmpty((String)this.supertype);
    }

    @Override
    public boolean hasExistingSupertype(IIpsProject ipsProject) {
        return this.findSupertype(ipsProject) != null;
    }

    @Override
    public void setSupertype(String newSupertype) {
        String oldSupertype = this.supertype;
        this.supertype = newSupertype;
        this.valueChanged(oldSupertype, newSupertype);
    }

    @Override
    public boolean isSubtypeOf(IType supertypeCandidate, IIpsProject ipsProject) {
        if (supertypeCandidate == null) {
            return false;
        }
        IType foundSupertype = this.findSupertype(ipsProject);
        if (foundSupertype == null) {
            return false;
        }
        if (supertypeCandidate.equals(foundSupertype)) {
            return true;
        }
        IsSubtypeOfVisitor visitor = new IsSubtypeOfVisitor(ipsProject, supertypeCandidate);
        visitor.start(foundSupertype);
        return visitor.isSubtype();
    }

    @Override
    public boolean isSubtypeOrSameType(IType candidate, IIpsProject project) {
        if (this.equals(candidate)) {
            return true;
        }
        return this.isSubtypeOf(candidate, project);
    }

    protected abstract IpsObjectPartCollection<? extends IAttribute> getAttributesPartCollection();

    protected abstract IpsObjectPartCollection<? extends IAssociation> getAssociationPartCollection();

    protected abstract IpsObjectPartCollection<? extends IMethod> getMethodPartCollection();

    @Override
    public List<IAttribute> getAttributes() {
        return new ArrayList<IAttribute>(this.getAttributesPartCollection().getBackingList());
    }

    @Override
    public IAttribute getAttribute(String name) {
        return this.getAttributesPartCollection().getPartByName(name);
    }

    @Override
    public List<IMethod> findAllMethods(IIpsProject ipsProject) {
        AllMethodsFinder finder = new AllMethodsFinder(ipsProject);
        finder.start(this);
        return finder.getMethodes();
    }

    @Override
    public List<IAttribute> findAllAttributes(IIpsProject ipsProject) {
        AllAttributeFinder finder = new AllAttributeFinder(ipsProject);
        finder.start(this);
        return finder.attributes;
    }

    @Override
    public List<IAssociation> findAllAssociations(IIpsProject ipsProject) {
        AllAssociationFinder finder = new AllAssociationFinder(ipsProject, true);
        finder.start(this);
        return finder.getAssociationsFound();
    }

    @Override
    public IAttribute findAttribute(String name, IIpsProject project) {
        AttributeFinder finder = new AttributeFinder(project, name);
        finder.start(this);
        return finder.attribute;
    }

    @Override
    public IAttribute newAttribute() {
        return this.getAttributesPartCollection().newPart();
    }

    @Override
    public int getNumOfAttributes() {
        return this.getAttributesPartCollection().size();
    }

    @Override
    public int[] moveAttributes(int[] indexes, boolean up) {
        return this.getAttributesPartCollection().moveParts(indexes, up);
    }

    @Override
    public IAssociation findAssociation(String name, IIpsProject project) {
        AssociationFinder finder = new AssociationFinder(project, name);
        finder.start(this);
        return finder.association;
    }

    @Override
    public IAssociation findAssociationByRoleNamePlural(String roleNamePlural, IIpsProject ipsProject) {
        AssociationFinderPlural finder = new AssociationFinderPlural(ipsProject, roleNamePlural);
        finder.start(this);
        return finder.association;
    }

    @Override
    public List<IAssociation> findAssociationsForTargetAndAssociationType(String target, AssociationType associationType, IIpsProject project, boolean includeSupertypes) {
        if (target == null || associationType == null) {
            return new ArrayList<IAssociation>();
        }
        if (includeSupertypes) {
            AssociationTargetAndTypeFinder finder = new AssociationTargetAndTypeFinder(project, target, associationType);
            finder.start(this);
            return finder.getAssociationsFound();
        }
        return this.findAssociationsForTargetAndAssociationTypeInternal(target, associationType, project);
    }

    protected List<IAssociation> findAssociationsForTargetAndAssociationTypeInternal(String target, AssociationType associationType, IIpsProject project) {
        ArrayList<IAssociation> result = new ArrayList<IAssociation>();
        List<IAssociation> associations = this.getAssociationsForTarget(target);
        for (IAssociation association : associations) {
            if (association.getAssociationType() != associationType) continue;
            result.add(association);
        }
        return result;
    }

    @Override
    public IAssociation getAssociation(String name) {
        return this.getAssociationPartCollection().getPartByName(name);
    }

    @Override
    public IAssociation getAssociationByRoleNamePlural(String roleNamePlural) {
        if (roleNamePlural == null) {
            return null;
        }
        for (IAssociation iAssociation : this.getAssociationPartCollection()) {
            if (!roleNamePlural.equals(iAssociation.getTargetRolePlural())) continue;
            return iAssociation;
        }
        return null;
    }

    @Override
    public List<IAssociation> getAssociationsForTarget(String target) {
        ArrayList<IAssociation> result = new ArrayList<IAssociation>();
        for (IAssociation iAssociation : this.getAssociationPartCollection()) {
            if (!iAssociation.getTarget().equals(target)) continue;
            result.add(iAssociation);
        }
        return result;
    }

    @Override
    public List<IAssociation> getAssociations() {
        return new ArrayList<IAssociation>(this.getAssociationPartCollection().getBackingList());
    }

    @Override
    public List<IAssociation> getAssociations(AssociationType ... types) {
        ArrayList<IAssociation> associations = new ArrayList<IAssociation>();
        List<IAssociation> findAssociations = this.getAssociations();
        for (IAssociation association : findAssociations) {
            if (!Arrays.asList(types).contains((Object)association.getAssociationType())) continue;
            associations.add(association);
        }
        return associations;
    }

    @Override
    public int getNumOfAssociations() {
        return this.getAssociationPartCollection().size();
    }

    @Override
    public int[] moveAssociations(int[] indexes, boolean up) {
        return this.getAssociationPartCollection().moveParts(indexes, up);
    }

    @Override
    public IAssociation newAssociation() {
        return this.getAssociationPartCollection().newPart();
    }

    @Override
    public IMethod newMethod() {
        return this.getMethodPartCollection().newPart();
    }

    @Override
    public List<IMethod> getMethods() {
        return new ArrayList<IMethod>(this.getMethodPartCollection().getBackingList());
    }

    @Override
    public IMethod getMethod(String methodName, String[] datatypes) {
        String[] myDatatypes = datatypes;
        if (myDatatypes == null) {
            myDatatypes = new String[]{};
        }
        for (IMethod iMethod : this.getMethodPartCollection()) {
            IParameter[] params;
            if (!iMethod.getName().equals(methodName) || (params = iMethod.getParameters()).length != myDatatypes.length) continue;
            boolean paramsOk = true;
            int i = 0;
            while (i < params.length) {
                if (!params[i].getDatatype().equals(myDatatypes[i])) {
                    paramsOk = false;
                    break;
                }
                ++i;
            }
            if (!paramsOk) continue;
            return iMethod;
        }
        return null;
    }

    @Override
    public IMethod findMethod(String name, String[] datatypes, IIpsProject ipsProject) {
        MethodFinderByNameAndParamtypes finder = new MethodFinderByNameAndParamtypes(ipsProject, name, datatypes);
        finder.start(this);
        return finder.method;
    }

    @Override
    public IMethod getMethod(String signature) {
        for (IMethod iMethod : this.getMethodPartCollection()) {
            if (!iMethod.getSignatureString().equals(signature)) continue;
            return iMethod;
        }
        return null;
    }

    @Override
    public IMethod findMethod(String signature, IIpsProject ipsProject) {
        MethodFinderBySignature finder = new MethodFinderBySignature(ipsProject, signature);
        finder.start(this);
        return finder.method;
    }

    @Override
    public int getNumOfMethods() {
        return this.getMethodPartCollection().size();
    }

    @Override
    public int[] moveMethods(int[] indexes, boolean up) {
        return this.getMethodPartCollection().moveParts(indexes, up);
    }

    @Override
    public List<IMethod> findOverrideMethodCandidates(boolean onlyNotImplementedAbstractMethods, IIpsProject ipsProject) {
        MethodOverrideCandidatesFinder finder = new MethodOverrideCandidatesFinder(ipsProject, onlyNotImplementedAbstractMethods);
        finder.start(this.findSupertype(ipsProject));
        return finder.candidates;
    }

    @Override
    public List<IMethod> overrideMethods(List<IMethod> methods) {
        ArrayList<IMethod> newMethods = new ArrayList<IMethod>(methods.size());
        for (IMethod method : methods) {
            IParameter[] params;
            IMethod override = this.newMethod();
            override.setModifier(method.getModifier());
            override.setAbstract(false);
            override.setDatatype(method.getDatatype());
            override.setName(method.getName());
            IParameter[] iParameterArray = params = method.getParameters();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter param = iParameterArray[n2];
                IParameter newParam = override.newParameter();
                newParam.setName(param.getName());
                newParam.setDatatype(param.getDatatype());
                ++n2;
            }
            newMethods.add(override);
        }
        return newMethods;
    }

    @Override
    public List<IAttribute> findOverrideAttributeCandidates(IIpsProject ipsProject) {
        IType foundSupertype = this.findSupertype(ipsProject);
        if (foundSupertype == null) {
            return new ArrayList<IAttribute>();
        }
        HashMap<String, IAttribute> toExclude = new HashMap<String, IAttribute>();
        for (IAttribute iAttribute : this.getAttributesPartCollection()) {
            if (!iAttribute.isOverwrite()) continue;
            toExclude.put(iAttribute.getName(), iAttribute);
        }
        List<IAttribute> list = this.getSupertypeHierarchy().getAllAttributes(foundSupertype);
        ArrayList<IAttribute> result = new ArrayList<IAttribute>();
        for (IAttribute candidate : list) {
            if (toExclude.containsKey(candidate.getName())) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    public List<IAssociation> findConstrainableAssociationCandidates(IIpsProject ipsProject) {
        ConstrainableAssociationFinder finder = new ConstrainableAssociationFinder(false, ipsProject);
        finder.start(this);
        return finder.getAssociationsFound();
    }

    @Override
    public List<IAttribute> overrideAttributes(List<? extends IAttribute> attributes) {
        ArrayList<IAttribute> newAttributes = new ArrayList<IAttribute>(attributes.size());
        for (IAttribute iAttribute : attributes) {
            IAttribute override = this.createAttributeIfNeccessary(iAttribute);
            override.setOverwrite(true);
            newAttributes.add(override);
        }
        return newAttributes;
    }

    private IAttribute createAttributeIfNeccessary(IAttribute attribute) {
        IAttribute override = this.getAttribute(attribute.getName());
        if (override == null) {
            override = this.newAttribute();
            override.copyFromWithoutLabelAndDescription(attribute);
        }
        return override;
    }

    @Override
    public ITypeHierarchy getSupertypeHierarchy() {
        return TypeHierarchy.getSupertypeHierarchy(this);
    }

    @Override
    public ITypeHierarchy getSubtypeHierarchy() {
        return TypeHierarchy.getSubtypeHierarchy(this);
    }

    @Override
    public boolean hasSameMethod(IMethod method) {
        return this.getMatchingMethod(method) != null;
    }

    @Override
    public IMethod getMatchingMethod(IMethod method) {
        for (IMethod iMethod : this.getMethodPartCollection()) {
            if (!iMethod.isSameSignature(method)) continue;
            return iMethod;
        }
        return null;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.supertype = XmlUtil.getAttributeOrEmptyString(element, "supertype");
        this.abstractFlag = XmlUtil.getBooleanAttributeOrFalse(element, "abstract");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (IpsStringUtils.isNotEmpty((String)this.supertype)) {
            element.setAttribute("supertype", this.supertype);
        }
        if (this.abstractFlag) {
            element.setAttribute("abstract", "" + this.abstractFlag);
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        DuplicatePropertyNameValidator duplicateValidator = this.createDuplicatePropertyNameValidator(ipsProject);
        duplicateValidator.start(this);
        duplicateValidator.addMessagesForDuplicates(this, list);
        if (this.hasSupertype()) {
            list.add(TypeValidations.validateTypeHierachy(this, ipsProject));
        }
        if (!this.isAbstract()) {
            this.validateIfAllAbstractMethodsAreImplemented(this.getIpsProject(), list);
            IIpsProjectProperties props = this.getIpsProject().getReadOnlyProperties();
            if (props.isDerivedUnionIsImplementedRuleEnabled()) {
                DerivedUnionsSpecifiedValidator derivedUnionsSpecifiedValidator = new DerivedUnionsSpecifiedValidator(list, ipsProject);
                derivedUnionsSpecifiedValidator.start(this);
            }
            for (IMethod iMethod : this.getMethodPartCollection()) {
                if (!iMethod.isAbstract()) continue;
                String text = Messages.Type_msg_AbstractMissmatch;
                list.add(new Message("Type-AbstractMissing", text, Message.ERROR, (Object)this, new String[]{"abstract"}));
                break;
            }
        }
        this.validateAbstractAttributes(list, ipsProject);
    }

    public void validateAbstractAttributes(MessageList list, IIpsProject ipsProject) {
        if (!this.isAbstract()) {
            this.findAllAttributes(ipsProject).stream().filter(attribute -> !attribute.isOfType(this.getQualifiedNameType())).filter(a -> {
                void pa;
                IAttribute iAttribute = a;
                if (!(iAttribute instanceof IPolicyCmptTypeAttribute)) return true;
                IPolicyCmptTypeAttribute iPolicyCmptTypeAttribute = (IPolicyCmptTypeAttribute)iAttribute;
                IPolicyCmptTypeAttribute cfr_ignored_0 = (IPolicyCmptTypeAttribute)iAttribute;
                if (pa.isProductRelevant()) return true;
                return false;
            }).forEach(attribute -> new AttributeAbstractDatatypeValidator((IAttribute)attribute, this, ipsProject).validateNotAbstractDatatype(list));
        }
    }

    protected abstract DuplicatePropertyNameValidator createDuplicatePropertyNameValidator(IIpsProject var1);

    private void validateIfAllAbstractMethodsAreImplemented(IIpsProject ipsProject, MessageList list) {
        List<IMethod> methods = this.findOverrideMethodCandidates(true, ipsProject);
        for (IMethod method : methods) {
            String text = MessageFormat.format(Messages.Type_msg_MustOverrideAbstractMethod, method.getName(), method.getType().getQualifiedName());
            list.add(new Message("Type-MustOverrideAbstractMethod", text, Message.ERROR, (Object)this));
        }
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isValueDatatype() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public int compareTo(Datatype o) {
        return DatatypeComparator.doCompare((Datatype)this, (Datatype)o);
    }

    public boolean hasNullObject() {
        return false;
    }

    protected void dependsOn(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        if (this.hasSupertype()) {
            IpsObjectDependency dependency = IpsObjectDependency.createSubtypeDependency(this.getQualifiedNameType(), new QualifiedNameType(this.getSupertype(), this.getIpsObjectType()));
            dependencies.add(dependency);
            this.addDetails(details, dependency, this, "supertype");
        }
        this.addQualifiedNameTypesForRelationTargets(dependencies, details);
        this.addAttributeDatatypeDependencies(dependencies, details);
        this.addMethodDatatypeDependencies(dependencies, details);
    }

    private void addMethodDatatypeDependencies(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        for (IMethod iMethod : this.getMethodPartCollection()) {
            Method method = (Method)iMethod;
            method.dependsOn(dependencies, details);
        }
    }

    private void addAttributeDatatypeDependencies(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        for (IAttribute iAttribute : this.getAttributesPartCollection()) {
            String datatype = iAttribute.getDatatype();
            DatatypeDependency dependency = new DatatypeDependency(this.getQualifiedNameType(), datatype);
            dependencies.add(dependency);
            this.addDetails(details, dependency, iAttribute, "datatype");
        }
    }

    private void addQualifiedNameTypesForRelationTargets(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        for (IAssociation iAssociation : this.getAssociationPartCollection()) {
            IpsObjectDependency dependency;
            String targetQName = iAssociation.getTarget();
            if (iAssociation.getAssociationType().equals((Object)AssociationType.COMPOSITION_MASTER_TO_DETAIL)) {
                dependency = IpsObjectDependency.createCompostionMasterDetailDependency(this.getQualifiedNameType(), new QualifiedNameType(targetQName, this.getIpsObjectType()));
                dependencies.add(dependency);
                this.addDetails(details, dependency, iAssociation, "target");
                continue;
            }
            dependency = IpsObjectDependency.createReferenceDependency(this.getQualifiedNameType(), new QualifiedNameType(targetQName, this.getIpsObjectType()));
            dependencies.add(dependency);
            this.addDetails(details, dependency, iAssociation, "target");
        }
    }

    protected void checkDerivedUnionIsImplemented(IAssociation association, List<IAssociation> candidateSubsets, MessageList msgList) {
        if (association.isDerivedUnion() && !this.isSubsetted(association, candidateSubsets)) {
            String text = MessageFormat.format(Messages.Type_msg_MustImplementDerivedUnion, association.getName(), association.getType().getQualifiedName());
            msgList.add(new Message("Type-MustSpecifyDerivedUnion", text, Message.ERROR, (Object)this, new String[]{"abstract"}));
        }
    }

    private boolean isSubsetted(IAssociation derivedUnion, List<IAssociation> candidateSubsets) {
        for (IAssociation candidate : candidateSubsets) {
            if (derivedUnion != candidate.findSubsettedDerivedUnion(this.getIpsProject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IType> findSubtypes(boolean transitive, boolean includeSelf, IIpsProject project) {
        TypeHierarchy subtypeHierarchy = TypeHierarchy.getSubtypeHierarchy(this, project);
        return this.getSubtypesInternal(transitive, includeSelf, subtypeHierarchy);
    }

    @Override
    public List<IType> searchSubtypes(boolean transitive, boolean includingSelf) {
        TypeHierarchy subtypeHierarchy = TypeHierarchy.getSubtypeHierarchy(this);
        return this.getSubtypesInternal(transitive, includingSelf, subtypeHierarchy);
    }

    private List<IType> getSubtypesInternal(boolean transitive, boolean includingSelf, TypeHierarchy subtypeHierarchy) {
        List<IType> result = transitive ? subtypeHierarchy.getAllSubtypes(this) : subtypeHierarchy.getSubtypes(this);
        if (includingSelf) {
            result.add(this);
        }
        return result;
    }

    @Override
    public IAssociation constrainAssociation(IAssociation associationToConstrain, IType targetType) {
        IAssociation association = this.createAssociationIfNeccessary(associationToConstrain);
        association.setTarget(targetType.getQualifiedName());
        association.setConstrain(true);
        return association;
    }

    private IAssociation createAssociationIfNeccessary(IAssociation associationToConstrain) {
        IAssociation association = this.getAssociation(associationToConstrain.getName());
        if (association == null) {
            association = this.newAssociation();
            association.copyFromWithoutLabelAndDescription(associationToConstrain);
        }
        return association;
    }

    protected static abstract class AbstractAssociationFinder<T extends IAssociation>
    extends TypeHierarchyVisitor<IType> {
        private List<T> associationsFound = new ArrayList<T>();
        private final boolean superTypeFirst;

        public AbstractAssociationFinder(boolean superTypeFirst, IIpsProject ipsProject) {
            super(ipsProject);
            this.superTypeFirst = superTypeFirst;
        }

        @Override
        protected boolean visit(IType currentType) {
            List<T> associations = this.getAssociations(currentType);
            int index = this.superTypeFirst ? 0 : this.associationsFound.size();
            for (IAssociation association : associations) {
                if (!this.isAssociationWanted(association)) continue;
                this.associationsFound.add(index, association);
                ++index;
            }
            return true;
        }

        protected boolean isAssociationWanted(IAssociation association) {
            return !this.isConstrainAlreadyAdded(association);
        }

        protected abstract List<T> getAssociations(IType var1);

        private boolean isConstrainAlreadyAdded(IAssociation association) {
            for (IAssociation alreadyAdded : this.getAssociationsFound()) {
                if (!alreadyAdded.isConstrain() || !alreadyAdded.getName().equals(association.getName())) continue;
                return true;
            }
            return false;
        }

        public List<T> getAssociationsFound() {
            return this.associationsFound;
        }
    }

    private static class AllAssociationFinder
    extends AbstractAssociationFinder<IAssociation> {
        public AllAssociationFinder(IIpsProject ipsProject, boolean superTypeFirst) {
            super(superTypeFirst, ipsProject);
        }

        @Override
        protected List<IAssociation> getAssociations(IType currentType) {
            return currentType.getAssociations();
        }
    }

    private static class AllAttributeFinder
    extends TypeHierarchyVisitor<IType> {
        private List<IAttribute> attributes = new ArrayList<IAttribute>();
        private Set<String> attributeNames = new HashSet<String>();

        public AllAttributeFinder(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IType currentType) {
            List<IAttribute> lattributes = currentType.getAttributes();
            ArrayList<IAttribute> attributesToAdd = new ArrayList<IAttribute>();
            for (IAttribute attribute : lattributes) {
                if (this.attributeNames.contains(attribute.getName())) continue;
                attributesToAdd.add(attribute);
                this.attributeNames.add(attribute.getName());
            }
            this.attributes.addAll(0, attributesToAdd);
            return true;
        }
    }

    private static class AllMethodsFinder
    extends TypeHierarchyVisitor<IType> {
        private List<IMethod> methods = new ArrayList<IMethod>();
        private Set<String> methodSignatures = new HashSet<String>();

        public AllMethodsFinder(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IType currentType) {
            for (IMethod method : currentType.getMethods()) {
                if (this.methodSignatures.contains(method.getSignatureString())) continue;
                this.methods.add(method);
                this.methodSignatures.add(method.getSignatureString());
            }
            return true;
        }

        private List<IMethod> getMethodes() {
            return this.methods;
        }
    }

    private static class AssociationFinder
    extends TypeHierarchyVisitor<IType> {
        private String associationName;
        private IAssociation association = null;

        public AssociationFinder(IIpsProject project, String associationName) {
            super(project);
            this.associationName = associationName;
        }

        @Override
        protected boolean visit(IType currentType) {
            this.association = currentType.getAssociation(this.associationName);
            return this.association == null;
        }
    }

    private static class AssociationFinderPlural
    extends TypeHierarchyVisitor<IType> {
        private String associationName;
        private IAssociation association = null;

        public AssociationFinderPlural(IIpsProject project, String associationName) {
            super(project);
            this.associationName = associationName;
        }

        @Override
        protected boolean visit(IType currentType) {
            this.association = currentType.getAssociationByRoleNamePlural(this.associationName);
            return this.association == null;
        }
    }

    private static class AssociationTargetAndTypeFinder
    extends AbstractAssociationFinder<IAssociation> {
        private String associationTarget;
        private AssociationType associationType;

        public AssociationTargetAndTypeFinder(IIpsProject project, String associationTarget, AssociationType associationType) {
            super(false, project);
            this.associationTarget = associationTarget;
            this.associationType = associationType;
        }

        @Override
        protected List<IAssociation> getAssociations(IType currentType) {
            return ((Type)currentType).findAssociationsForTargetAndAssociationTypeInternal(this.associationTarget, this.associationType, this.getIpsProject());
        }
    }

    private static class AttributeFinder
    extends TypeHierarchyVisitor<IType> {
        private String attributeName;
        private IAttribute attribute;

        public AttributeFinder(IIpsProject ipsProject, String attrName) {
            super(ipsProject);
            this.attributeName = attrName;
        }

        @Override
        protected boolean visit(IType currentType) {
            this.attribute = currentType.getAttribute(this.attributeName);
            return this.attribute == null;
        }
    }

    private static class ConstrainableAssociationFinder
    extends AbstractAssociationFinder<IAssociation> {
        private Set<String> alreadyConstrained = new HashSet<String>();

        public ConstrainableAssociationFinder(boolean superTypeFirst, IIpsProject ipsProject) {
            super(superTypeFirst, ipsProject);
        }

        @Override
        public void start(IType basetype) {
            this.addConstrainingAssociations(basetype.getAssociations());
            super.start(basetype);
        }

        private void addConstrainingAssociations(List<? extends IAssociation> associations) {
            for (IAssociation iAssociation : associations) {
                if (!iAssociation.isConstrain()) continue;
                this.alreadyConstrained.add(iAssociation.getName());
            }
        }

        @Override
        protected boolean isAssociationWanted(IAssociation association) {
            return super.isAssociationWanted(association) && !this.isDerivedUnionOrSubset(association) && !this.isDetailToMaster(association) && !this.isAlreadyConstrained(association);
        }

        private boolean isDerivedUnionOrSubset(IAssociation association) {
            return association.isDerivedUnion() || association.isSubsetOfADerivedUnion();
        }

        private boolean isDetailToMaster(IAssociation association) {
            return AssociationType.COMPOSITION_DETAIL_TO_MASTER.equals((Object)association.getAssociationType());
        }

        private boolean isAlreadyConstrained(IAssociation association) {
            return this.alreadyConstrained.contains(association.getName());
        }

        @Override
        protected List<IAssociation> getAssociations(IType currentType) {
            return currentType.getAssociations();
        }
    }

    private class DerivedUnionsSpecifiedValidator
    extends TypeHierarchyVisitor<IType> {
        private MessageList msgList;
        private List<IAssociation> candidateSubsets;

        public DerivedUnionsSpecifiedValidator(MessageList msgList, IIpsProject ipsProject) {
            super(ipsProject);
            this.candidateSubsets = new ArrayList<IAssociation>(0);
            this.msgList = msgList;
        }

        @Override
        protected boolean visit(IType currentType) {
            List<IAssociation> associations = currentType.getAssociations();
            for (IAssociation association : associations) {
                this.candidateSubsets.add(association);
            }
            for (IAssociation association : associations) {
                Type.this.checkDerivedUnionIsImplemented(association, this.candidateSubsets, this.msgList);
            }
            return true;
        }
    }

    private static class IsSubtypeOfVisitor
    extends TypeHierarchyVisitor<IType> {
        private IType supertypeCandidate;
        private boolean subtype = false;

        public IsSubtypeOfVisitor(IIpsProject ipsProject, IType supertypeCandidate) {
            super(ipsProject);
            ArgumentCheck.notNull((Object)supertypeCandidate);
            this.supertypeCandidate = supertypeCandidate;
        }

        boolean isSubtype() {
            return this.subtype;
        }

        @Override
        protected boolean visit(IType currentType) {
            if (currentType == this.supertypeCandidate) {
                this.subtype = true;
                return false;
            }
            return true;
        }
    }

    private static class MethodFinderByNameAndParamtypes
    extends TypeHierarchyVisitor<IType> {
        private String methodName;
        private String[] datatypes;
        private IMethod method;

        public MethodFinderByNameAndParamtypes(IIpsProject ipsProject, String methodName, String[] datatypes) {
            super(ipsProject);
            this.methodName = methodName;
            this.datatypes = datatypes;
        }

        @Override
        protected boolean visit(IType currentType) {
            this.method = currentType.getMethod(this.methodName, this.datatypes);
            return this.method == null;
        }
    }

    private static class MethodFinderBySignature
    extends TypeHierarchyVisitor<IType> {
        private String signature;
        private IMethod method;

        public MethodFinderBySignature(IIpsProject ipsProject, String signature) {
            super(ipsProject);
            this.signature = signature;
        }

        @Override
        protected boolean visit(IType currentType) {
            this.method = currentType.getMethod(this.signature);
            return this.method == null;
        }
    }

    private class MethodOverrideCandidatesFinder
    extends TypeHierarchyVisitor<IType> {
        private List<IMethod> candidates;
        private boolean onlyNotImplementedAbstractMethods;

        public MethodOverrideCandidatesFinder(IIpsProject ipsProject, boolean onlyNotImplementedAbstractMethods) {
            super(ipsProject);
            this.candidates = new ArrayList<IMethod>();
            this.onlyNotImplementedAbstractMethods = onlyNotImplementedAbstractMethods;
        }

        @Override
        protected boolean visit(IType currentType) {
            List<IMethod> typeMethods = currentType.getMethods();
            for (IMethod method : typeMethods) {
                IMethod overridingMethod;
                if (this.onlyNotImplementedAbstractMethods && !method.isAbstract() || (overridingMethod = method.findOverridingMethod(Type.this, this.getIpsProject())) != null && overridingMethod.getType() == Type.this || overridingMethod != null && this.onlyNotImplementedAbstractMethods || this.sameMethodAlreadyInCandidateList(method, this.candidates)) continue;
                this.candidates.add(method);
            }
            return true;
        }

        private boolean sameMethodAlreadyInCandidateList(IMethod method, List<IMethod> candidates) {
            for (IMethod candidate : candidates) {
                if (!method.isSameSignature(candidate)) continue;
                return true;
            }
            return false;
        }
    }
}

