/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.ITypeHierarchy;
import org.faktorips.util.ArgumentCheck;

public class TypeHierarchy
implements ITypeHierarchy {
    private IType pcType;
    private Map<IType, Node> nodes = new HashMap<IType, Node>();
    private boolean containsCycle = false;

    private TypeHierarchy(IType pcType) {
        this.pcType = pcType;
    }

    public static final TypeHierarchy getSupertypeHierarchy(IType pcType) {
        IIpsProject project = pcType.getIpsProject();
        TypeHierarchy hierarchy = new TypeHierarchy(pcType);
        ArrayList<IType> subtypes = new ArrayList<IType>();
        IType type = pcType;
        while (type != null) {
            IType supertype = type.findSupertype(project);
            if (hierarchy.contains(supertype)) {
                hierarchy.containsCycle = true;
                supertype = null;
            }
            hierarchy.add(new Node(type, supertype, subtypes));
            subtypes = new ArrayList();
            subtypes.add(type);
            type = supertype;
        }
        return hierarchy;
    }

    public static final TypeHierarchy getSubtypeHierarchy(IType pcType) {
        TypeHierarchy hierarchy = new TypeHierarchy(pcType);
        hierarchy.addSubtypes(pcType, null, true, pcType.getIpsProject());
        return hierarchy;
    }

    public static final TypeHierarchy getSubtypeHierarchy(IType pcType, IIpsProject searchProject) {
        TypeHierarchy hierarchy = new TypeHierarchy(pcType);
        hierarchy.addSubtypes(pcType, null, false, searchProject);
        return hierarchy;
    }

    public static final TypeHierarchy getTypeHierarchy(IType pcType) {
        TypeHierarchy hierarchy = TypeHierarchy.getSupertypeHierarchy(pcType);
        Node pcTypeNode = hierarchy.nodes.get(pcType);
        List<IType> subtypes = hierarchy.searchDirectSubtypes(pcType, true, pcType.getIpsProject());
        for (IType subtype : subtypes) {
            hierarchy.addSubtypes(subtype, pcType, true, pcType.getIpsProject());
        }
        pcTypeNode.subtypes = subtypes;
        return hierarchy;
    }

    private void addSubtypes(IType pcType, IType superType, boolean searchReferencingProjects, IIpsProject ipsProject) {
        List<IType> subtypes = this.searchDirectSubtypes(pcType, searchReferencingProjects, ipsProject);
        Node node = new Node(pcType, superType, subtypes);
        this.add(node);
        for (IType subtype : subtypes) {
            this.addSubtypes(subtype, pcType, searchReferencingProjects, ipsProject);
        }
    }

    private List<IType> searchDirectSubtypes(IType type, boolean searchReferencingProjects, IIpsProject ipsProject) {
        ArrayList<IType> subtypes = new ArrayList<IType>();
        if (searchReferencingProjects) {
            IIpsProject[] referencingProjects;
            IIpsProject[] iIpsProjectArray = referencingProjects = ipsProject.findReferencingProjectLeavesOrSelf();
            int n = referencingProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsProject referencingProject = iIpsProjectArray[n2];
                this.findDirectSubtypes(type, subtypes, referencingProject);
                ++n2;
            }
        } else {
            this.findDirectSubtypes(type, subtypes, ipsProject);
        }
        return subtypes;
    }

    /*
     * WARNING - void declaration
     */
    private void findDirectSubtypes(IType type, List<IType> subtypes, IIpsProject project) {
        IIpsSrcFile[] candidateSrcFiles;
        IIpsSrcFile[] iIpsSrcFileArray = candidateSrcFiles = project.findIpsSrcFiles(type.getIpsObjectType());
        int n = candidateSrcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObject candidateObject;
            IIpsObject iIpsObject;
            IIpsSrcFile candidateSrcFile = iIpsSrcFileArray[n2];
            String candidateSuperTypeName = candidateSrcFile.getPropertyValue("supertype");
            if (type.getQualifiedName().equals(candidateSuperTypeName) && (iIpsObject = (candidateObject = candidateSrcFile.getIpsObject())) instanceof IType) {
                IType cfr_ignored_0 = (IType)iIpsObject;
                IType cfr_ignored_1 = (IType)iIpsObject;
                if (!subtypes.contains(candidateObject)) {
                    void candidateType;
                    if (this.contains((IType)candidateType)) {
                        this.containsCycle = true;
                    } else {
                        subtypes.add((IType)candidateType);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean containsCycle() {
        return this.containsCycle;
    }

    private boolean add(Node node) {
        if (this.nodes.containsKey(node.type)) {
            this.containsCycle = true;
            return false;
        }
        this.nodes.put(node.type, node);
        return true;
    }

    private boolean contains(IType type) {
        return this.nodes.containsKey(type);
    }

    @Override
    public IType getType() {
        return this.pcType;
    }

    @Override
    public IType getSupertype(IType type) {
        Node node = this.nodes.get(type);
        if (node == null) {
            return null;
        }
        return node.supertype;
    }

    @Override
    public List<IType> getAllSupertypes(IType type) {
        ArrayList<IType> result = new ArrayList<IType>();
        this.getAllSupertypes(type, result);
        return result;
    }

    @Override
    public List<IType> getAllSupertypesInclSelf(IType type) {
        ArrayList<IType> result = new ArrayList<IType>();
        result.add(type);
        this.getAllSupertypes(type, result);
        return result;
    }

    private void getAllSupertypes(IType type, List<IType> result) {
        IType supertype = this.getSupertype(type);
        while (supertype != null && !result.contains(supertype)) {
            result.add(supertype);
            supertype = this.getSupertype(supertype);
        }
    }

    @Override
    public boolean isSupertypeOf(IType candidate, IType subtype) {
        IType currSupertype = this.getSupertype(subtype);
        if (currSupertype == null) {
            return false;
        }
        if (currSupertype.equals(candidate)) {
            return true;
        }
        return this.isSupertypeOf(candidate, currSupertype);
    }

    @Override
    public boolean isSubtypeOf(IType candidate, IType supertype) {
        List<IType> subtypes = this.getSubtypes(supertype);
        for (IType subtype : subtypes) {
            if (!subtype.equals(candidate) && !this.isSubtypeOf(candidate, subtype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IType> getSubtypes(IType type) {
        Node node = this.nodes.get(type);
        if (node == null) {
            return new ArrayList<IType>();
        }
        return node.subtypes;
    }

    @Override
    public List<IType> getAllSubtypes(IType type) {
        Node node = this.nodes.get(type);
        if (node == null) {
            return new ArrayList<IType>();
        }
        ArrayList<IType> all = new ArrayList<IType>();
        this.addSubtypes(node, all);
        return all;
    }

    private void addSubtypes(Node node, List<IType> list) {
        if (node == null) {
            return;
        }
        list.addAll(node.subtypes);
        for (IType subtype : node.subtypes) {
            this.addSubtypes(this.nodes.get(subtype), list);
        }
    }

    @Override
    public List<IAttribute> getAllAttributes(IType type) {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        List<IType> types = this.getAllSupertypesInclSelf(type);
        for (IType type2 : types) {
            List<IAttribute> list = type2.getAttributes();
            for (IAttribute nextAttr : list) {
                attributes.add(nextAttr);
            }
        }
        return attributes;
    }

    @Override
    public List<IAttribute> getAllAttributesRespectingOverride(IType type) {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        List<IType> types = this.getAllSupertypesInclSelf(type);
        HashMap<String, IAttribute> overridden = new HashMap<String, IAttribute>();
        for (IType type2 : types) {
            List<IAttribute> attrs = type2.getAttributes();
            for (IAttribute attribute : attrs) {
                if (overridden.containsKey(attribute.getName())) continue;
                attributes.add(attribute);
                if (!attribute.isOverwrite()) continue;
                overridden.put(attribute.getName(), attribute);
            }
        }
        return attributes;
    }

    @Override
    public List<IMethod> getAllMethods(IType type) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        List<IType> types = this.getAllSupertypesInclSelf(type);
        for (IType type2 : types) {
            List<IMethod> typeMethods = type2.getMethods();
            for (IMethod nextMethod : typeMethods) {
                methods.add(nextMethod);
            }
        }
        return methods;
    }

    @Override
    public List<IValidationRule> getAllRules(IType type) {
        ArrayList<IValidationRule> rules = new ArrayList<IValidationRule>();
        List<IType> types = this.getAllSupertypesInclSelf(type);
        for (IType type2 : types) {
            if (!(type2 instanceof IPolicyCmptType)) continue;
            List<IValidationRule> typeRules = ((IPolicyCmptType)type2).getValidationRules();
            for (IValidationRule nextRule : typeRules) {
                rules.add(nextRule);
            }
        }
        return rules;
    }

    @Override
    public IAttribute findAttribute(IType type, String attributeName) {
        List<IType> types = this.getAllSupertypesInclSelf(type);
        for (IType type2 : types) {
            IAttribute a = type2.getAttribute(attributeName);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean isPartOfHierarchy(String name) {
        if (name != null) {
            for (Node node : this.nodes.values()) {
                String nodeName = node.type.getQualifiedName();
                if (!name.equals(nodeName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelectedType(String name) {
        return this.pcType.getQualifiedName().equals(name);
    }

    private static class Node {
        IType type;
        IType supertype;
        List<IType> subtypes;

        Node(IType type, IType supertype, List<IType> subtypes) {
            ArgumentCheck.notNull((Object)type);
            ArgumentCheck.notNull(subtypes);
            this.type = type;
            this.supertype = supertype;
            this.subtypes = subtypes;
        }
    }
}

