/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.Modifier;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.ITypePart;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;

public abstract class TypePart
extends BaseIpsObjectPart
implements ITypePart {
    private Modifier modifier = Modifier.PUBLISHED;
    private String category = "";
    private int categoryPosition = -1;

    protected TypePart(IType parent, String id) {
        super(parent, id);
    }

    @Override
    public IType getType() {
        return (IType)this.getParent();
    }

    @Override
    public boolean isOfType(QualifiedNameType qualifiedNameType) {
        return qualifiedNameType.equals(this.getType().getQualifiedNameType());
    }

    @Override
    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(Modifier modifier) {
        Modifier oldModifier = this.modifier;
        this.modifier = modifier;
        this.valueChanged((Object)oldModifier, (Object)modifier);
    }

    public void setCategory(String category) {
        String oldValue = this.category;
        this.category = category;
        this.valueChanged(oldValue, category, "category");
    }

    public String getCategory() {
        return this.category;
    }

    public boolean hasCategory() {
        return !this.category.isEmpty();
    }

    public int getCategoryPosition() {
        return this.categoryPosition;
    }

    public void setCategoryPosition(int categoryPosition) {
        int oldValue = this.categoryPosition;
        this.categoryPosition = categoryPosition;
        this.valueChanged(oldValue, categoryPosition, "categoryPosition");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.initModifierFromXml(element);
        this.initCategoryFromXml(element);
    }

    private void initModifierFromXml(Element element) {
        this.modifier = Modifier.getModifier(element.getAttribute("modifier"));
        if (this.modifier == null) {
            this.modifier = Modifier.PUBLISHED;
        }
    }

    private void initCategoryFromXml(Element element) {
        String categoryAttribute = element.getAttribute("category");
        this.category = categoryAttribute != null ? categoryAttribute : "";
        String categoryPositionAttribute = element.getAttribute("categoryPosition");
        this.categoryPosition = IpsStringUtils.isNotBlank((String)categoryPositionAttribute) ? Integer.parseInt(categoryPositionAttribute) : -1;
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("modifier", this.modifier.getId());
        if (IpsStringUtils.isNotEmpty((String)this.category)) {
            element.setAttribute("category", this.category);
        }
        if (this.categoryPosition > 0) {
            element.setAttribute("categoryPosition", Integer.toString(this.categoryPosition));
        }
    }
}

