/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.type;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.MessageLists;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;

public class TypeValidations {
    private static final Set<Set<IpsObjectType>> SAME_QNAME_ALLOWED = Set.of(Set.of(IpsObjectType.ENUM_TYPE, IpsObjectType.ENUM_CONTENT), Set.of(IpsObjectType.TABLE_STRUCTURE, IpsObjectType.TABLE_CONTENTS), Set.of(IpsObjectType.TEST_CASE_TYPE, IpsObjectType.TEST_CASE));
    private static final Map<IpsObjectType, List<IpsObjectType>> CONFLICTING_OBJECT_TYPES = new ConcurrentHashMap<IpsObjectType, List<IpsObjectType>>();

    private TypeValidations() {
    }

    @Deprecated
    public static Message validateOtherTypeWithSameNameTypeInIpsObjectPath(IpsObjectType otherIpsObjectType, String qualifiedName, IIpsProject ipsProject, IIpsObject ipsObject) {
        IIpsSrcFile file = ipsProject.findIpsSrcFile(otherIpsObjectType, qualifiedName);
        if (file != null) {
            ObjectProperty[] objectPropertyArray;
            if (ipsProject.equals(file.getIpsProject())) {
                ObjectProperty[] objectPropertyArray2;
                String string = MessageFormat.format(Messages.Type_msgOtherTypeWithSameQNameInSameProject, otherIpsObjectType.getDisplayName());
                if (ipsObject != null) {
                    ObjectProperty[] objectPropertyArray3 = new ObjectProperty[1];
                    objectPropertyArray2 = objectPropertyArray3;
                    objectPropertyArray3[0] = new ObjectProperty((Object)ipsObject, null);
                } else {
                    objectPropertyArray2 = new ObjectProperty[]{};
                }
                return new Message("Type-OtherTypeWithSameNameExists", string, Message.ERROR, objectPropertyArray2);
            }
            String string = MessageFormat.format(Messages.Type_msgOtherTypeWithSameQNameInDependentProject, otherIpsObjectType.getId(), file.getIpsProject());
            if (ipsObject != null) {
                ObjectProperty[] objectPropertyArray4 = new ObjectProperty[1];
                objectPropertyArray = objectPropertyArray4;
                objectPropertyArray4[0] = new ObjectProperty((Object)ipsObject, "name");
            } else {
                objectPropertyArray = new ObjectProperty[]{};
            }
            return new Message("Type-OtherTypeWithSameNameInDependentProjectExists", string, Message.WARNING, objectPropertyArray);
        }
        return null;
    }

    public static MessageList validateUniqueQualifiedName(IIpsObject ipsObject) {
        Objects.requireNonNull(ipsObject, "ipsObject must not be null");
        return TypeValidations.validateUniqueQualifiedName(ipsObject, ipsObject.getIpsObjectType(), ipsObject.getQualifiedName(), ipsObject.getIpsProject());
    }

    public static MessageList validateUniqueQualifiedName(IpsObjectType ipsObjectType, String qualifiedName, IIpsProject ipsProject) {
        return TypeValidations.validateUniqueQualifiedName(null, ipsObjectType, qualifiedName, ipsProject);
    }

    private static MessageList validateUniqueQualifiedName(@CheckForNull IIpsObject ipsObject, IpsObjectType ipsObjectType, String qualifiedName, IIpsProject ipsProject) {
        Objects.requireNonNull(ipsObjectType, "ipsObjectType must not be null");
        Objects.requireNonNull(qualifiedName, "qualifiedName must not be null");
        Objects.requireNonNull(ipsProject, "ipsProject must not be null");
        return (MessageList)CONFLICTING_OBJECT_TYPES.computeIfAbsent(ipsObjectType, ot -> Arrays.stream(IIpsModel.get().getIpsObjectTypes()).filter(t -> !ot.equals(t)).filter(t -> SAME_QNAME_ALLOWED.stream().noneMatch(s -> s.contains(ot) && s.contains(t))).collect(Collectors.toList())).stream().map(t -> ipsProject.findIpsSrcFile((IpsObjectType)t, qualifiedName)).filter(f -> f != null).map(file -> TypeValidations.dupicateQualifiedName(ipsObject, ipsProject, file)).collect(MessageLists.collectMessages());
    }

    private static Message dupicateQualifiedName(IIpsObject ipsObject, IIpsProject ipsProject, IIpsSrcFile file) {
        ObjectProperty[] invalidObjectProperties;
        IpsObjectType otherIpsObjectType = file.getIpsObjectType();
        if (ipsObject != null) {
            ObjectProperty[] objectPropertyArray = new ObjectProperty[1];
            v1 = objectPropertyArray;
            objectPropertyArray[0] = new ObjectProperty((Object)ipsObject, "name");
        } else {
            v1 = invalidObjectProperties = new ObjectProperty[]{};
        }
        if (ipsProject.equals(file.getIpsProject())) {
            return new Message("Type-OtherTypeWithSameNameExists", MessageFormat.format(Messages.Type_msgOtherTypeWithSameQNameInSameProject, otherIpsObjectType.getDisplayName()), Message.ERROR, invalidObjectProperties);
        }
        return new Message("Type-OtherTypeWithSameNameInDependentProjectExists", MessageFormat.format(Messages.Type_msgOtherTypeWithSameQNameInDependentProject, otherIpsObjectType.getId(), file.getIpsProject()), Message.WARNING, invalidObjectProperties);
    }

    public static Message validateTypeHierachy(IType type, IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)type.getSupertype())) {
            return null;
        }
        IType superType = type.findSupertype(ipsProject);
        if (superType == null) {
            String text = MessageFormat.format(Messages.Type_msg_supertypeNotFound, type.getSupertype());
            return new Message("Type-SupertypeNotFound", text, Message.ERROR, (Object)type, new String[]{"supertype"});
        }
        SupertypesValidator validator = new SupertypesValidator(ipsProject);
        validator.start(superType);
        if (!validator.result) {
            String text = Messages.Type_msg_TypeHierarchyInconsistent;
            return new Message("Type-InconsistentTypeHierarchy", text, Message.ERROR, (Object)type, new String[]{"supertype"});
        }
        if (validator.cycleDetected()) {
            String msg = Messages.Type_msg_cycleInTypeHierarchy;
            return new Message("Type-CycleInSupertypeHierarchy", msg, Message.ERROR, (Object)type, new String[]{"supertype"});
        }
        return null;
    }

    private static class SupertypesValidator
    extends TypeHierarchyVisitor<IType> {
        private boolean result;

        public SupertypesValidator(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IType currentType) {
            if (IpsStringUtils.isEmpty((String)currentType.getSupertype())) {
                this.result = true;
                return false;
            }
            this.result = this.isNull(currentType);
            return this.result;
        }

        private boolean isNull(IType currentType) {
            return currentType.findSupertype(this.getIpsProject()) != null;
        }
    }
}

