/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.util;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.util.MultiMap;
import org.faktorips.util.MultiMaps;
import org.faktorips.util.SortedMultiMap;
import org.faktorips.values.Decimal;

public class Histogram<V, E> {
    public static final int SCALE = 2;
    private final SortedMultiMap<V, E> valueToElements;
    private final Function<E, V> elementToValueFunction;
    private final int totalCount;
    private Comparator<? super V> valueComparator;

    @SafeVarargs
    public Histogram(Function<E, V> elementToValueFunction, E ... elements) {
        this(elementToValueFunction, (Comparator<V>)new EqualToComparator(), Arrays.asList(elements));
    }

    public Histogram(Function<E, V> elementToValueFunction, Collection<E> elements) {
        this(elementToValueFunction, (Comparator<V>)new EqualToComparator(), elements);
    }

    @SafeVarargs
    public Histogram(Function<E, V> elementToValueFunction, Comparator<? super V> valueComparator, E ... elements) {
        this((Function<E, ? super V>)elementToValueFunction, valueComparator, Arrays.asList(elements));
    }

    public Histogram(Function<E, V> elementToValueFunction, Comparator<? super V> valueComparator, Collection<E> elements) {
        this.valueComparator = valueComparator;
        this.totalCount = elements.size();
        this.elementToValueFunction = elementToValueFunction;
        this.valueToElements = new SortedMultiMap(valueComparator, new SameInstanceComparator());
        this.initValueToElementsMap(elements);
    }

    public SortedMap<V, Integer> getAbsoluteDistribution() {
        TreeMap<Integer, Integer> sortedDistribution = new TreeMap<Integer, Integer>(new DistributionComparator<V>(this.valueToElements, this.valueComparator));
        sortedDistribution.putAll(this.transformToOccurenceCountMap((MultiMap<V, E>)this.valueToElements));
        return Collections.unmodifiableSortedMap(sortedDistribution);
    }

    public SortedMap<V, Decimal> getRelativeDistribution() {
        SortedMap<V, Integer> absoluteDistribution = this.getAbsoluteDistribution();
        SortedMap<V, Decimal> relativeDistribution = this.transformToRelativeDistribution(absoluteDistribution);
        return Collections.unmodifiableSortedMap(relativeDistribution);
    }

    public MultiMap<V, E> getDistribution() {
        return MultiMaps.unmodifiableMultimap(this.valueToElements);
    }

    public int countElements() {
        return this.valueToElements.count();
    }

    public Collection<E> getElements(V value) {
        return this.valueToElements.get(value);
    }

    public boolean isEmpty() {
        return this.valueToElements.isEmpty();
    }

    private SortedMap<V, Decimal> transformToRelativeDistribution(SortedMap<V, Integer> map) {
        TreeMap relative = new TreeMap(map.comparator());
        map.forEach((k, v) -> {
            Decimal decimal = relative.put(k, Decimal.valueOf((Integer)v).divide(this.totalCount, 2, RoundingMode.HALF_UP));
        });
        return relative;
    }

    private Map<V, Integer> transformToOccurenceCountMap(MultiMap<V, E> map) {
        LinkedHashMap occurence = new LinkedHashMap();
        map.asMap().forEach((k, v) -> {
            Integer n = occurence.put(k, v.size());
        });
        return occurence;
    }

    private void initValueToElementsMap(Collection<E> elements) {
        for (E e : elements) {
            this.valueToElements.put(this.elementToValueFunction.apply(e), new Object[]{e});
        }
    }

    private static int compareAnyObjects(Object o1, Object o2) {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return Histogram.compare(c1, c2);
        }
        int idCompare = Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
        if (idCompare == 0) {
            return 1;
        }
        return idCompare;
    }

    private static <T> int compare(Comparable o1, Comparable o2) {
        return ObjectUtils.compare((Comparable)o1, (Comparable)o2);
    }

    public BestValue<V> getBestValue(Decimal threshold) {
        SortedMap<V, Decimal> relativeDistribution = this.getRelativeDistribution();
        V candidateValue = relativeDistribution.firstKey();
        return this.getBestValue(threshold, relativeDistribution, candidateValue);
    }

    protected BestValue<V> getBestValue(Decimal threshold, SortedMap<V, Decimal> relativeDistribution, V candidateValue) {
        Decimal relDist = this.getRelativeDistribution(relativeDistribution, candidateValue);
        if (relDist.greaterThanOrEqual(threshold)) {
            return new BestValue<V>(candidateValue, relDist);
        }
        return BestValue.missingValue();
    }

    protected Decimal getRelativeDistribution(SortedMap<V, Decimal> relativeDistribution, V candidateValue) {
        Decimal relDist = (Decimal)relativeDistribution.get(candidateValue);
        if (relDist == null) {
            IpsLog.log((IStatus)new IpsStatus(4, "There seems to be an error in a datatype comparator: " + this.valueToElements.values().iterator().next() + " Value: " + candidateValue));
            return Decimal.valueOf((Integer)0);
        }
        return relDist;
    }

    public static <E, V> Histogram<E, V> emptyHistogram() {
        return new Histogram(null, Collections.emptyList());
    }

    public static class BestValue<V> {
        private final V value;
        private final Decimal relativeFrequency;
        private final boolean isPresent;

        public BestValue(V value, Decimal relativeFrequency) {
            this.value = value;
            this.relativeFrequency = relativeFrequency;
            this.isPresent = true;
        }

        public BestValue() {
            this.value = null;
            this.relativeFrequency = Decimal.NULL;
            this.isPresent = false;
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public V getValue() {
            return this.value;
        }

        public static <V> BestValue<V> missingValue() {
            return new BestValue<V>();
        }

        public Decimal getRelativeFrequency() {
            return this.relativeFrequency;
        }
    }

    private static class DistributionComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final SortedMultiMap<V, ?> valueToElements;
        private Comparator<? super V> valueComparator;

        public DistributionComparator(SortedMultiMap<V, ?> valueToElements, Comparator<? super V> valueComparator) {
            this.valueToElements = valueToElements;
            this.valueComparator = valueComparator;
        }

        @Override
        public int compare(V value1, V value2) {
            int occurences2;
            int occurences1 = this.valueToElements.get(value1).size();
            if (occurences1 == (occurences2 = this.valueToElements.get(value2).size())) {
                return this.valueComparator.compare(value1, value2);
            }
            return Integer.compare(occurences2, occurences1);
        }
    }

    private static class EqualToComparator<U>
    implements Comparator<U>,
    Serializable {
        private static final long serialVersionUID = -5480214299260180838L;

        private EqualToComparator() {
        }

        @Override
        public int compare(U o1, U o2) {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            return Histogram.compareAnyObjects(o1, o2);
        }
    }

    private static class SameInstanceComparator<U>
    implements Comparator<U>,
    Serializable {
        private static final long serialVersionUID = -5480214299260180838L;

        private SameInstanceComparator() {
        }

        @Override
        public int compare(U o1, U o2) {
            if (o1 == o2) {
                return 0;
            }
            return Histogram.compareAnyObjects(o1, o2);
        }
    }
}

