/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.util;

import org.faktorips.devtools.model.internal.util.Messages;

public class StringUtils {
    public static final String QUOTE = "\"";

    private StringUtils() {
    }

    public static final String wrapText(String text, int length, String lineSeparator) {
        if (text == null || "".equals(text)) {
            return text;
        }
        String[] lines = text.split(lineSeparator);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            String lineText = lines[i];
            while (lineText.length() > length) {
                int index = lineText.indexOf(32, length);
                if (index == -1) break;
                sb.append(lineText.substring(0, index));
                if (lineText.length() > index + 1) {
                    sb.append(lineSeparator);
                    lineText = lineText.substring(index + 1, lineText.length());
                    continue;
                }
                lineText = "";
                break;
            }
            sb.append(lineText);
            if (i + 1 < lines.length && !"".equals(lines[i + 1])) {
                sb.append(lineSeparator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String computeCopyOfName(int uniqueCopyOfCounter, String nameCandidate) {
        String nameWithoutCopyOfPrefix;
        String uniqueCopyOfCounterText;
        String string = uniqueCopyOfCounterText = uniqueCopyOfCounter == 0 ? "" : "(" + (uniqueCopyOfCounter + 1) + ")_";
        if (nameCandidate.startsWith(Messages.StringUtils_copyOfNamePrefix)) {
            nameWithoutCopyOfPrefix = org.apache.commons.lang3.StringUtils.substringAfter((String)nameCandidate, (String)Messages.StringUtils_copyOfNamePrefix);
            nameWithoutCopyOfPrefix = nameWithoutCopyOfPrefix.replaceAll("^\\([0-9]*\\)_", "");
        } else {
            nameWithoutCopyOfPrefix = nameCandidate;
        }
        return String.valueOf(Messages.StringUtils_copyOfNamePrefix) + uniqueCopyOfCounterText + nameWithoutCopyOfPrefix;
    }

    public static String quote(String text) {
        StringBuilder sb = new StringBuilder();
        if (text == null || !text.startsWith(QUOTE)) {
            sb.append(QUOTE);
        }
        sb.append(text);
        if (text == null || !text.endsWith(QUOTE)) {
            sb.append(QUOTE);
        }
        return sb.toString();
    }
}

