/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdValidatorHolder
extends ThreadLocal<Validator> {
    private final IpsObjectType ipsObjectType;

    public XsdValidatorHolder(IpsObjectType ipsObjectType) {
        this.ipsObjectType = ipsObjectType;
    }

    @Override
    protected Validator initialValue() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setResourceResolver(new IpsXsdResourceResolver());
            Schema schema = factory.newSchema(this.loadIpsSchemaFileFromClasspath());
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new LoggingErrorHandler());
            return validator;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private StreamSource loadIpsSchemaFileFromClasspath() {
        String resource = "xsd-schema/" + this.ipsObjectType.getXmlElementName() + ".xsd";
        InputStream xsdSchemaStream = this.ipsObjectType.getClass().getClassLoader().getResourceAsStream(resource);
        return new StreamSource(new InputStreamReader(xsdSchemaStream));
    }

    private InputStreamReader loadDependendSchemaFilesFromClasspath(String systemId) {
        String path;
        if (systemId.endsWith("xml.xsd")) {
            path = "xsd-schema/xml.xsd";
        } else if (systemId.endsWith("ips-global.xsd")) {
            path = "xsd-schema/ips-global.xsd";
        } else if (systemId.startsWith("https://doc.faktorzehn.org/schema/faktor-ips/")) {
            path = "xsd-schema/" + systemId.substring(systemId.lastIndexOf(47) + 1);
        } else {
            throw new IllegalArgumentException("Unknown dependent schema file: " + systemId);
        }
        InputStream xsdSchemaStream = this.getClass().getClassLoader().getResourceAsStream(path);
        return new InputStreamReader(xsdSchemaStream);
    }

    class IpsXsdLSInput
    implements LSInput {
        private String systemId;
        private Reader characterStream;

        public IpsXsdLSInput(String systemId, InputStreamReader characterStream) {
            this.systemId = systemId;
            this.characterStream = characterStream;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }

    class IpsXsdResourceResolver
    implements LSResourceResolver {
        IpsXsdResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            return new IpsXsdLSInput(systemId, XsdValidatorHolder.this.loadDependendSchemaFilesFromClasspath(systemId));
        }
    }

    private static final class LoggingErrorHandler
    implements ErrorHandler {
        private LoggingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            IpsLog.log((IStatus)new IpsStatus(2, e.getLocalizedMessage()));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new RuntimeException(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            IpsLog.log((IStatus)new IpsStatus(4, e.getLocalizedMessage()));
        }
    }
}

