/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.value;

import java.util.Locale;
import java.util.Objects;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.value.IValue;

public abstract class AbstractValue<T>
implements IValue<T> {
    @Override
    public String getLocalizedContent(Locale locale) {
        return this.getContentAsString();
    }

    @Override
    public String getDefaultLocalizedContent(IIpsProject ipsProject) {
        return this.getLocalizedContent(this.getDefaultLanguage(ipsProject));
    }

    @Override
    public String getLocalizedContent() {
        return this.getLocalizedContent(null);
    }

    private Locale getDefaultLanguage(IIpsProject ipsProject) {
        return ipsProject.getReadOnlyProperties().getDefaultLanguage().getLocale();
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractValue value = (AbstractValue)obj;
        return Objects.equals(this.getContentAsString(), value.getContentAsString());
    }

    public int hashCode() {
        return this.getContentAsString().hashCode();
    }
}

