/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.value;

import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IInternationalString;
import org.faktorips.devtools.model.internal.InternationalString;
import org.faktorips.devtools.model.internal.InternationalStringXmlHelper;
import org.faktorips.devtools.model.internal.value.AbstractValue;
import org.faktorips.devtools.model.internal.value.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InternationalStringValue
extends AbstractValue<IInternationalString> {
    public static final String CONTENT_STRING_SEPERATOR = "|";
    private final InternationalString content = new InternationalString();

    public static InternationalStringValue createFromXml(Element element) {
        InternationalStringValue value = new InternationalStringValue();
        IInternationalString internationalString = value.getContent();
        InternationalStringXmlHelper.initFromXml(internationalString, element);
        return value;
    }

    @Override
    public IInternationalString getContent() {
        return this.content;
    }

    @Override
    public Node toXml(Document doc) {
        return this.getContent().toXml(doc);
    }

    @Override
    public String getContentAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LocalizedString localizedString : this.getContent().values()) {
            if (!IpsStringUtils.isEmpty((String)stringBuilder.toString())) {
                stringBuilder.append(CONTENT_STRING_SEPERATOR);
            }
            stringBuilder.append(localizedString.getLocale()).append("=").append(localizedString.getValue());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InternationalStringValue [");
        builder.append("content=");
        builder.append(this.getContent());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + this.getContent().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void other;
        Object object;
        if (this == obj) {
            return true;
        }
        if (obj == null || !((object = obj) instanceof InternationalStringValue)) {
            return false;
        }
        InternationalStringValue internationalStringValue = (InternationalStringValue)object;
        InternationalStringValue cfr_ignored_0 = (InternationalStringValue)object;
        return this.getContent().equals(other.getContent());
    }

    @Override
    public void validate(ValueDatatype datatype, String datatypeName, IIpsProject ipsproject, MessageList list, ObjectProperty ... objectProperty) {
        if (this.getContent() != null) {
            MessageList newList = new MessageList();
            Set<ISupportedLanguage> supportedLanguages = ipsproject.getReadOnlyProperties().getSupportedLanguages();
            int languagesCount = supportedLanguages.size();
            for (ISupportedLanguage supportedLanguage : supportedLanguages) {
                LocalizedString iLocalizedString = this.getContent().get(supportedLanguage.getLocale());
                if (!IpsStringUtils.isEmpty((String)iLocalizedString.getValue())) continue;
                newList.add(new Message("ATTRIBUTEVALUE-MultilingualNotSet", MessageFormat.format(Messages.AttributeValue_MultiLingual_NotSet, supportedLanguage.getLocale().getDisplayLanguage()), Message.WARNING, objectProperty));
            }
            if (languagesCount > newList.size()) {
                list.add(newList);
            }
        }
    }

    @Override
    public String getLocalizedContent(Locale locale) {
        LocalizedString localizedString = this.getContent().get(locale);
        return localizedString.getValue();
    }

    @Override
    public String getLocalizedContent() {
        for (LocalizedString localizedString : this.getContent().values()) {
            String value = localizedString.getValue();
            if (IpsStringUtils.isEmpty((String)value)) continue;
            return value;
        }
        return "";
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.content.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.content.removePropertyChangeListener(l);
    }

    @Override
    public int compare(IValue<?> other, ValueDatatype valueDatatype) {
        if (IInternationalString.class.isAssignableFrom(other.getContent().getClass())) {
            return this.getContent().compareTo((IInternationalString)other.getContent());
        }
        return Comparator.naturalOrder().compare(this.getContentAsString(), other.getContentAsString());
    }
}

