/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.value;

import java.beans.PropertyChangeListener;
import java.util.Comparator;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.value.AbstractValue;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StringValue
extends AbstractValue<String> {
    private final String content;

    public StringValue(String content) {
        this.content = content;
    }

    public static StringValue createFromXml(Text text) {
        return new StringValue(text.getNodeValue());
    }

    @Override
    public Node toXml(Document doc) {
        if (this.getContent() != null) {
            return doc.createTextNode(this.getContent());
        }
        return doc.createTextNode("");
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getContentAsString() {
        return this.getContent();
    }

    public String toString() {
        return this.getContent();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.getContent() == null ? 0 : this.getContent().hashCode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void other;
        Object object;
        if (this == obj) {
            return true;
        }
        if (obj == null || !((object = obj) instanceof StringValue)) {
            return false;
        }
        StringValue stringValue = (StringValue)object;
        StringValue cfr_ignored_0 = (StringValue)object;
        return !(this.getContent() == null ? other.getContent() != null : !this.getContent().equals(other.getContent()));
    }

    @Override
    public void validate(ValueDatatype datatype, String datatypeName, IIpsProject ipsproject, MessageList list, ObjectProperty ... objectProperties) {
        MessageList newMsgList = new MessageList();
        ValidationUtils.checkValue(datatype, datatypeName, this.getContent(), objectProperties[0].getObject(), objectProperties[0].getProperty(), newMsgList);
        for (Message message : newMsgList) {
            list.add(new Message(message.getCode(), message.getText(), message.getSeverity(), objectProperties));
        }
    }

    @Override
    public int compare(IValue<?> other, ValueDatatype valueDatatype) {
        if (other instanceof StringValue && valueDatatype.supportsCompare()) {
            return valueDatatype.compare(this.content, (String)other.getContent());
        }
        if (other == null) {
            return 1;
        }
        return Comparator.naturalOrder().compare(this.getContentAsString(), other.getContentAsString());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

