/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.value;

import java.util.HashSet;
import java.util.Set;
import org.faktorips.devtools.model.IInternationalString;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.values.LocalizedString;

public abstract class ValueUtil {
    public static ValueUtil createUtil(IValue<?> value) {
        if (value.getContent() instanceof IInternationalString) {
            return new InternationalStringValueUtil(value);
        }
        if (value.getContent() == null || value.getContent() instanceof String) {
            return new StringValueUtil(value);
        }
        throw new IllegalArgumentException("The value " + value + " is not supported by ValidationUtil.");
    }

    public abstract Set<LocalizedString> getLocalizedIdentifiers();

    public abstract boolean isPartlyEmpty(IIpsProject var1);

    private static class InternationalStringValueUtil
    extends ValueUtil {
        private final IValue<IInternationalString> value;

        public InternationalStringValueUtil(IValue<IInternationalString> value) {
            this.value = value;
        }

        @Override
        public Set<LocalizedString> getLocalizedIdentifiers() {
            HashSet<LocalizedString> result = new HashSet<LocalizedString>();
            for (LocalizedString localizedString : this.value.getContent().values()) {
                result.add(localizedString);
            }
            return result;
        }

        @Override
        public boolean isPartlyEmpty(IIpsProject ipsProject) {
            Set<ISupportedLanguage> supportedLanguages = ipsProject.getReadOnlyProperties().getSupportedLanguages();
            for (ISupportedLanguage supportedLanguage : supportedLanguages) {
                LocalizedString localizedString = this.value.getContent().get(supportedLanguage.getLocale());
                if (!IpsStringUtils.isEmpty((String)localizedString.getValue())) continue;
                return true;
            }
            return false;
        }
    }

    private static class StringValueUtil
    extends ValueUtil {
        private final IValue<String> value;

        public StringValueUtil(IValue<String> value) {
            this.value = value;
        }

        @Override
        public Set<LocalizedString> getLocalizedIdentifiers() {
            HashSet<LocalizedString> result = new HashSet<LocalizedString>();
            result.add(new LocalizedString(null, this.value.getContent()));
            return result;
        }

        @Override
        public boolean isPartlyEmpty(IIpsProject ipsProject) {
            return IpsStringUtils.isEmpty((String)this.value.getContent());
        }
    }
}

