/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.valueset.AbstractValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.ValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.valueset.IDerivedValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.Messages;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DerivedValueSet
extends ValueSet
implements IDerivedValueSet {
    public DerivedValueSet(IValueSetOwner parent, String partId) {
        super(ValueSetType.DERIVED, parent, partId);
    }

    @Override
    public boolean containsValue(String value, IIpsProject ipsProject) {
        ValueDatatype datatype = this.findValueDatatype(ipsProject);
        return datatype != null && datatype.isParsable(value);
    }

    @Override
    public boolean containsValueSet(IValueSet subset) {
        IIpsProject contextProject = subset.getIpsProject();
        ValueDatatype datatype = this.findValueDatatype(contextProject);
        ValueDatatype subDatatype = subset.findValueDatatype(contextProject);
        return DatatypeUtil.isCovariant(subDatatype, datatype);
    }

    @Override
    public IValueSet copy(IValueSetOwner newParent, String id) {
        return new DerivedValueSet(newParent, id);
    }

    @Override
    public String toShortString() {
        return this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return Messages.ValueSetFormat_derived;
    }

    @Override
    public boolean isContainsNull() {
        IAttribute overwrittenAttribute;
        IPolicyCmptTypeAttribute policyCmptTypeAttribute;
        if (this.getValueSetOwner() instanceof IPolicyCmptTypeAttribute && (policyCmptTypeAttribute = (IPolicyCmptTypeAttribute)this.getValueSetOwner()).isOverwrite() && (overwrittenAttribute = policyCmptTypeAttribute.findOverwrittenAttribute(this.getIpsProject())) != null) {
            return overwrittenAttribute.getValueSet().isContainsNull();
        }
        ValueDatatype valueDatatype = this.findValueDatatype(this.getIpsProject());
        return valueDatatype == null || !valueDatatype.isPrimitive();
    }

    @Override
    public void setContainsNull(boolean containsNull) {
        throw new UnsupportedOperationException(Messages.DerivedValueSet_MsgCantSetContainsNull);
    }

    @Override
    public int compareTo(IValueSet o) {
        if (o.isDerived()) {
            return 0;
        }
        return this.compareDifferentValueSets(o);
    }

    @Override
    protected void copyPropertiesFrom(IValueSet source) {
    }

    @Override
    protected AbstractValueSetValidator<?> createValidator(IValueSetOwner owner, ValueDatatype datatype) {
        return new AbstractValueSetValidator<ValueSet>((ValueSet)this, owner, datatype){

            @Override
            public MessageList validate() {
                return new MessageList();
            }
        };
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        Document doc = element.getOwnerDocument();
        Element tagElement = doc.createElement("Derived");
        element.appendChild(tagElement);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

