/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ipsobject.DescriptionHelper;
import org.faktorips.devtools.model.internal.valueset.EnumValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.Messages;
import org.faktorips.devtools.model.internal.valueset.ValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IDatatypeFormatter;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.devtools.model.valueset.IEnumValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.util.collections.ListComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EnumValueSet
extends ValueSet
implements IEnumValueSet {
    public static final String ENUM_VALUESET_SEPARATOR = "|";
    public static final String ENUM_VALUESET_SEPARATOR_WITH_WHITESPACE = " | ";
    public static final String ENUM_VALUESET_START = "{";
    public static final String ENUM_VALUESET_END = "}";
    public static final String ENUM_VALUESET_EMPTY = "{}";
    public static final String XML_TAG_ENUM = "Enum";
    private static final String XML_DATA = "Data";
    private static final String XML_VALUE = "Value";
    private List<String> values = new ArrayList<String>();
    private Map<String, List<Integer>> valuesToIndexMap = new HashMap<String, List<Integer>>();

    public EnumValueSet(IValueSetOwner parent, String partId) {
        super(ValueSetType.ENUM, parent, partId);
    }

    public EnumValueSet(IValueSetOwner parent, List<String> values, String partId) {
        this(parent, partId);
        this.values = values;
        this.refillValuesToIndexMap();
    }

    @Override
    public String[] getValues() {
        return this.values.toArray(new String[this.values.size()]);
    }

    @Override
    public List<String> getValuesAsList() {
        return new ArrayList<String>(this.values);
    }

    @Override
    public void move(List<Integer> indices, boolean up) {
        ListElementMover<String> mover = new ListElementMover<String>(this.values);
        int[] indicesArray = new int[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            indicesArray[i] = indices.get(i);
            ++i;
        }
        mover.move(indicesArray, up);
        this.refillValuesToIndexMap();
        this.objectHasChanged();
    }

    @Override
    public void move(List<Integer> indices, int targetIndex, boolean insertBelow) {
        ListElementMover<String> mover = new ListElementMover<String>(this.values);
        int[] indicesArray = new int[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            indicesArray[i] = indices.get(i);
            ++i;
        }
        mover.moveToIndex(indicesArray, targetIndex, insertBelow);
        this.refillValuesToIndexMap();
        this.objectHasChanged();
    }

    @Override
    public List<Integer> getPositions(String value) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        List<Integer> indexes = this.valuesToIndexMap.get(value);
        if (indexes != null) {
            positions.addAll(indexes);
            Collections.sort(positions);
        }
        return positions;
    }

    @Override
    public boolean containsValue(String value, IIpsProject ipsProject) {
        ValueDatatype datatype = this.findValueDatatype(ipsProject);
        if (datatype == null) {
            return false;
        }
        if (DatatypeUtil.isNullValue(datatype, value) && this.isContainsNull() || this.isAbstract()) {
            return true;
        }
        return this.isValueInEnum(value, datatype);
    }

    private boolean isValueInEnum(String value, ValueDatatype datatype) {
        for (String each : this.values) {
            try {
                if (!Objects.equals(each, value) && !datatype.areValuesEqual(each, value)) continue;
                return true;
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean containsValueSet(IValueSet subset) {
        IIpsProject contextProject = subset.getIpsProject();
        ValueDatatype datatype = this.findValueDatatype(contextProject);
        if (!subset.isEnum() || !this.datatypesCompatible(subset, datatype, contextProject) || !this.isContainsNull() && subset.isContainsNull()) {
            return false;
        }
        if (this.isAbstract()) {
            return true;
        }
        if (subset.isAbstract()) {
            return false;
        }
        return this.containsAllValues((IEnumValueSet)subset, contextProject);
    }

    private boolean datatypesCompatible(IValueSet subset, ValueDatatype datatype, IIpsProject contextProject) {
        ValueDatatype subDatatype = subset.findValueDatatype(contextProject);
        return Objects.equals(datatype, subDatatype);
    }

    private boolean containsAllValues(IEnumValueSet subset, IIpsProject contextProject) {
        String[] subsetValues;
        String[] stringArray = subsetValues = subset.getValues();
        int n = subsetValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!this.containsValue(value, contextProject)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void addValue(String val) {
        this.addValueWithoutTriggeringChangeEvent(val);
        this.objectHasChanged();
    }

    @Override
    public void addValues(List<String> values) {
        for (String value : values) {
            this.addValueWithoutTriggeringChangeEvent(value);
        }
        this.objectHasChanged();
    }

    protected void addValueWithoutTriggeringChangeEvent(String newValue) {
        this.values.add(newValue);
        Integer newIndex = this.values.size() - 1;
        this.setValueWithoutTriggeringChangeEvent(newValue, newIndex);
    }

    private void setValueWithoutTriggeringChangeEvent(String newValue, Integer newIndex) {
        List indexList = this.valuesToIndexMap.computeIfAbsent(newValue, $ -> new ArrayList(1));
        indexList.add(newIndex);
    }

    @Override
    public void removeValue(int index) {
        this.values.remove(index);
        this.refillValuesToIndexMap();
        this.objectHasChanged();
    }

    @Override
    public void removeValue(String value) {
        this.removeWithoutTriggeringChangeEvents(value);
        this.objectHasChanged();
    }

    @Override
    public void removeValues(List<String> values) {
        for (String value : values) {
            this.removeWithoutTriggeringChangeEvents(value);
        }
        this.objectHasChanged();
    }

    private void removeWithoutTriggeringChangeEvents(String value) {
        List<Integer> indexes = this.valuesToIndexMap.remove(value);
        if (indexes == null) {
            return;
        }
        Iterator<String> it = this.values.iterator();
        while (it.hasNext()) {
            String each = it.next();
            if (!Objects.equals(each, value)) continue;
            it.remove();
        }
        this.refillValuesToIndexMap();
    }

    private void refillValuesToIndexMap() {
        this.valuesToIndexMap.clear();
        int i = 0;
        while (i < this.values.size()) {
            this.setValueWithoutTriggeringChangeEvent(this.values.get(i), i);
            ++i;
        }
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public void setValue(int index, String value) {
        String oldValue = this.values.get(index);
        this.values.set(index, value);
        List<Integer> indexes = this.valuesToIndexMap.get(oldValue);
        indexes.remove((Object)index);
        this.setValueWithoutTriggeringChangeEvent(value, index);
        this.valueChanged(oldValue, value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String[] getValuesNotContained(IEnumValueSet otherSet) {
        ArrayList<String> result = new ArrayList<String>();
        if (otherSet == null) {
            return result.toArray(new String[result.size()]);
        }
        int i = 0;
        while (i < otherSet.size()) {
            if (!this.values.contains(otherSet.getValue(i))) {
                result.add(otherSet.getValue(i));
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected EnumValueSetValidator createValidator(IValueSetOwner owner, ValueDatatype datatype) {
        return new EnumValueSetValidator(this, owner, datatype);
    }

    @Override
    public void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        list.add(this.createValidator(this.getValueSetOwner(), this.findValueDatatype(ipsProject)).validate());
    }

    @Override
    public MessageList validateValue(int index, IIpsProject ipsProject) {
        return this.createValidator(this.getValueSetOwner(), this.findValueDatatype(ipsProject)).validateValue(index);
    }

    @Override
    public String toString() {
        if (this.isAbstract()) {
            return String.valueOf(super.toString()) + "(abstract)";
        }
        return String.valueOf(super.toString()) + ":" + this.values.toString();
    }

    @Override
    public String toShortString() {
        if (this.isAbstract()) {
            return this.toStringAbstractEnumValueSet();
        }
        ValueDatatype type = this.findValueDatatype(this.getIpsProject());
        IDatatypeFormatter datatypeFormatter = IIpsModelExtensions.get().getModelPreferences().getDatatypeFormatter();
        List formattedValues = this.values.stream().map(value -> datatypeFormatter.formatValue(type, (String)value)).collect(Collectors.toList());
        return ENUM_VALUESET_START + StringUtils.join(formattedValues, (String)ENUM_VALUESET_SEPARATOR_WITH_WHITESPACE) + ENUM_VALUESET_END;
    }

    @Override
    public String getCanonicalString() {
        if (this.isAbstract()) {
            return this.toStringAbstractEnumValueSet();
        }
        return ENUM_VALUESET_START + StringUtils.join(this.values, (String)ENUM_VALUESET_SEPARATOR_WITH_WHITESPACE) + ENUM_VALUESET_END;
    }

    private String toStringAbstractEnumValueSet() {
        String nullText = this.isContainsNull() ? MessageFormat.format(Messages.ValueSet_includingNull, IIpsModelExtensions.get().getModelPreferences().getNullPresentation()) : MessageFormat.format(Messages.ValueSet_excludingNull, IIpsModelExtensions.get().getModelPreferences().getNullPresentation());
        return MessageFormat.format(Messages.EnumValueSet_abstract, nullText);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.values.clear();
        this.valuesToIndexMap.clear();
        Element el = DescriptionHelper.getFirstNoneDescriptionElement(element);
        NodeList children = el.getElementsByTagName(XML_VALUE);
        int i = 0;
        while (i < children.getLength()) {
            Element valueEl = (Element)children.item(i);
            String value = ValueToXmlHelper.getValueFromElement((Element)valueEl, (String)XML_DATA);
            this.addValueWithoutTriggeringChangeEvent(value);
            ++i;
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        Document doc = element.getOwnerDocument();
        Element tagElement = doc.createElement(XML_TAG_ENUM);
        for (String value : this.values) {
            Element valueElement = doc.createElement(XML_VALUE);
            tagElement.appendChild(valueElement);
            ValueToXmlHelper.addValueToElement((String)value, (Element)valueElement, (String)XML_DATA);
        }
        element.appendChild(tagElement);
    }

    @Override
    public IValueSet copy(IValueSetOwner parent, String id) {
        EnumValueSet copy = new EnumValueSet(parent, id);
        copy.values = new ArrayList<String>(this.values);
        copy.refillValuesToIndexMap();
        return copy;
    }

    @Override
    public void copyPropertiesFrom(IValueSet source) {
        this.values.clear();
        this.values.addAll(((EnumValueSet)source).values);
        this.refillValuesToIndexMap();
        this.objectHasChanged();
    }

    @Override
    public void addValuesFromDatatype(EnumDatatype datatype) {
        String[] valueIds = datatype.getAllValueIds(true);
        this.addValues(Arrays.asList(valueIds));
    }

    @Override
    public boolean isContainsNull() {
        return this.values.contains(null);
    }

    @Override
    public void setContainsNull(boolean containsNull) {
        if (!this.isContainsNull() && containsNull) {
            this.addValue(null);
        } else if (!containsNull) {
            this.removeValue(null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Map<String, List<Integer>> getValuesToIndexMap() {
        return this.valuesToIndexMap;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.compareTo((IValueSet)obj) == 0;
    }

    @Override
    public int compareTo(IValueSet o) {
        if (o.isEnum()) {
            IEnumValueSet otherEnum = (IEnumValueSet)o;
            return this.compareValueSetValues(otherEnum);
        }
        return this.compareDifferentValueSets(o);
    }

    protected int compareValueSetValues(IEnumValueSet otherEnum) {
        ValueDatatype otherDatatype;
        ValueDatatype datatype = this.findValueDatatype(this.getIpsProject());
        if (!datatype.equals(otherDatatype = otherEnum.findValueDatatype(this.getIpsProject()))) {
            return datatype.compareTo((Object)otherDatatype);
        }
        ListComparator listComparator = ListComparator.listComparator((Comparator)new ValueComparator(datatype));
        return listComparator.compare(this.values, otherEnum.getValuesAsList());
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class ValueComparator
    implements Comparator<String> {
        private final ValueDatatype datatype;

        public ValueComparator(ValueDatatype datatype) {
            this.datatype = datatype;
        }

        @Override
        public int compare(String value, String otherValue) {
            if (this.datatype.supportsCompare() && this.datatype.isParsable(value) && this.datatype.isParsable(otherValue)) {
                return this.datatype.compare(value, otherValue);
            }
            return Comparator.nullsFirst(Comparator.naturalOrder()).compare(value, otherValue);
        }
    }
}

