/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.valueset.AbstractValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.EnumValueSet;
import org.faktorips.devtools.model.internal.valueset.Messages;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;

public class EnumValueSetValidator
extends AbstractValueSetValidator<EnumValueSet> {
    private MessageList list;

    public EnumValueSetValidator(EnumValueSet enumValueSet, IValueSetOwner owner, ValueDatatype datatype) {
        super(enumValueSet, owner, datatype);
    }

    @Override
    public MessageList validate() {
        this.list = new MessageList();
        if (this.isValidDatatype()) {
            this.validateNullValue();
            int numOfValues = ((EnumValueSet)this.getValueSet()).size();
            int i = 0;
            while (i < numOfValues) {
                this.validateValueWithoutDuplicateCheck(i);
                ++i;
            }
            this.checkForDuplicates();
        }
        return this.list;
    }

    private void validateNullValue() {
        if (this.getDatatype().isPrimitive() && ((EnumValueSet)this.getValueSet()).isContainsNull()) {
            String text = Messages.ValueSet_msgNullNotSupported;
            this.list.add(new Message("VALUESET-NullNotSupported", text, Message.ERROR, this.getValueSet(), new String[]{"containsNull"}));
        }
    }

    public MessageList validateValue(int index) {
        this.list = new MessageList();
        if (this.isValidDatatype()) {
            this.validateValueWithoutDuplicateCheck(index);
            if (this.list.getSeverity() != Message.ERROR) {
                this.checkForDuplicate(index);
            }
        }
        return this.list;
    }

    private boolean isValidDatatype() {
        if (this.getDatatype() == null) {
            String msg = MessageFormat.format(Messages.EnumValueSet_msgDatatypeUnknown, this.getOwner().getName());
            Severity severity = ((EnumValueSet)this.getValueSet()).getIpsProject().getReadOnlyProperties().getMissingDatatypeSeverity();
            this.list.add(new Message("VALUESET-UnknownDatatype", msg, severity, this.getParentOp()));
            return false;
        }
        return true;
    }

    private void validateValueWithoutDuplicateCheck(int index) {
        ObjectProperty op = new ObjectProperty(this.getValueSet(), "values", index);
        String value = ((EnumValueSet)this.getValueSet()).getValue(index);
        if (this.isSpecialNull(value, this.getDatatype())) {
            String msg = MessageFormat.format(Messages.EnumValueSet_msgValueNotParsable, this.getNotNullValue(value), this.getDatatype().getName());
            this.list.add(new Message("VALUESET-ValueNotParsable", msg, Message.ERROR, new ObjectProperty[]{op, this.getParentOp()}));
        }
        ValidationUtils.checkParsable(this.getDatatype(), value, this.getValueSet(), "values", this.list);
    }

    private void checkForDuplicate(int index) {
        String value = ((EnumValueSet)this.getValueSet()).getValue(index);
        if (this.getValuesToIndexMap().get(value).size() > 1) {
            ObjectProperty op = new ObjectProperty(this.getValueSet(), "values", index);
            this.list.add(this.createMsgForDuplicateValues(value, op));
        }
    }

    private Map<String, List<Integer>> getValuesToIndexMap() {
        return ((EnumValueSet)this.getValueSet()).getValuesToIndexMap();
    }

    private void checkForDuplicates() {
        for (String value : this.getValuesToIndexMap().keySet()) {
            List<Integer> indexes = this.getValuesToIndexMap().get(value);
            if (indexes.size() <= 1) continue;
            ArrayList<ObjectProperty> ops = new ArrayList<ObjectProperty>(indexes.size());
            ops.add(this.getParentOp());
            for (Integer index : indexes) {
                ops.add(new ObjectProperty(this.getValueSet(), "values", index.intValue()));
            }
            this.list.add(this.createMsgForDuplicateValues(value, ops.toArray(new ObjectProperty[ops.size()])));
        }
    }

    private Message createMsgForDuplicateValues(String value, ObjectProperty ... ops) {
        String msg = MessageFormat.format(Messages.EnumValueSet_msgDuplicateValue, this.getNotNullValue(value));
        return new Message("ENUMVALUESET-DuplicateValue", msg, Message.ERROR, ops);
    }

    private boolean isSpecialNull(String value, ValueDatatype datatype) {
        if (datatype.isPrimitive() || value == null) {
            return false;
        }
        return DatatypeUtil.isNullValue(datatype, value);
    }

    private String getNotNullValue(String value) {
        if (value == null) {
            return IIpsModelExtensions.get().getModelPreferences().getNullPresentation();
        }
        return value;
    }

    private ObjectProperty getParentOp() {
        return new ObjectProperty((Object)this.getOwner(), "valueSet");
    }
}

