/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ipsobject.DescriptionHelper;
import org.faktorips.devtools.model.internal.valueset.Messages;
import org.faktorips.devtools.model.internal.valueset.RangeValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.ValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.valueset.IEnumValueSet;
import org.faktorips.devtools.model.valueset.IRangeValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RangeValueSet
extends ValueSet
implements IRangeValueSet {
    public static final String XML_TAG_RANGE = "Range";
    private String lowerBound;
    private String upperBound;
    private String step;
    private boolean containsNull = false;
    private boolean empty = false;

    public RangeValueSet(IValueSetOwner parent, String partId) {
        this(parent, partId, null, null, null);
    }

    public RangeValueSet(IValueSetOwner parent, String partId, String lower, String upper, String step) {
        this(parent, partId, lower, upper, step, false);
    }

    public RangeValueSet(IValueSetOwner parent, String partId, String lower, String upper, String step, boolean containsNull) {
        super(ValueSetType.RANGE, parent, partId);
        this.lowerBound = lower;
        this.upperBound = upper;
        this.step = step;
        this.containsNull = containsNull;
    }

    public static RangeValueSet empty(IValueSetOwner parent, String partId) {
        RangeValueSet emptyRangeValueSet = new RangeValueSet(parent, partId);
        emptyRangeValueSet.empty = true;
        emptyRangeValueSet.containsNull = false;
        return emptyRangeValueSet;
    }

    @Override
    public void setLowerBound(String lowerBound) {
        String oldBound = this.lowerBound;
        this.lowerBound = lowerBound;
        this.valueChanged(oldBound, lowerBound);
        if (lowerBound != null && !lowerBound.isEmpty()) {
            this.setEmpty(false);
        }
    }

    @Override
    public void setStep(String step) {
        String oldStep = this.step;
        this.step = step;
        this.valueChanged(oldStep, step);
    }

    @Override
    public void setUpperBound(String upperBound) {
        String oldBound = this.upperBound;
        this.upperBound = upperBound;
        this.valueChanged(oldBound, upperBound);
        if (upperBound != null && !upperBound.isEmpty()) {
            this.setEmpty(false);
        }
    }

    @Override
    public String getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public String getUpperBound() {
        return this.upperBound;
    }

    @Override
    public String getStep() {
        return this.step;
    }

    @Override
    public boolean containsValue(String value, IIpsProject ipsProject) {
        ValueDatatype datatype = this.findValueDatatype(ipsProject);
        if (!(datatype instanceof NumericDatatype) || !this.isValid(ipsProject)) {
            return false;
        }
        return this.checkValueInRange(value, datatype);
    }

    private boolean checkValueInRange(String value, ValueDatatype datatype) {
        block8: {
            block7: {
                block6: {
                    try {
                        if (!this.isEmpty()) break block6;
                        return false;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
                if (DatatypeUtil.isNullValue(datatype, value)) {
                    return this.isContainsNull();
                }
                if (!this.isAbstract()) break block7;
                return true;
            }
            if ((DatatypeUtil.isNullValue(datatype, this.getLowerBound()) || datatype.compare(this.getLowerBound(), value) <= 0) && (DatatypeUtil.isNullValue(datatype, this.getUpperBound()) || datatype.compare(this.getUpperBound(), value) >= 0)) break block8;
            return false;
        }
        return this.isValueMatchStep(value, datatype);
    }

    private boolean isValueMatchStep(String value, ValueDatatype datatype) {
        String diff = value;
        NumericDatatype numDatatype = (NumericDatatype)datatype;
        if (!DatatypeUtil.isNullValue(datatype, this.getStep())) {
            diff = numDatatype.subtract(value, this.getLowerBound());
            return numDatatype.divisibleWithoutRemainder(diff, this.getStep());
        }
        return true;
    }

    @Override
    public boolean containsValueSet(IValueSet subset) {
        ValueDatatype subDatatype;
        IIpsProject contextProject = subset.getIpsProject();
        ValueDatatype datatype = this.findValueDatatype(contextProject);
        if (!Objects.equals(datatype, subDatatype = subset.findValueDatatype(contextProject)) || !this.checkValidRanges(subset, contextProject)) {
            return false;
        }
        if (subset.isEnum()) {
            return this.checkIsRangeSubset((IEnumValueSet)subset, (NumericDatatype)datatype);
        }
        return this.checkIsRangeSubset((IRangeValueSet)subset, (NumericDatatype)datatype);
    }

    private boolean checkValidRanges(IValueSet subset, IIpsProject contextProject) {
        return this.isValid(contextProject) && (subset.isRange() || subset.isEnum()) && subset.isValid(contextProject);
    }

    private boolean checkIsRangeSubset(IRangeValueSet subRange, NumericDatatype datatype) {
        String subUpper;
        String subLower;
        if (subRange.isEmpty()) {
            return true;
        }
        if (this.isEmpty() || !this.isContainsNull() && subRange.isContainsNull()) {
            return false;
        }
        if (this.isAbstract()) {
            return true;
        }
        if (subRange.isAbstract()) {
            return false;
        }
        String lower = this.getLowerBound();
        if (this.isMatchLowerBound(datatype, lower, subLower = subRange.getLowerBound())) {
            return false;
        }
        String upper = this.getUpperBound();
        if (this.isMatchUpperBound(upper, subUpper = subRange.getUpperBound(), datatype)) {
            return false;
        }
        return this.isSubrangeMatchStep(subRange, datatype);
    }

    private boolean checkIsRangeSubset(IEnumValueSet subRange, NumericDatatype datatype) {
        if (!this.isContainsNull() && subRange.isContainsNull()) {
            return false;
        }
        if (this.isAbstract()) {
            return true;
        }
        if (subRange.isAbstract()) {
            return false;
        }
        String[] stringArray = subRange.getValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!this.checkValueInRange(value, (ValueDatatype)datatype)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isMatchLowerBound(NumericDatatype datatype, String lower, String subLower) {
        return !DatatypeUtil.isNullValue((ValueDatatype)datatype, lower) && (DatatypeUtil.isNullValue((ValueDatatype)datatype, subLower) || datatype.compare(lower, subLower) > 0);
    }

    private boolean isMatchUpperBound(String upper, String subUpper, NumericDatatype datatype) {
        return !DatatypeUtil.isNullValue((ValueDatatype)datatype, upper) && (DatatypeUtil.isNullValue((ValueDatatype)datatype, subUpper) || datatype.compare(upper, subUpper) < 0);
    }

    private boolean isSubrangeMatchStep(IRangeValueSet other, NumericDatatype datatype) {
        String subStep = other.getStep();
        if (DatatypeUtil.isNullValue((ValueDatatype)datatype, this.step)) {
            return true;
        }
        if (DatatypeUtil.isNullValue((ValueDatatype)datatype, subStep) || !datatype.divisibleWithoutRemainder(subStep, this.step)) {
            return false;
        }
        return this.isSubBoundsMatchingStep(other, datatype);
    }

    private boolean isSubBoundsMatchingStep(IRangeValueSet other, NumericDatatype datatype) {
        String diffUpper;
        String lower = this.getLowerBound();
        String subLower = other.getLowerBound();
        String upper = this.getUpperBound();
        String subUpper = other.getUpperBound();
        String diffLower = datatype.subtract(subLower, lower);
        if (!datatype.divisibleWithoutRemainder(diffLower, this.step)) {
            return false;
        }
        return !DatatypeUtil.isNonNull((ValueDatatype)datatype, upper, subUpper) || datatype.divisibleWithoutRemainder(diffUpper = datatype.subtract(upper, subUpper), this.step);
    }

    protected RangeValueSetValidator createValidator(IValueSetOwner owner, ValueDatatype datatype) {
        return new RangeValueSetValidator(this, owner, datatype);
    }

    @Override
    public void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        RangeValueSetValidator validator = this.createValidator(this.getValueSetOwner(), this.findValueDatatype(ipsProject));
        list.add(validator.validate());
    }

    @Override
    public ValueSetType getValueSetType() {
        return ValueSetType.RANGE;
    }

    @Override
    public int compareTo(IValueSet o) {
        if (o.isRange()) {
            IRangeValueSet otherRangeValueSet = (IRangeValueSet)o;
            boolean thisContainsOther = this.containsValueSet(o);
            boolean otherContainsThis = o.containsValueSet(this);
            if (thisContainsOther && otherContainsThis) {
                return 0;
            }
            if (thisContainsOther) {
                return 1;
            }
            if (otherContainsThis) {
                return -1;
            }
            return this.compareDifferentRanges(otherRangeValueSet);
        }
        return this.compareDifferentValueSets(o);
    }

    private int compareDifferentRanges(IRangeValueSet otherRangeValueSet) {
        return Comparator.comparing(IRangeValueSet::getLowerBound).thenComparing(IRangeValueSet::getUpperBound).thenComparing(IRangeValueSet::getStep).compare(this, otherRangeValueSet);
    }

    @Override
    public String toString() {
        if (this.isAbstract()) {
            return String.valueOf(super.toString()) + "(abstract)";
        }
        return String.valueOf(super.toString()) + ":" + this.toShortString();
    }

    @Override
    public String toShortString() {
        return this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (!this.isEmpty()) {
            sb.append(this.lowerBound == null ? Messages.RangeValueSet_unlimited : this.lowerBound);
            sb.append(" ... ");
            sb.append(this.upperBound == null ? Messages.RangeValueSet_unlimited : this.upperBound);
            if (this.step != null) {
                sb.append(" / ");
                sb.append(this.step);
            }
        }
        sb.append("]");
        if (this.isContainsNull()) {
            sb.append(" (").append(MessageFormat.format(Messages.ValueSet_includingNull, IIpsModelExtensions.get().getModelPreferences().getNullPresentation())).append(")");
        }
        return sb.toString();
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        Element el = DescriptionHelper.getFirstNoneDescriptionElement(element);
        if (el.hasAttribute("lowerBound")) {
            this.lowerBound = el.getAttribute("lowerBound");
            if ("".equals(this.lowerBound)) {
                this.lowerBound = null;
            }
            this.upperBound = el.getAttribute("upperBound");
            if ("".equals(this.upperBound)) {
                this.upperBound = null;
            }
            this.step = el.getAttribute("step");
            if ("".equals(this.step)) {
                this.step = null;
            }
        } else {
            this.lowerBound = ValueToXmlHelper.getValueFromElement((Element)el, (String)StringUtils.capitalize((String)"lowerBound"));
            this.upperBound = ValueToXmlHelper.getValueFromElement((Element)el, (String)StringUtils.capitalize((String)"upperBound"));
            this.step = ValueToXmlHelper.getValueFromElement((Element)el, (String)StringUtils.capitalize((String)"step"));
        }
        this.containsNull = ValueToXmlHelper.isAttributeTrue((Element)el, (String)"containsNull");
        this.empty = ValueToXmlHelper.isAttributeTrue((Element)el, (String)"empty");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        Document doc = element.getOwnerDocument();
        Element tagElement = doc.createElement(XML_TAG_RANGE);
        tagElement.setAttribute("containsNull", Boolean.toString(this.isContainsNull()));
        ValueToXmlHelper.addValueToElement((String)this.lowerBound, (Element)tagElement, (String)StringUtils.capitalize((String)"lowerBound"));
        ValueToXmlHelper.addValueToElement((String)this.upperBound, (Element)tagElement, (String)StringUtils.capitalize((String)"upperBound"));
        ValueToXmlHelper.addValueToElement((String)this.step, (Element)tagElement, (String)StringUtils.capitalize((String)"step"));
        if (this.isEmpty()) {
            tagElement.setAttribute("empty", Boolean.toString(this.isEmpty()));
        }
        element.appendChild(tagElement);
    }

    @Override
    public IValueSet copy(IValueSetOwner parent, String id) {
        RangeValueSet retValue = new RangeValueSet(parent, id);
        retValue.lowerBound = this.lowerBound;
        retValue.upperBound = this.upperBound;
        retValue.step = this.step;
        retValue.containsNull = this.isContainsNull();
        retValue.empty = this.empty;
        return retValue;
    }

    @Override
    public void copyPropertiesFrom(IValueSet source) {
        RangeValueSet set = (RangeValueSet)source;
        this.lowerBound = set.lowerBound;
        this.upperBound = set.upperBound;
        this.step = set.step;
        this.containsNull = set.isContainsNull();
        this.empty = set.empty;
        this.objectHasChanged();
    }

    @Override
    public boolean isContainsNull() {
        return this.containsNull && this.isContainingNullAllowed(this.getIpsProject());
    }

    @Override
    public void setContainsNull(boolean containsNull) {
        boolean old = this.isContainsNull();
        this.containsNull = containsNull;
        this.valueChanged(old, containsNull, "containsNull");
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void setEmpty(boolean empty) {
        boolean oldEmpty = this.empty;
        this.empty = empty;
        this.valueChanged(oldEmpty, empty);
        if (empty) {
            this.setContainsNull(false);
            this.setLowerBound(null);
            this.setUpperBound(null);
            this.setStep(null);
        }
    }
}

