/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import java.text.MessageFormat;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.valueset.AbstractValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.Messages;
import org.faktorips.devtools.model.internal.valueset.RangeValueSet;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;

public class RangeValueSetValidator
extends AbstractValueSetValidator<RangeValueSet> {
    public RangeValueSetValidator(RangeValueSet valueSet, IValueSetOwner owner, ValueDatatype datatype) {
        super(valueSet, owner, datatype);
    }

    @Override
    public MessageList validate() {
        String range;
        MessageList messages = new MessageList();
        ObjectProperty parentObjectProperty = new ObjectProperty((Object)this.getOwner(), "valueSet");
        ObjectProperty lowerBoundProperty = new ObjectProperty(this.getValueSet(), "lowerBound");
        ObjectProperty upperBoundProperty = new ObjectProperty(this.getValueSet(), "upperBound");
        ObjectProperty stepProperty = new ObjectProperty(this.getValueSet(), "step");
        if (this.getDatatype() == null) {
            String text = Messages.Range_msgUnknownDatatype;
            messages.newError("VALUESET-UnknownDatatype", text, new ObjectProperty[]{parentObjectProperty, lowerBoundProperty, upperBoundProperty, stepProperty});
            return messages;
        }
        String lowerBound = ((RangeValueSet)this.getValueSet()).getLowerBound();
        String upperBound = ((RangeValueSet)this.getValueSet()).getUpperBound();
        String step = ((RangeValueSet)this.getValueSet()).getStep();
        ValueDatatype datatypeToValidate = this.getDatatypeOrWrapperForPrimitivDatatype(this.getDatatype());
        ValidationUtils.checkParsable(datatypeToValidate, lowerBound, this.getValueSet(), "lowerBound", messages);
        ValidationUtils.checkParsable(datatypeToValidate, upperBound, this.getValueSet(), "upperBound", messages);
        boolean stepParsable = ValidationUtils.checkParsable(datatypeToValidate, ((RangeValueSet)this.getValueSet()).getStep(), this.getValueSet(), "step", messages);
        NumericDatatype numDatatype = this.getAndValidateNumericDatatype(datatypeToValidate, messages);
        if (messages.containsErrorMsg()) {
            return messages;
        }
        if (DatatypeUtil.isNonNull((ValueDatatype)numDatatype, lowerBound, upperBound) && datatypeToValidate.compare(lowerBound, upperBound) > 0) {
            String text = Messages.Range_msgLowerboundGreaterUpperbound;
            messages.newError("RANGE-LBoundGreaterUBound", text, new ObjectProperty[]{parentObjectProperty, lowerBoundProperty, upperBoundProperty});
            return messages;
        }
        if (DatatypeUtil.isNullValue((ValueDatatype)numDatatype, lowerBound) && !DatatypeUtil.isNullValue((ValueDatatype)numDatatype, step)) {
            String msg = Messages.RangeValueSet_msgStepWithLowerNull;
            messages.newError("RANGE-stepRangeMissmatch", msg, new ObjectProperty[]{stepProperty, lowerBoundProperty});
        }
        if (stepParsable && DatatypeUtil.isNonNull((ValueDatatype)numDatatype, upperBound, lowerBound, step) && !numDatatype.divisibleWithoutRemainder(range = numDatatype.subtract(upperBound, lowerBound), step)) {
            String msg = MessageFormat.format(Messages.RangeValueSet_msgStepRangeMismatch, lowerBound, upperBound, step);
            messages.newError("RANGE-stepRangeMissmatch", msg, new ObjectProperty[]{parentObjectProperty, lowerBoundProperty, upperBoundProperty, stepProperty});
        }
        return messages;
    }

    private ValueDatatype getDatatypeOrWrapperForPrimitivDatatype(ValueDatatype datatype) {
        if (datatype.isPrimitive()) {
            return datatype.getWrapperType();
        }
        return datatype;
    }

    private NumericDatatype getAndValidateNumericDatatype(ValueDatatype datatype, MessageList list) {
        if (datatype instanceof NumericDatatype) {
            return (NumericDatatype)datatype;
        }
        String text = Messages.RangeValueSet_msgDatatypeNotNumeric;
        list.add(new Message("RANGE-notNumericDatatype", text, Message.ERROR, this.getValueSet()));
        return null;
    }
}

