/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ipsobject.DescriptionHelper;
import org.faktorips.devtools.model.internal.valueset.EnumValueSet;
import org.faktorips.devtools.model.internal.valueset.Messages;
import org.faktorips.devtools.model.internal.valueset.StringLengthValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.ValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.valueset.IStringLengthValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringLengthValueSet
extends ValueSet
implements IStringLengthValueSet {
    private String maximumLength;
    private boolean containsNull;

    public StringLengthValueSet(IValueSetOwner parent, String partId) {
        this(parent, partId, null);
    }

    public StringLengthValueSet(IValueSetOwner parent, String partId, String maximumLength) {
        this(parent, partId, maximumLength, false);
    }

    public StringLengthValueSet(IValueSetOwner parent, String partId, String maximumLength, boolean containsNull) {
        super(ValueSetType.STRINGLENGTH, parent, partId);
        this.maximumLength = maximumLength;
        this.containsNull = containsNull;
    }

    @Override
    public void setMaximumLength(String maximumLength) {
        String oldMax = this.maximumLength;
        this.maximumLength = maximumLength;
        this.valueChanged(oldMax, maximumLength);
    }

    @Override
    public String getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public Integer getParsedMaximumLength() {
        return this.maximumLength == null ? null : Integer.valueOf(Integer.parseInt(this.maximumLength));
    }

    @Override
    public boolean containsValue(String value, IIpsProject ipsProject) {
        if (IpsStringUtils.isBlank((String)value)) {
            return this.isContainsNull();
        }
        if (this.maximumLength == null) {
            return true;
        }
        return value.length() <= Integer.parseInt(this.maximumLength);
    }

    @Override
    public boolean containsValueSet(IValueSet subset) {
        if (subset.isDerived()) {
            return true;
        }
        if (subset.isStringLength()) {
            return this.compareTo(subset) >= 0;
        }
        if (subset.isEnum()) {
            return this.containsAllValues((EnumValueSet)subset);
        }
        return false;
    }

    private boolean containsAllValues(EnumValueSet subset) {
        String[] subsetValues;
        IIpsProject contextProject = subset.getIpsProject();
        String[] stringArray = subsetValues = subset.getValues();
        int n = subsetValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!this.containsValue(value, contextProject)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public IValueSet copy(IValueSetOwner newParent, String id) {
        return new StringLengthValueSet(newParent, id, this.maximumLength, this.containsNull);
    }

    @Override
    protected void copyPropertiesFrom(IValueSet source) {
        StringLengthValueSet src = (StringLengthValueSet)source;
        this.maximumLength = src.getMaximumLength();
        this.containsNull = src.isContainsNull();
        this.objectHasChanged();
    }

    @Override
    public String toShortString() {
        return this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return StringLengthValueSet.getCanonicalString(this.getMaximumLength(), this.isContainsNull());
    }

    public static String getCanonicalString(String maximumLength, boolean containsNull) {
        String limit = IpsStringUtils.isBlank((String)maximumLength) ? Messages.StringLength_unlimitedLength : maximumLength;
        StringBuilder sb = new StringBuilder(MessageFormat.format(Messages.StringLength_canonicalDesc, limit));
        if (containsNull) {
            sb.append(" (").append(MessageFormat.format(Messages.ValueSet_includingNull, IIpsModelExtensions.get().getModelPreferences().getNullPresentation())).append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean isContainsNull() {
        return this.containsNull;
    }

    @Override
    public void setContainsNull(boolean containsNull) {
        boolean old = this.isContainsNull();
        this.containsNull = containsNull;
        this.valueChanged(old, containsNull, "containsNull");
    }

    @Override
    public boolean isEmpty() {
        return this.maximumLength != null && Integer.parseInt(this.maximumLength) == 0;
    }

    @Override
    public int compareTo(IValueSet o) {
        if (!o.isStringLength()) {
            return this.compareDifferentValueSets(o);
        }
        String oLength = ((IStringLengthValueSet)o).getMaximumLength();
        int equality = oLength == null && this.maximumLength == null ? 0 : (oLength == null ? -1 : (this.maximumLength == null ? 1 : Integer.compare(Integer.parseInt(this.maximumLength), Integer.parseInt(oLength))));
        return equality == 0 ? this.compareContainsNull(o) : equality;
    }

    private int compareContainsNull(IValueSet o) {
        if (this.containsNull) {
            return o.isContainsNull() ? 0 : 1;
        }
        return o.isContainsNull() ? -1 : 0;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        Element el = DescriptionHelper.getFirstNoneDescriptionElement(element);
        this.maximumLength = ValueToXmlHelper.getValueFromElement((Element)el, (String)StringUtils.capitalize((String)"maximumLength"));
        this.containsNull = ValueToXmlHelper.isAttributeTrue((Element)el, (String)"containsNull");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        Document doc = element.getOwnerDocument();
        Element tagElement = doc.createElement("StringLength");
        tagElement.setAttribute("containsNull", Boolean.toString(this.isContainsNull()));
        ValueToXmlHelper.addValueToElement((String)this.maximumLength, (Element)tagElement, (String)"MaximumLength");
        element.appendChild(tagElement);
    }

    protected StringLengthValueSetValidator createValidator(IValueSetOwner owner, ValueDatatype datatype) {
        return new StringLengthValueSetValidator(this, owner, datatype);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        StringLengthValueSetValidator validator = this.createValidator(this.getValueSetOwner(), this.findValueDatatype(ipsProject));
        list.add(validator.validate());
    }
}

