/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.valueset.AbstractValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.Messages;
import org.faktorips.devtools.model.internal.valueset.StringLengthValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.runtime.MessageList;

public class StringLengthValueSetValidator
extends AbstractValueSetValidator<StringLengthValueSet> {
    public StringLengthValueSetValidator(StringLengthValueSet valueSet, IValueSetOwner owner, ValueDatatype datatype) {
        super(valueSet, owner, datatype);
    }

    @Override
    public MessageList validate() {
        MessageList messages = new MessageList();
        String maxLengthValue = ((StringLengthValueSet)this.getValueSet()).getMaximumLength();
        if (this.getDatatype() == null) {
            messages.newError("VALUESET-UnknownDatatype", Messages.EnumValueSet_msgDatatypeUnknown, this.getValueSet(), new String[]{"maximumLength"});
            return messages;
        }
        if (ValidationUtils.checkParsable((ValueDatatype)Datatype.INTEGER, maxLengthValue, this.getValueSet(), "maximumLength", messages)) {
            Integer maxLength;
            Integer n = maxLength = maxLengthValue == null ? null : Integer.valueOf(Integer.parseInt(maxLengthValue));
            if (maxLength != null && maxLength < 0) {
                messages.newError("STRINGLENGTH-negativeValue", Messages.StringLength_msgNegativeValue, (Object)"maximumLength", new String[0]);
            }
        }
        return messages;
    }
}

