/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ipsobject.DescriptionHelper;
import org.faktorips.devtools.model.internal.valueset.AbstractValueSetValidator;
import org.faktorips.devtools.model.internal.valueset.ValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.valueset.IUnrestrictedValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.Messages;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnrestrictedValueSet
extends ValueSet
implements IUnrestrictedValueSet {
    public static final String XML_TAG_UNRESTRICTED = "AllValues";
    private boolean containsNull = true;

    public UnrestrictedValueSet(IValueSetOwner parent, String partId) {
        super(ValueSetType.UNRESTRICTED, parent, partId);
    }

    public UnrestrictedValueSet(IValueSetOwner parent, String partId, boolean containsNull) {
        super(ValueSetType.UNRESTRICTED, parent, partId);
        this.containsNull = containsNull;
    }

    @Override
    public String toShortString() {
        return this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        if (this.isContainsNull()) {
            return Messages.ValueSetFormat_unrestricted;
        }
        return Messages.ValueSet_unrestrictedWithoutNull;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.toShortString();
    }

    @Override
    public boolean containsValue(String value, IIpsProject ipsProject) {
        ValueDatatype datatype = this.findValueDatatype(ipsProject);
        if (datatype == null || !datatype.isParsable(value)) {
            return false;
        }
        if (DatatypeUtil.isNullValue(datatype, value)) {
            return this.isContainsNull();
        }
        return true;
    }

    @Override
    public boolean containsValueSet(IValueSet subset) {
        IIpsProject contextProject = subset.getIpsProject();
        ValueDatatype datatype = this.findValueDatatype(contextProject);
        ValueDatatype subDatatype = subset.findValueDatatype(contextProject);
        if (!DatatypeUtil.isCovariant(subDatatype, datatype)) {
            return false;
        }
        return this.isContainsNull() || !subset.isContainsNull() || subset.isDerived();
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        Element el = DescriptionHelper.getFirstNoneDescriptionElement(element);
        if (el.hasAttribute("containsNull")) {
            this.containsNull = ValueToXmlHelper.isAttributeTrue((Element)el, (String)"containsNull");
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        Document doc = element.getOwnerDocument();
        Element tagElement = doc.createElement(XML_TAG_UNRESTRICTED);
        tagElement.setAttribute("containsNull", Boolean.toString(this.isContainsNull()));
        element.appendChild(tagElement);
    }

    @Override
    public IValueSet copy(IValueSetOwner parent, String id) {
        return new UnrestrictedValueSet(parent, id, this.isContainsNull());
    }

    @Override
    public void copyPropertiesFrom(IValueSet target) {
        this.containsNull = target.isContainsNull();
        this.objectHasChanged();
    }

    @Override
    public boolean isContainsNull() {
        return this.containsNull && this.isContainingNullAllowed(this.getIpsProject());
    }

    @Override
    public void setContainsNull(boolean containsNull) {
        boolean oldContainsNull = this.isContainsNull();
        this.containsNull = containsNull;
        this.valueChanged(oldContainsNull, containsNull, "containsNull");
    }

    @Override
    protected AbstractValueSetValidator<?> createValidator(IValueSetOwner owner, ValueDatatype datatype) {
        return new AbstractValueSetValidator<ValueSet>((ValueSet)this, owner, datatype){

            @Override
            public MessageList validate() {
                return new MessageList();
            }
        };
    }

    @Override
    public int compareTo(IValueSet o) {
        if (o.isUnrestricted()) {
            if (this.isContainsNull() == o.isContainsNull()) {
                return 0;
            }
            if (this.isContainsNull()) {
                return -1;
            }
            return 1;
        }
        return this.compareDifferentValueSets(o);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

