/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.valueset;

import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.valueset.AbstractValueSetValidator;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ValueSet
extends AtomicIpsObjectPart
implements IValueSet {
    public static final String XML_TAG = "ValueSet";
    private boolean abstractFlag = false;
    private ValueSetType type;

    protected ValueSet(ValueSetType type, IValueSetOwner parent, String partId) {
        super(parent, partId);
        this.type = type;
    }

    @Override
    public IValueSetOwner getValueSetOwner() {
        return (IValueSetOwner)super.getParent();
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public ValueSetType getValueSetType() {
        return this.type;
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(XML_TAG);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        String abstractString = element.getAttribute("abstract");
        this.abstractFlag = IpsStringUtils.isNotEmpty((String)abstractString) ? Boolean.parseBoolean(element.getAttribute("abstract")) : false;
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.abstractFlag) {
            element.setAttribute("abstract", Boolean.toString(this.abstractFlag));
        }
    }

    protected String getProperty(String original, String alternative) {
        if (original == null) {
            return alternative;
        }
        return original;
    }

    @Deprecated
    public ValueDatatype getValueDatatype() {
        return this.findValueDatatype(this.getIpsProject());
    }

    @Override
    public ValueDatatype findValueDatatype(IIpsProject ipsProject) {
        return this.getValueSetOwner().findValueDatatype(ipsProject);
    }

    @Override
    public final void setValuesOf(IValueSet source) {
        if (source == null) {
            return;
        }
        if (!this.isUnrestricted()) {
            this.abstractFlag = source.isAbstract();
        }
        if (this.getValueSetType().equals((Object)source.getValueSetType())) {
            this.copyPropertiesFrom(source);
        }
    }

    protected abstract void copyPropertiesFrom(IValueSet var1);

    @Override
    public void setAbstract(boolean isAbstract) {
        if (this.isUnrestricted() && isAbstract) {
            throw new RuntimeException("Can't set an unrestricted value set to abstract!");
        }
        boolean abstractOld = this.isAbstract();
        this.abstractFlag = isAbstract;
        this.valueChanged(abstractOld, this.isAbstract());
    }

    @Override
    public boolean isAbstract() {
        return this.abstractFlag;
    }

    @Override
    public boolean isDetailedSpecificationOf(IValueSet otherValueSet) {
        if (otherValueSet.isUnrestricted() || otherValueSet.isDerived() || otherValueSet.isStringLength()) {
            return otherValueSet.containsValueSet(this);
        }
        if (this.isEnum() && otherValueSet.isRange() && this.getIpsProject().getIpsArtefactBuilderSet().usesUnifiedValueSets()) {
            return otherValueSet.containsValueSet(this);
        }
        if (!this.getValueSetType().equals((Object)otherValueSet.getValueSetType())) {
            return false;
        }
        return otherValueSet.containsValueSet(this);
    }

    @Override
    public boolean isSameTypeOfValueSet(IValueSet other) {
        if (other == null) {
            return false;
        }
        return this.getValueSetType().equals((Object)other.getValueSetType());
    }

    @Override
    public boolean isUnrestricted() {
        return this.getValueSetType().isUnrestricted();
    }

    @Override
    public boolean isEnum() {
        return this.getValueSetType().isEnum();
    }

    @Override
    public boolean canBeUsedAsSupersetForAnotherEnumValueSet() {
        return this.isEnum() && !this.isAbstract();
    }

    @Override
    public boolean isRange() {
        return this.getValueSetType().isRange();
    }

    @Override
    public boolean isAbstractAndNotUnrestricted() {
        return !this.isUnrestricted() && this.isAbstract();
    }

    protected boolean isContainingNullAllowed(IIpsProject ipsProject) {
        ValueDatatype dataType = this.findValueDatatype(ipsProject);
        return dataType == null || !dataType.isPrimitive();
    }

    protected int compareDifferentValueSets(IValueSet o) {
        if (this.isDerived()) {
            return -2;
        }
        if (o.isDerived()) {
            return 2;
        }
        if (this.isUnrestricted() || (this.isEnum() || this.isStringLength()) && !o.isUnrestricted()) {
            return -1;
        }
        return 1;
    }

    protected abstract AbstractValueSetValidator<?> createValidator(IValueSetOwner var1, ValueDatatype var2);
}

