/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.versionmanager.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.model.internal.versionmanager.util.RequireBundleChanger;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;

public class ManifestUtil {
    private final Manifest manifest;
    private final AFile file;

    ManifestUtil(AFile file, ManifestFactory manifestFactory) throws IOException {
        ArgumentCheck.notNull((Object)file);
        ArgumentCheck.notNull((Object)manifestFactory);
        this.file = file;
        this.manifest = manifestFactory.loadManifest(file);
    }

    public static ManifestUtil createMigrationManifestUtil(IIpsProject ipsProject) throws IOException {
        ArgumentCheck.notNull((Object)ipsProject);
        ArgumentCheck.notNull((Object)ipsProject.getProject());
        AFile file = ipsProject.getProject().getFile("META-INF/MANIFEST.MF");
        return new ManifestUtil(file, new ManifestFactory());
    }

    public void setPluginDependency(String plugin, VersionRange versionRange) {
        ArgumentCheck.notNull((Object)plugin);
        ArgumentCheck.notNull((Object)versionRange);
        RequireBundleChanger bundleChanger = new RequireBundleChanger(this.manifest.getMainAttributes());
        bundleChanger.changePluginDependency(plugin, versionRange);
    }

    public void writeManifest() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.manifest.write(outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        this.file.setContents((InputStream)inputStream, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public static class ManifestFactory {
        public Manifest loadManifest(AFile file) throws IOException {
            return new Manifest(file.getContents());
        }
    }
}

