/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.versionmanager.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.versionmanager.util.RequireBundleManifestElement;
import org.osgi.framework.BundleException;

public class RequireBundleChanger {
    private static final String COMMA = ",";
    private final Attributes attributes;
    private final StringBuffer buffer;
    private final Map<String, RequireBundleManifestElement> requireBundles;

    public RequireBundleChanger(Attributes attributes) {
        this.attributes = attributes;
        this.buffer = new StringBuffer();
        this.requireBundles = new LinkedHashMap<String, RequireBundleManifestElement>();
    }

    public void changePluginDependency(String plugin, VersionRange versionRange) {
        String requireBundle = this.attributes.getValue("Require-Bundle");
        if (requireBundle != null) {
            try {
                ManifestElement[] elements;
                ManifestElement[] manifestElementArray = elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requireBundle);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement manifestElement = manifestElementArray[n2];
                    RequireBundleManifestElement editManifestElement = new RequireBundleManifestElement(manifestElement);
                    this.requireBundles.put(editManifestElement.getPluginName(), editManifestElement);
                    ++n2;
                }
            }
            catch (BundleException be) {
                throw new IpsException(be.getMessage());
            }
        }
        this.modifyMap(plugin, versionRange);
        this.attributes.putValue("Require-Bundle", this.getRequireDependencies());
    }

    private void modifyMap(String plugin, VersionRange versionRange) {
        if (this.requireBundles.containsKey(plugin)) {
            RequireBundleManifestElement requireBundleManifestElement = this.requireBundles.get(plugin);
            requireBundleManifestElement.setVersionRange(versionRange);
        } else {
            this.requireBundles.put(plugin, new RequireBundleManifestElement(plugin, versionRange));
        }
    }

    private String getRequireDependencies() {
        for (RequireBundleManifestElement reElement : this.requireBundles.values()) {
            this.appendSeparator();
            this.append(reElement.getManifestElement());
        }
        return this.buffer.toString();
    }

    private void append(String appendString) {
        this.buffer.append(appendString);
    }

    private void appendSeparator() {
        if (this.buffer.length() > 0) {
            this.buffer.append(COMMA);
        }
    }
}

