/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.versionmanager.util;

import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.faktorips.util.ArgumentCheck;

public class RequireBundleManifestElement {
    private static final String EQUAL = "=";
    private static final String SEMICOLON = ";";
    private static final String QUOTES = "\"";
    private static final String COLON_EQUAL = ":=";
    private ManifestElement manifestElement;
    private VersionRange versionRange;
    private final String pluginName;

    public RequireBundleManifestElement(ManifestElement manifestElement) {
        ArgumentCheck.notNull((Object)manifestElement);
        this.manifestElement = manifestElement;
        this.pluginName = manifestElement.getValue();
    }

    public RequireBundleManifestElement(String pluginName, VersionRange versionRange) {
        this.pluginName = pluginName;
        this.setVersionRange(versionRange);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setVersionRange(VersionRange versionRange) {
        ArgumentCheck.notNull((Object)versionRange);
        this.versionRange = versionRange;
    }

    public String getManifestElement() {
        if (this.versionRange != null) {
            return this.getChangedManifestElement();
        }
        return this.getOriginalManifestElement();
    }

    private String getOriginalManifestElement() {
        return this.manifestElement.toString();
    }

    private String getChangedManifestElement() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.pluginName);
        builder.append(this.appendBundleVersion());
        builder.append(this.fillDirective("visibility"));
        builder.append(this.fillDirective("resolution"));
        return builder.toString();
    }

    private String getDirective(String key) {
        if (this.manifestElement != null) {
            return this.manifestElement.getDirective(key);
        }
        return null;
    }

    private String getDirectiveString(String key) {
        return SEMICOLON + key + COLON_EQUAL + this.getDirective(key);
    }

    private boolean hasDirective(String key) {
        return this.getDirective(key) != null;
    }

    private String fillDirective(String key) {
        if (this.hasDirective(key)) {
            return this.getDirectiveString(key);
        }
        return "";
    }

    private String appendBundleVersion() {
        StringBuilder builder = new StringBuilder();
        builder.append(SEMICOLON);
        builder.append("bundle-version");
        builder.append(EQUAL);
        builder.append(QUOTES);
        builder.append(this.versionRange.toString());
        builder.append(QUOTES);
        return builder.toString();
    }
}

