/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.ipsobject;

import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.enums.EnumContent;
import org.faktorips.devtools.model.internal.enums.EnumType;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.pctype.PolicyCmptType;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmpt;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptType;
import org.faktorips.devtools.model.internal.tablecontents.TableContents;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.internal.testcase.TestCase;
import org.faktorips.devtools.model.internal.testcasetype.TestCaseType;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.Messages;
import org.faktorips.util.ArgumentCheck;

public class IpsObjectType {
    public static final IpsObjectType ENUM_CONTENT = new IpsObjectType("EnumContent", "EnumContent", Messages.IpsObjectType_nameEnumContent, Messages.IpsObjectType_nameEnumContentPlural, "ipsenumcontent", false, true, EnumContent.class);
    public static final IpsObjectType ENUM_TYPE = new IpsObjectType("EnumType", "EnumType", Messages.IpsObjectType_nameEnumType, Messages.IpsObjectType_nameEnumTypePlural, "ipsenumtype", false, false, EnumType.class);
    public static final IpsObjectType POLICY_CMPT_TYPE = new IpsObjectType("PolicyCmptType", "PolicyCmptType", Messages.IpsObjectType_namePolicyClass, Messages.IpsObjectType_namePolicyClassPlural, "ipspolicycmpttype", true, false, PolicyCmptType.class);
    public static final IpsObjectType PRODUCT_CMPT_TYPE = new IpsObjectType("ProductCmptType2", "ProductCmptType2", Messages.IpsObjectType_nameProductClass, Messages.IpsObjectType_nameProductClassPlural, "ipsproductcmpttype", true, false, ProductCmptType.class);
    public static final IpsObjectType TABLE_STRUCTURE = new IpsObjectType("TableStructure", "TableStructure", Messages.IpsObjectType_nameTableStructure, Messages.IpsObjectType_nameTableStructurePlural, "ipstablestructure", false, false, TableStructure.class);
    public static final IpsObjectType PRODUCT_CMPT = new IpsObjectType("ProductCmpt", "ProductCmpt", Messages.IpsObjectType_nameProductComponent, Messages.IpsObjectType_nameProductComponentPlural, "ipsproduct", false, true, ProductCmpt.class);
    public static final IpsObjectType PRODUCT_TEMPLATE = new IpsObjectType("ProductTemplate", "ProductCmpt", Messages.IpsObjectType_nameProductTemplate, Messages.IpsObjectType_nameProductTemplatePlural, "ipstemplate", false, true, ProductCmpt.class);
    public static final IpsObjectType TABLE_CONTENTS = new IpsObjectType("TableContents", "TableContents", Messages.IpsObjectType_nameTableContents, Messages.IpsObjectType_nameTableContentsPlural, "ipstablecontents", false, true, TableContents.class);
    public static final IpsObjectType TEST_CASE_TYPE = new IpsObjectType("TestCaseType", "TestCaseType", Messages.IpsObjectType_nameTestCaseType, Messages.IpsObjectType_nameTestCaseTypePlural, "ipstestcasetype", false, false, TestCaseType.class);
    public static final IpsObjectType TEST_CASE = new IpsObjectType("TestCase", "TestCase", Messages.IpsObjectType_nameTestCase, Messages.IpsObjectType_nameTestCasePlural, "ipstestcase", false, true, TestCase.class);
    public static final IpsObjectType IPS_SOURCE_FILE = new IpsObjectType("Unknown", "Unknown", "Ips Source file", "Ips Source files", "*", false, true, null);
    private final String displayName;
    private final String displayNamePlural;
    private final String id;
    private final String xmlElementName;
    private final String fileExtension;
    private final boolean datatype;
    private final boolean productDefinitionType;
    private final Class<? extends IpsObject> implementingClass;

    protected IpsObjectType(String id, String xmlElementName, String displayName, String displayNamePlural, String fileExtension, boolean datatype, boolean productDefinitionType, Class<? extends IpsObject> implementingClass) {
        ArgumentCheck.notNull((Object)xmlElementName);
        ArgumentCheck.notNull((Object)id);
        ArgumentCheck.notNull((Object)fileExtension);
        this.id = id;
        this.xmlElementName = xmlElementName;
        this.displayName = displayName;
        this.displayNamePlural = displayNamePlural;
        this.fileExtension = fileExtension;
        this.datatype = datatype;
        this.productDefinitionType = productDefinitionType;
        this.implementingClass = implementingClass;
    }

    public static final IpsObjectType getTypeForExtension(String fileExtension) {
        IpsObjectType[] ipsObjectTypeArray = IIpsModel.get().getIpsObjectTypes();
        int n = ipsObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType currentType = ipsObjectTypeArray[n2];
            if (currentType.fileExtension.equals(fileExtension)) {
                return currentType;
            }
            ++n2;
        }
        return null;
    }

    public static final IpsObjectType getTypeForName(String name) {
        ArgumentCheck.notNull((Object)name);
        IpsObjectType[] ipsObjectTypeArray = IIpsModel.get().getIpsObjectTypes();
        int n = ipsObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType currentType = ipsObjectTypeArray[n2];
            if (currentType.id.equals(name)) {
                return currentType;
            }
            ++n2;
        }
        return null;
    }

    public IIpsObject newObject(IIpsSrcFile file) {
        if (this == POLICY_CMPT_TYPE) {
            return new PolicyCmptType(file);
        }
        if (this == PRODUCT_CMPT_TYPE) {
            return new ProductCmptType(file);
        }
        if (this == TABLE_STRUCTURE) {
            return new TableStructure(file);
        }
        if (this == PRODUCT_CMPT || this == PRODUCT_TEMPLATE) {
            return new ProductCmpt(file);
        }
        if (this == TABLE_CONTENTS) {
            return new TableContents(file);
        }
        if (this == TEST_CASE_TYPE) {
            return new TestCaseType(file);
        }
        if (this == TEST_CASE) {
            return new TestCase(file);
        }
        if (this == ENUM_TYPE) {
            return new EnumType(file);
        }
        if (this == ENUM_CONTENT) {
            return new EnumContent(file);
        }
        throw new RuntimeException("Can't create object for type " + this);
    }

    public final String getId() {
        return this.id;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNamePlural() {
        return this.displayNamePlural;
    }

    public final String getXmlElementName() {
        return this.xmlElementName;
    }

    public final String getFileExtension() {
        return this.fileExtension;
    }

    public boolean isDatatype() {
        return this.datatype;
    }

    public boolean isEntityType() {
        return this == POLICY_CMPT_TYPE || this == PRODUCT_CMPT_TYPE;
    }

    public boolean isProductDefinitionType() {
        return this.productDefinitionType;
    }

    public final String getFileName(String ipsObjectName) {
        ArgumentCheck.notNull((Object)ipsObjectName);
        return String.valueOf(ipsObjectName) + "." + this.fileExtension;
    }

    public final String toString() {
        return "IpsObjectTyp: " + this.displayName;
    }

    public Class<? extends IpsObject> getImplementingClass() {
        return this.implementingClass;
    }
}

