/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.ipsobject;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsMetaClass;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.plugin.IpsStatus;

public class IpsSrcFileCollection {
    private Map<IIpsSrcFile, CollectionItem> collection = new HashMap<IIpsSrcFile, CollectionItem>();

    public IpsSrcFileCollection(Collection<IIpsSrcFile> srcFiles) {
        this(srcFiles, null);
    }

    public IpsSrcFileCollection(Collection<IIpsSrcFile> metaObjectsSrcFiles, IIpsMetaClass metaClass) {
        this.initItems(metaObjectsSrcFiles, metaClass);
    }

    public String getDefiningMetaClass(IIpsSrcFile srcFile) {
        return this.getItem(srcFile).getDefiningMetaClass();
    }

    public boolean isDuplicateName(IIpsSrcFile srcFile) {
        return this.getItem(srcFile).isDuplicateName();
    }

    public boolean isInstanceOfMetaClass(IIpsSrcFile srcFile) {
        return this.getItem(srcFile).isInstanceOfMetaClass();
    }

    private CollectionItem getItem(IIpsSrcFile srcFile) {
        CollectionItem item = this.collection.get(srcFile);
        if (item == null) {
            throw new IpsException((IStatus)new IpsStatus("The given source file " + srcFile + " is not part of this collection"));
        }
        return item;
    }

    private void initItems(Collection<IIpsSrcFile> metaObjectsSrcFiles, IIpsMetaClass baseMetaClass) {
        String metaClassName = null;
        if (baseMetaClass != null) {
            metaClassName = baseMetaClass.getQualifiedName();
        }
        HashMap<String, CollectionItem> itemsByName = new HashMap<String, CollectionItem>();
        for (IIpsSrcFile file : metaObjectsSrcFiles) {
            CollectionItem item = (CollectionItem)itemsByName.get(file.getName());
            CollectionItem newItem = new CollectionItem();
            this.collection.put(file, newItem);
            newItem.setDefiningMetaClass(this.getMetaClassName(file));
            if (item == null) {
                newItem.setDuplicateName(false);
                itemsByName.put(file.getName(), newItem);
            } else {
                newItem.setDuplicateName(true);
                item.setDuplicateName(true);
            }
            if (metaClassName == null) continue;
            newItem.setInstanceOfMetaClass(metaClassName.equals(newItem.getDefiningMetaClass()));
        }
    }

    private String getMetaClassName(IIpsSrcFile srcFile) {
        if (srcFile.getIpsObjectType().equals(IpsObjectType.PRODUCT_CMPT) || srcFile.getIpsObjectType().equals(IpsObjectType.PRODUCT_TEMPLATE)) {
            return srcFile.getPropertyValue("productCmptType");
        }
        if (srcFile.getIpsObjectType().equals(IpsObjectType.ENUM_CONTENT)) {
            return srcFile.getPropertyValue("enumType");
        }
        if (srcFile.getIpsObjectType().equals(IpsObjectType.TABLE_CONTENTS)) {
            return srcFile.getPropertyValue("tableStructure");
        }
        if (srcFile.getIpsObjectType().equals(IpsObjectType.TEST_CASE_TYPE)) {
            return srcFile.getPropertyValue("testCaseType");
        }
        return null;
    }

    private static class CollectionItem {
        private String definingMetaClass;
        private boolean duplicateName = false;
        private boolean instanceOfMetaClass = false;

        private CollectionItem() {
        }

        public String getDefiningMetaClass() {
            return this.definingMetaClass;
        }

        public void setDefiningMetaClass(String definingMetaClass) {
            this.definingMetaClass = definingMetaClass;
        }

        public boolean isDuplicateName() {
            return this.duplicateName;
        }

        public void setDuplicateName(boolean duplicateName) {
            this.duplicateName = duplicateName;
        }

        public boolean isInstanceOfMetaClass() {
            return this.instanceOfMetaClass;
        }

        public void setInstanceOfMetaClass(boolean instanceOfMetaClass) {
            this.instanceOfMetaClass = instanceOfMetaClass;
        }
    }
}

