/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.ipsobject;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class IpsSrcFileSaxHelper {
    public static Map<String, String> getHeaderAttributes(IIpsSrcFile file) {
        AttributeReadHandler handler = new AttributeReadHandler(file.getIpsObjectType().getXmlElementName());
        IpsSrcFileSaxHelper.parseContent(file, handler);
        return handler.getAttributeValue();
    }

    private static void parseContent(IIpsSrcFile ipsSrcFile, AttributeReadHandler handler) {
        if (!ipsSrcFile.exists()) {
            return;
        }
        InputStream is = ipsSrcFile.getContentFromEnclosingResource();
        try {
            try {
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                saxParser.parse(new InputSource(is), (DefaultHandler)handler);
            }
            catch (SAXFinishedException saxParser) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Exception e) {
                throw new IpsException((IStatus)new IpsStatus(e));
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class AttributeReadHandler
    extends DefaultHandler {
        private String xmlRootElementName;
        private Map<String, String> attributeValue = new HashMap<String, String>(10);

        public AttributeReadHandler(String xmlRootElementName) {
            Assert.isNotNull((Object)xmlRootElementName);
            this.xmlRootElementName = xmlRootElementName;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.xmlRootElementName.equals(qName)) {
                int numOfattributes = attributes.getLength();
                int i = 0;
                while (i < numOfattributes) {
                    this.attributeValue.put(attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
                throw new SAXFinishedException();
            }
        }

        public Map<String, String> getAttributeValue() {
            return this.attributeValue;
        }
    }

    private static class SAXFinishedException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public SAXFinishedException() {
            super("Parser finished");
        }
    }
}

